# pnap-network-api
Use the Networks API to create, list, edit, and delete private networks to best fit your business needs.
Private networks allow your servers to communicate without connecting to the public internet, avoiding unnecessary
egress data charges.<br>
<br>
<span class='pnap-api-knowledge-base-link'>
Knowledge base articles to help you can be found
<a href='https://phoenixnap.com/kb/bmc-server-management-via-api#multi-private-backend-network-api' target='_blank'>here</a>
</span><br>
<br>
<b>All URLs are relative to (https://api.phoenixnap.com/networks/v1/)</b>


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0
For more information, please visit [https://phoenixnap.com/](https://phoenixnap.com/)

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

You can install this package directly from the [Python Package Index](https://pypi.org/) using:

```sh
pip install pnap_network_api
```

Then import the package:
```python
import pnap_network_api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pnap_network_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import pnap_network_api
from pprint import pprint
from pnap_network_api.api import private_networks_api
from pnap_network_api.model.error import Error
from pnap_network_api.model.private_network import PrivateNetwork
from pnap_network_api.model.private_network_create import PrivateNetworkCreate
from pnap_network_api.model.private_network_modify import PrivateNetworkModify
# Defining the host is optional and defaults to https://api.phoenixnap.com/networks/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = pnap_network_api.Configuration(
    host = "https://api.phoenixnap.com/networks/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure OAuth2 access token for authorization: OAuth2
configuration = pnap_network_api.Configuration(
    host = "https://api.phoenixnap.com/networks/v1"
)
configuration.access_token = 'YOUR_ACCESS_TOKEN'


# Enter a context with an instance of the API client
with pnap_network_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = private_networks_api.PrivateNetworksApi(api_client)
    location = "PHX" # str | If present will filter the result by the given location of the Private Networks. (optional)

    try:
        # List Private Networks.
        api_response = api_instance.private_networks_get(location=location)
        pprint(api_response)
    except pnap_network_api.ApiException as e:
        print("Exception when calling PrivateNetworksApi->private_networks_get: %s\n" % e)
```
To generate a token using the [python-keycloak](https://pypi.org/project/python-keycloak/) library:

```python
from keycloak import KeycloakOpenID

clientId = "YOUR_CLIENT_ID"
clientSecret = "YOUR_CLIENT_SECRET"
serverUrl = "https://auth.phoenixnap.com/auth/"
realmName = "BMC"
grantType = "client_credentials"

keycloakOpenId =  KeycloakOpenID(server_url=serverUrl,
                        realm_name=realmName,
                        client_id=clientId,
                        client_secret_key=clientSecret)

ACCESS_TOKEN = keycloakOpenId.token(grant_type=grantType)['access_token']
```

## Documentation for API Endpoints

All URIs are relative to *https://api.phoenixnap.com/networks/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*PrivateNetworksApi* | [**private_networks_get**](docs/PrivateNetworksApi.md#private_networks_get) | **GET** /private-networks | List Private Networks.
*PrivateNetworksApi* | [**private_networks_network_id_delete**](docs/PrivateNetworksApi.md#private_networks_network_id_delete) | **DELETE** /private-networks/{privateNetworkId} | Delete a Private Network.
*PrivateNetworksApi* | [**private_networks_network_id_get**](docs/PrivateNetworksApi.md#private_networks_network_id_get) | **GET** /private-networks/{privateNetworkId} | Get a Private Network.
*PrivateNetworksApi* | [**private_networks_network_id_put**](docs/PrivateNetworksApi.md#private_networks_network_id_put) | **PUT** /private-networks/{privateNetworkId} | Update a Private Network.
*PrivateNetworksApi* | [**private_networks_post**](docs/PrivateNetworksApi.md#private_networks_post) | **POST** /private-networks | Create a Private Network.


## Documentation For Models

 - [Error](docs/Error.md)
 - [PrivateNetwork](docs/PrivateNetwork.md)
 - [PrivateNetworkCreate](docs/PrivateNetworkCreate.md)
 - [PrivateNetworkModify](docs/PrivateNetworkModify.md)
 - [PrivateNetworkServer](docs/PrivateNetworkServer.md)


## Documentation For Authorization


## OAuth2

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 
 - **bmc**: Grants full access to bmc-api.
 - **bmc.read**: Grants read only access to bmc-api.


## Author

support@phoenixnap.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in pnap_network_api.apis and pnap_network_api.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from pnap_network_api.api.default_api import DefaultApi`
- `from pnap_network_api.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import pnap_network_api
from pnap_network_api.apis import *
from pnap_network_api.models import *
```