# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models import util


class ResourceList(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, cpu: str=None, gpu: str=None, memory: str=None):  # noqa: E501
        """ResourceList - a model defined in Swagger

        :param cpu: The cpu of this ResourceList.  # noqa: E501
        :type cpu: str
        :param gpu: The gpu of this ResourceList.  # noqa: E501
        :type gpu: str
        :param memory: The memory of this ResourceList.  # noqa: E501
        :type memory: str
        """
        self.swagger_types = {
            'cpu': str,
            'gpu': str,
            'memory': str
        }

        self.attribute_map = {
            'cpu': 'cpu',
            'gpu': 'gpu',
            'memory': 'memory'
        }

        self._cpu = cpu
        self._gpu = gpu
        self._memory = memory

    @classmethod
    def from_dict(cls, dikt) -> 'ResourceList':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ResourceList of this ResourceList.  # noqa: E501
        :rtype: ResourceList
        """
        return util.deserialize_model(dikt, cls)

    @property
    def cpu(self) -> str:
        """Gets the cpu of this ResourceList.

        Read more about CPU resource here https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/#meaning-of-cpu  # noqa: E501

        :return: The cpu of this ResourceList.
        :rtype: str
        """
        return self._cpu

    @cpu.setter
    def cpu(self, cpu: str):
        """Sets the cpu of this ResourceList.

        Read more about CPU resource here https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/#meaning-of-cpu  # noqa: E501

        :param cpu: The cpu of this ResourceList.
        :type cpu: str
        """

        self._cpu = cpu

    @property
    def gpu(self) -> str:
        """Gets the gpu of this ResourceList.

        Read more about GPU resource here https://kubernetes.io/docs/tasks/manage-gpus/scheduling-gpus/#using-device-plugins  # noqa: E501

        :return: The gpu of this ResourceList.
        :rtype: str
        """
        return self._gpu

    @gpu.setter
    def gpu(self, gpu: str):
        """Sets the gpu of this ResourceList.

        Read more about GPU resource here https://kubernetes.io/docs/tasks/manage-gpus/scheduling-gpus/#using-device-plugins  # noqa: E501

        :param gpu: The gpu of this ResourceList.
        :type gpu: str
        """

        self._gpu = gpu

    @property
    def memory(self) -> str:
        """Gets the memory of this ResourceList.

        Read more about memory resource here https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/#meaning-of-memory  # noqa: E501

        :return: The memory of this ResourceList.
        :rtype: str
        """
        return self._memory

    @memory.setter
    def memory(self, memory: str):
        """Sets the memory of this ResourceList.

        Read more about memory resource here https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/#meaning-of-memory  # noqa: E501

        :param memory: The memory of this ResourceList.
        :type memory: str
        """

        self._memory = memory
