# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models.connection import Connection  # noqa: F401,E501
from odahuflow.sdk.models.model_packaging import ModelPackaging  # noqa: F401,E501
from odahuflow.sdk.models.packager_target import PackagerTarget  # noqa: F401,E501
from odahuflow.sdk.models.packaging_integration import PackagingIntegration  # noqa: F401,E501
from odahuflow.sdk.models import util


class K8sPackager(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, model_holder: Connection=None, model_packaging: ModelPackaging=None, packaging_integration: PackagingIntegration=None, targets: List[PackagerTarget]=None, training_zip_name: str=None):  # noqa: E501
        """K8sPackager - a model defined in Swagger

        :param model_holder: The model_holder of this K8sPackager.  # noqa: E501
        :type model_holder: Connection
        :param model_packaging: The model_packaging of this K8sPackager.  # noqa: E501
        :type model_packaging: ModelPackaging
        :param packaging_integration: The packaging_integration of this K8sPackager.  # noqa: E501
        :type packaging_integration: PackagingIntegration
        :param targets: The targets of this K8sPackager.  # noqa: E501
        :type targets: List[PackagerTarget]
        :param training_zip_name: The training_zip_name of this K8sPackager.  # noqa: E501
        :type training_zip_name: str
        """
        self.swagger_types = {
            'model_holder': Connection,
            'model_packaging': ModelPackaging,
            'packaging_integration': PackagingIntegration,
            'targets': List[PackagerTarget],
            'training_zip_name': str
        }

        self.attribute_map = {
            'model_holder': 'modelHolder',
            'model_packaging': 'modelPackaging',
            'packaging_integration': 'packagingIntegration',
            'targets': 'targets',
            'training_zip_name': 'trainingZipName'
        }

        self._model_holder = model_holder
        self._model_packaging = model_packaging
        self._packaging_integration = packaging_integration
        self._targets = targets
        self._training_zip_name = training_zip_name

    @classmethod
    def from_dict(cls, dikt) -> 'K8sPackager':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The K8sPackager of this K8sPackager.  # noqa: E501
        :rtype: K8sPackager
        """
        return util.deserialize_model(dikt, cls)

    @property
    def model_holder(self) -> Connection:
        """Gets the model_holder of this K8sPackager.

        Connection where a trained model artifact is stored  # noqa: E501

        :return: The model_holder of this K8sPackager.
        :rtype: Connection
        """
        return self._model_holder

    @model_holder.setter
    def model_holder(self, model_holder: Connection):
        """Sets the model_holder of this K8sPackager.

        Connection where a trained model artifact is stored  # noqa: E501

        :param model_holder: The model_holder of this K8sPackager.
        :type model_holder: Connection
        """

        self._model_holder = model_holder

    @property
    def model_packaging(self) -> ModelPackaging:
        """Gets the model_packaging of this K8sPackager.

        Model Packaging  # noqa: E501

        :return: The model_packaging of this K8sPackager.
        :rtype: ModelPackaging
        """
        return self._model_packaging

    @model_packaging.setter
    def model_packaging(self, model_packaging: ModelPackaging):
        """Sets the model_packaging of this K8sPackager.

        Model Packaging  # noqa: E501

        :param model_packaging: The model_packaging of this K8sPackager.
        :type model_packaging: ModelPackaging
        """

        self._model_packaging = model_packaging

    @property
    def packaging_integration(self) -> PackagingIntegration:
        """Gets the packaging_integration of this K8sPackager.

        Packaging integration  # noqa: E501

        :return: The packaging_integration of this K8sPackager.
        :rtype: PackagingIntegration
        """
        return self._packaging_integration

    @packaging_integration.setter
    def packaging_integration(self, packaging_integration: PackagingIntegration):
        """Sets the packaging_integration of this K8sPackager.

        Packaging integration  # noqa: E501

        :param packaging_integration: The packaging_integration of this K8sPackager.
        :type packaging_integration: PackagingIntegration
        """

        self._packaging_integration = packaging_integration

    @property
    def targets(self) -> List[PackagerTarget]:
        """Gets the targets of this K8sPackager.

        List of targets with appropriate connections  # noqa: E501

        :return: The targets of this K8sPackager.
        :rtype: List[PackagerTarget]
        """
        return self._targets

    @targets.setter
    def targets(self, targets: List[PackagerTarget]):
        """Sets the targets of this K8sPackager.

        List of targets with appropriate connections  # noqa: E501

        :param targets: The targets of this K8sPackager.
        :type targets: List[PackagerTarget]
        """

        self._targets = targets

    @property
    def training_zip_name(self) -> str:
        """Gets the training_zip_name of this K8sPackager.

        Name of trained model artifact name  # noqa: E501

        :return: The training_zip_name of this K8sPackager.
        :rtype: str
        """
        return self._training_zip_name

    @training_zip_name.setter
    def training_zip_name(self, training_zip_name: str):
        """Sets the training_zip_name of this K8sPackager.

        Name of trained model artifact name  # noqa: E501

        :param training_zip_name: The training_zip_name of this K8sPackager.
        :type training_zip_name: str
        """

        self._training_zip_name = training_zip_name
