# Database Operations

[![PyPI Latest Release](https://img.shields.io/pypi/v/pydbops.svg)](https://pypi.org/project/pydbops/)
[![License](https://img.shields.io/pypi/l/pydbops.svg)](https://github.com/NotShrirang/pydbops/LICENSE)

Library for simplifying database operations.
Contains standard functions for database operations.
<br>

GitHub Page : https://github.com/NotShrirang/pydbops

## Importing pydbops:

```sh
from pydbops import *
```

## Methods in Database:

(You will need to call openDatabase() method using db.)

## Methods in Database:

1. <code>openDatabase()</code> - Creates a database and returns a Database object.
2. <code>createTable()</code> - Creates table of given name.
3. <code>addEntry()</code> - Function for inserting values in database.
4. <code>databaseVersion()</code> - Returns sqlite3 version.
5. <code>dropTable()</code> - Function for deleting table.
6. <code>fetchInOrder()</code> - Function for fetching database entries in given order.
7. <code>getData()</code> - Function for getting all data.
8. <code>getFieldNames()</code> - Function for getting field names.
9. <code>getTable()</code> - Creates Table instance.
10. <code>intersection()</code> - Performs intersection and returns all distinct rows selected by query.
11. <code>length()</code> - Returns length of database.
12. <code>minus()</code> - Fetches rows which are present in first query but absent in second.
13. <code>removeEntry()</code> - Function for removing records from database.
14. <code>searchEntry()</code> - Function for searching in database.
15. <code>tableNames()</code> - Function for retrieving tables in a database.
16. <code>union()</code> - Performs union and returns all distinct rows selected by query.
17. <code>updateEntry()</code> - Function for updating values in database.

For printing data in database, you can use default print() method by passing Database object in it.

For printing data in database, you can use default print() method by passing Database object in it.
