# coding: utf-8

"""
    UniCatDB API

    UniCatDB application API documentation, with examples and live testing.  This API is built in accordance with the **JSON API 1.0 standard**. For general information, see [the documentation](http://jsonapi.org/format/).  -  JSON API standard requires use of the JSON API media type (application/vnd.api+json) for exchanging data. Clients must send all JSON API data with the headers `Content-Type: application/vnd.api+json` (POST, PATCH) and `Accept: application/vnd.api+json` (GET, DELETE). - [Relationships](http://jsonapi.org/format/#fetching-relationships) and their [inclusions](http://jsonapi.org/format/#fetching-includes) via the `include` query parameter, as specified by the standard, **are not implemented**, since there are no relationships present in the data model. - The standard does not prescribe any filtering strategies. This API implements two strategies which can be combined: **Basic filtering** based on the used [JSON API library](https://json-api-dotnet.github.io/#/filtering) and **Custom filtering** which allow for any possible query to the MongoDB server and can be extended and customize in the future. For more information about filtering, see the description of the `filter` down bellow. - **Non-standard PATCH behavior:** Sucessfull PATCH reuest always result in HTTP 200 response with the updated resource object, even if the server does not perform any additional modifications. HTTP 204 is never used in PATCH responses.  Attachment upload endpoint uses the **TUS protocol**. See [the documentation](https://tus.io/). When integrating, it is recommended to use one of the [official TUS client implementations](https://tus.io/implementations.html).  - **Supported TUS versions**:   -  1.0.0 - **Supported TUS extensions**:   - Creation   - Creation Defer Length   - Creation With Upload   - Checksum   - Checksum Trailer - **Required metadata**:   - `fileName` - name of the original file incl. file extension   - `contentType`- the MIME type of the file   # noqa: E501

    The version of the OpenAPI document: v2
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from unicatdb.openapi_client.configuration import Configuration


class Invitation(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'tenant': 'Tenant',
        'inviter': 'TenantUser',
        'created_at': 'datetime',
        'expires_at': 'datetime',
        'invitee_role': 'TenantInviteeRole',
        'key': 'str'
    }

    attribute_map = {
        'id': 'id',
        'tenant': 'tenant',
        'inviter': 'inviter',
        'created_at': 'createdAt',
        'expires_at': 'expiresAt',
        'invitee_role': 'inviteeRole',
        'key': 'key'
    }

    def __init__(self, id=None, tenant=None, inviter=None, created_at=None, expires_at=None, invitee_role=None, key=None, local_vars_configuration=None):  # noqa: E501
        """Invitation - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._tenant = None
        self._inviter = None
        self._created_at = None
        self._expires_at = None
        self._invitee_role = None
        self._key = None
        self.discriminator = None

        self.id = id
        self.tenant = tenant
        self.inviter = inviter
        self.created_at = created_at
        self.expires_at = expires_at
        self.invitee_role = invitee_role
        self.key = key

    @property
    def id(self):
        """Gets the id of this Invitation.  # noqa: E501

        Invitation ID  # noqa: E501

        :return: The id of this Invitation.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Invitation.

        Invitation ID  # noqa: E501

        :param id: The id of this Invitation.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def tenant(self):
        """Gets the tenant of this Invitation.  # noqa: E501


        :return: The tenant of this Invitation.  # noqa: E501
        :rtype: Tenant
        """
        return self._tenant

    @tenant.setter
    def tenant(self, tenant):
        """Sets the tenant of this Invitation.


        :param tenant: The tenant of this Invitation.  # noqa: E501
        :type tenant: Tenant
        """
        if self.local_vars_configuration.client_side_validation and tenant is None:  # noqa: E501
            raise ValueError("Invalid value for `tenant`, must not be `None`")  # noqa: E501

        self._tenant = tenant

    @property
    def inviter(self):
        """Gets the inviter of this Invitation.  # noqa: E501


        :return: The inviter of this Invitation.  # noqa: E501
        :rtype: TenantUser
        """
        return self._inviter

    @inviter.setter
    def inviter(self, inviter):
        """Sets the inviter of this Invitation.


        :param inviter: The inviter of this Invitation.  # noqa: E501
        :type inviter: TenantUser
        """
        if self.local_vars_configuration.client_side_validation and inviter is None:  # noqa: E501
            raise ValueError("Invalid value for `inviter`, must not be `None`")  # noqa: E501

        self._inviter = inviter

    @property
    def created_at(self):
        """Gets the created_at of this Invitation.  # noqa: E501

        Timestamp when the invitation was created.  # noqa: E501

        :return: The created_at of this Invitation.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Invitation.

        Timestamp when the invitation was created.  # noqa: E501

        :param created_at: The created_at of this Invitation.  # noqa: E501
        :type created_at: datetime
        """
        if self.local_vars_configuration.client_side_validation and created_at is None:  # noqa: E501
            raise ValueError("Invalid value for `created_at`, must not be `None`")  # noqa: E501

        self._created_at = created_at

    @property
    def expires_at(self):
        """Gets the expires_at of this Invitation.  # noqa: E501

        Timestamp when the invitation expires, cannot be redeemed after.  # noqa: E501

        :return: The expires_at of this Invitation.  # noqa: E501
        :rtype: datetime
        """
        return self._expires_at

    @expires_at.setter
    def expires_at(self, expires_at):
        """Sets the expires_at of this Invitation.

        Timestamp when the invitation expires, cannot be redeemed after.  # noqa: E501

        :param expires_at: The expires_at of this Invitation.  # noqa: E501
        :type expires_at: datetime
        """
        if self.local_vars_configuration.client_side_validation and expires_at is None:  # noqa: E501
            raise ValueError("Invalid value for `expires_at`, must not be `None`")  # noqa: E501

        self._expires_at = expires_at

    @property
    def invitee_role(self):
        """Gets the invitee_role of this Invitation.  # noqa: E501


        :return: The invitee_role of this Invitation.  # noqa: E501
        :rtype: TenantInviteeRole
        """
        return self._invitee_role

    @invitee_role.setter
    def invitee_role(self, invitee_role):
        """Sets the invitee_role of this Invitation.


        :param invitee_role: The invitee_role of this Invitation.  # noqa: E501
        :type invitee_role: TenantInviteeRole
        """
        if self.local_vars_configuration.client_side_validation and invitee_role is None:  # noqa: E501
            raise ValueError("Invalid value for `invitee_role`, must not be `None`")  # noqa: E501

        self._invitee_role = invitee_role

    @property
    def key(self):
        """Gets the key of this Invitation.  # noqa: E501

        Access key used in redeeming process.  # noqa: E501

        :return: The key of this Invitation.  # noqa: E501
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """Sets the key of this Invitation.

        Access key used in redeeming process.  # noqa: E501

        :param key: The key of this Invitation.  # noqa: E501
        :type key: str
        """
        if self.local_vars_configuration.client_side_validation and key is None:  # noqa: E501
            raise ValueError("Invalid value for `key`, must not be `None`")  # noqa: E501

        self._key = key

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Invitation):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Invitation):
            return True

        return self.to_dict() != other.to_dict()
