# coding: utf-8

"""
    UniCatDB API

    UniCatDB application API documentation, with examples and live testing.  This API is built in accordance with the **JSON API 1.0 standard**. For general information, see [the documentation](http://jsonapi.org/format/).  -  JSON API standard requires use of the JSON API media type (application/vnd.api+json) for exchanging data. Clients must send all JSON API data with the headers `Content-Type: application/vnd.api+json` (POST, PATCH) and `Accept: application/vnd.api+json` (GET, DELETE). - [Relationships](http://jsonapi.org/format/#fetching-relationships) and their [inclusions](http://jsonapi.org/format/#fetching-includes) via the `include` query parameter, as specified by the standard, **are not implemented**, since there are no relationships present in the data model. - The standard does not prescribe any filtering strategies. This API implements two strategies which can be combined: **Basic filtering** based on the used [JSON API library](https://json-api-dotnet.github.io/#/filtering) and **Custom filtering** which allow for any possible query to the MongoDB server and can be extended and customize in the future. For more information about filtering, see the description of the `filter` down bellow. - **Non-standard PATCH behavior:** Sucessfull PATCH reuest always result in HTTP 200 response with the updated resource object, even if the server does not perform any additional modifications. HTTP 204 is never used in PATCH responses.  Attachment upload endpoint uses the **TUS protocol**. See [the documentation](https://tus.io/). When integrating, it is recommended to use one of the [official TUS client implementations](https://tus.io/implementations.html).  - **Supported TUS versions**:   -  1.0.0 - **Supported TUS extensions**:   - Creation   - Creation Defer Length   - Creation With Upload   - Checksum   - Checksum Trailer - **Required metadata**:   - `fileName` - name of the original file incl. file extension   - `contentType`- the MIME type of the file   # noqa: E501

    The version of the OpenAPI document: v2
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from unicatdb.openapi_client.configuration import Configuration


class Finding(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'owner': 'str',
        'permissions': 'list[str]',
        'document_name': 'str',
        'dynamic_data': 'dict(str, object)',
        'document_set': 'str',
        'amount': 'int',
        'date': 'date',
        'person': 'str',
        'location_description': 'str',
        'location_gps_point': 'LatLngGps',
        'location_gps_point_wkt': 'str',
        'location_gps_area': 'list[LatLngGps]',
        'location_gps_area_wkt': 'str',
        'note': 'str',
        'tags': 'list[str]',
        'taxonomy_hierarchy_id': 'str',
        'taxonomy_human_readable': 'str',
        'taxonomy_name': 'TaxonomyName',
        'attachment_note': 'str'
    }

    attribute_map = {
        'owner': 'owner',
        'permissions': 'permissions',
        'document_name': 'documentName',
        'dynamic_data': 'dynamicData',
        'document_set': 'documentSet',
        'amount': 'amount',
        'date': 'date',
        'person': 'person',
        'location_description': 'locationDescription',
        'location_gps_point': 'locationGpsPoint',
        'location_gps_point_wkt': 'locationGpsPointWkt',
        'location_gps_area': 'locationGpsArea',
        'location_gps_area_wkt': 'locationGpsAreaWkt',
        'note': 'note',
        'tags': 'tags',
        'taxonomy_hierarchy_id': 'taxonomyHierarchyId',
        'taxonomy_human_readable': 'taxonomyHumanReadable',
        'taxonomy_name': 'taxonomyName',
        'attachment_note': 'attachmentNote'
    }

    def __init__(self, owner=None, permissions=None, document_name=None, dynamic_data=None, document_set=None, amount=None, date=None, person=None, location_description=None, location_gps_point=None, location_gps_point_wkt=None, location_gps_area=None, location_gps_area_wkt=None, note=None, tags=None, taxonomy_hierarchy_id=None, taxonomy_human_readable=None, taxonomy_name=None, attachment_note=None, local_vars_configuration=None):  # noqa: E501
        """Finding - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._owner = None
        self._permissions = None
        self._document_name = None
        self._dynamic_data = None
        self._document_set = None
        self._amount = None
        self._date = None
        self._person = None
        self._location_description = None
        self._location_gps_point = None
        self._location_gps_point_wkt = None
        self._location_gps_area = None
        self._location_gps_area_wkt = None
        self._note = None
        self._tags = None
        self._taxonomy_hierarchy_id = None
        self._taxonomy_human_readable = None
        self._taxonomy_name = None
        self._attachment_note = None
        self.discriminator = None

        if owner is not None:
            self.owner = owner
        if permissions is not None:
            self.permissions = permissions
        if document_name is not None:
            self.document_name = document_name
        if dynamic_data is not None:
            self.dynamic_data = dynamic_data
        if document_set is not None:
            self.document_set = document_set
        if amount is not None:
            self.amount = amount
        if date is not None:
            self.date = date
        if person is not None:
            self.person = person
        if location_description is not None:
            self.location_description = location_description
        self.location_gps_point = location_gps_point
        self.location_gps_point_wkt = location_gps_point_wkt
        if location_gps_area is not None:
            self.location_gps_area = location_gps_area
        self.location_gps_area_wkt = location_gps_area_wkt
        if note is not None:
            self.note = note
        if tags is not None:
            self.tags = tags
        if taxonomy_hierarchy_id is not None:
            self.taxonomy_hierarchy_id = taxonomy_hierarchy_id
        if taxonomy_human_readable is not None:
            self.taxonomy_human_readable = taxonomy_human_readable
        if taxonomy_name is not None:
            self.taxonomy_name = taxonomy_name
        if attachment_note is not None:
            self.attachment_note = attachment_note

    @property
    def owner(self):
        """Gets the owner of this Finding.  # noqa: E501


        :return: The owner of this Finding.  # noqa: E501
        :rtype: str
        """
        return self._owner

    @owner.setter
    def owner(self, owner):
        """Sets the owner of this Finding.


        :param owner: The owner of this Finding.  # noqa: E501
        :type owner: str
        """

        self._owner = owner

    @property
    def permissions(self):
        """Gets the permissions of this Finding.  # noqa: E501


        :return: The permissions of this Finding.  # noqa: E501
        :rtype: list[str]
        """
        return self._permissions

    @permissions.setter
    def permissions(self, permissions):
        """Sets the permissions of this Finding.


        :param permissions: The permissions of this Finding.  # noqa: E501
        :type permissions: list[str]
        """

        self._permissions = permissions

    @property
    def document_name(self):
        """Gets the document_name of this Finding.  # noqa: E501


        :return: The document_name of this Finding.  # noqa: E501
        :rtype: str
        """
        return self._document_name

    @document_name.setter
    def document_name(self, document_name):
        """Sets the document_name of this Finding.


        :param document_name: The document_name of this Finding.  # noqa: E501
        :type document_name: str
        """

        self._document_name = document_name

    @property
    def dynamic_data(self):
        """Gets the dynamic_data of this Finding.  # noqa: E501


        :return: The dynamic_data of this Finding.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._dynamic_data

    @dynamic_data.setter
    def dynamic_data(self, dynamic_data):
        """Sets the dynamic_data of this Finding.


        :param dynamic_data: The dynamic_data of this Finding.  # noqa: E501
        :type dynamic_data: dict(str, object)
        """

        self._dynamic_data = dynamic_data

    @property
    def document_set(self):
        """Gets the document_set of this Finding.  # noqa: E501


        :return: The document_set of this Finding.  # noqa: E501
        :rtype: str
        """
        return self._document_set

    @document_set.setter
    def document_set(self, document_set):
        """Sets the document_set of this Finding.


        :param document_set: The document_set of this Finding.  # noqa: E501
        :type document_set: str
        """

        self._document_set = document_set

    @property
    def amount(self):
        """Gets the amount of this Finding.  # noqa: E501


        :return: The amount of this Finding.  # noqa: E501
        :rtype: int
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this Finding.


        :param amount: The amount of this Finding.  # noqa: E501
        :type amount: int
        """

        self._amount = amount

    @property
    def date(self):
        """Gets the date of this Finding.  # noqa: E501

        ISO 8601 formatted date, UTC time of day component may be present and equals to zero (00:00:00.000Z)  # noqa: E501

        :return: The date of this Finding.  # noqa: E501
        :rtype: date
        """
        return self._date

    @date.setter
    def date(self, date):
        """Sets the date of this Finding.

        ISO 8601 formatted date, UTC time of day component may be present and equals to zero (00:00:00.000Z)  # noqa: E501

        :param date: The date of this Finding.  # noqa: E501
        :type date: date
        """

        self._date = date

    @property
    def person(self):
        """Gets the person of this Finding.  # noqa: E501


        :return: The person of this Finding.  # noqa: E501
        :rtype: str
        """
        return self._person

    @person.setter
    def person(self, person):
        """Sets the person of this Finding.


        :param person: The person of this Finding.  # noqa: E501
        :type person: str
        """

        self._person = person

    @property
    def location_description(self):
        """Gets the location_description of this Finding.  # noqa: E501


        :return: The location_description of this Finding.  # noqa: E501
        :rtype: str
        """
        return self._location_description

    @location_description.setter
    def location_description(self, location_description):
        """Sets the location_description of this Finding.


        :param location_description: The location_description of this Finding.  # noqa: E501
        :type location_description: str
        """

        self._location_description = location_description

    @property
    def location_gps_point(self):
        """Gets the location_gps_point of this Finding.  # noqa: E501


        :return: The location_gps_point of this Finding.  # noqa: E501
        :rtype: LatLngGps
        """
        return self._location_gps_point

    @location_gps_point.setter
    def location_gps_point(self, location_gps_point):
        """Sets the location_gps_point of this Finding.


        :param location_gps_point: The location_gps_point of this Finding.  # noqa: E501
        :type location_gps_point: LatLngGps
        """

        self._location_gps_point = location_gps_point

    @property
    def location_gps_point_wkt(self):
        """Gets the location_gps_point_wkt of this Finding.  # noqa: E501

        Well-known text (WKT) representation of location geometry (ISO/IEC 13249-3:2016 standard)  # noqa: E501

        :return: The location_gps_point_wkt of this Finding.  # noqa: E501
        :rtype: str
        """
        return self._location_gps_point_wkt

    @location_gps_point_wkt.setter
    def location_gps_point_wkt(self, location_gps_point_wkt):
        """Sets the location_gps_point_wkt of this Finding.

        Well-known text (WKT) representation of location geometry (ISO/IEC 13249-3:2016 standard)  # noqa: E501

        :param location_gps_point_wkt: The location_gps_point_wkt of this Finding.  # noqa: E501
        :type location_gps_point_wkt: str
        """

        self._location_gps_point_wkt = location_gps_point_wkt

    @property
    def location_gps_area(self):
        """Gets the location_gps_area of this Finding.  # noqa: E501


        :return: The location_gps_area of this Finding.  # noqa: E501
        :rtype: list[LatLngGps]
        """
        return self._location_gps_area

    @location_gps_area.setter
    def location_gps_area(self, location_gps_area):
        """Sets the location_gps_area of this Finding.


        :param location_gps_area: The location_gps_area of this Finding.  # noqa: E501
        :type location_gps_area: list[LatLngGps]
        """

        self._location_gps_area = location_gps_area

    @property
    def location_gps_area_wkt(self):
        """Gets the location_gps_area_wkt of this Finding.  # noqa: E501

        Well-known text (WKT) representation of location geometry (ISO/IEC 13249-3:2016 standard)  # noqa: E501

        :return: The location_gps_area_wkt of this Finding.  # noqa: E501
        :rtype: str
        """
        return self._location_gps_area_wkt

    @location_gps_area_wkt.setter
    def location_gps_area_wkt(self, location_gps_area_wkt):
        """Sets the location_gps_area_wkt of this Finding.

        Well-known text (WKT) representation of location geometry (ISO/IEC 13249-3:2016 standard)  # noqa: E501

        :param location_gps_area_wkt: The location_gps_area_wkt of this Finding.  # noqa: E501
        :type location_gps_area_wkt: str
        """

        self._location_gps_area_wkt = location_gps_area_wkt

    @property
    def note(self):
        """Gets the note of this Finding.  # noqa: E501


        :return: The note of this Finding.  # noqa: E501
        :rtype: str
        """
        return self._note

    @note.setter
    def note(self, note):
        """Sets the note of this Finding.


        :param note: The note of this Finding.  # noqa: E501
        :type note: str
        """

        self._note = note

    @property
    def tags(self):
        """Gets the tags of this Finding.  # noqa: E501


        :return: The tags of this Finding.  # noqa: E501
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this Finding.


        :param tags: The tags of this Finding.  # noqa: E501
        :type tags: list[str]
        """

        self._tags = tags

    @property
    def taxonomy_hierarchy_id(self):
        """Gets the taxonomy_hierarchy_id of this Finding.  # noqa: E501


        :return: The taxonomy_hierarchy_id of this Finding.  # noqa: E501
        :rtype: str
        """
        return self._taxonomy_hierarchy_id

    @taxonomy_hierarchy_id.setter
    def taxonomy_hierarchy_id(self, taxonomy_hierarchy_id):
        """Sets the taxonomy_hierarchy_id of this Finding.


        :param taxonomy_hierarchy_id: The taxonomy_hierarchy_id of this Finding.  # noqa: E501
        :type taxonomy_hierarchy_id: str
        """

        self._taxonomy_hierarchy_id = taxonomy_hierarchy_id

    @property
    def taxonomy_human_readable(self):
        """Gets the taxonomy_human_readable of this Finding.  # noqa: E501


        :return: The taxonomy_human_readable of this Finding.  # noqa: E501
        :rtype: str
        """
        return self._taxonomy_human_readable

    @taxonomy_human_readable.setter
    def taxonomy_human_readable(self, taxonomy_human_readable):
        """Sets the taxonomy_human_readable of this Finding.


        :param taxonomy_human_readable: The taxonomy_human_readable of this Finding.  # noqa: E501
        :type taxonomy_human_readable: str
        """

        self._taxonomy_human_readable = taxonomy_human_readable

    @property
    def taxonomy_name(self):
        """Gets the taxonomy_name of this Finding.  # noqa: E501


        :return: The taxonomy_name of this Finding.  # noqa: E501
        :rtype: TaxonomyName
        """
        return self._taxonomy_name

    @taxonomy_name.setter
    def taxonomy_name(self, taxonomy_name):
        """Sets the taxonomy_name of this Finding.


        :param taxonomy_name: The taxonomy_name of this Finding.  # noqa: E501
        :type taxonomy_name: TaxonomyName
        """

        self._taxonomy_name = taxonomy_name

    @property
    def attachment_note(self):
        """Gets the attachment_note of this Finding.  # noqa: E501


        :return: The attachment_note of this Finding.  # noqa: E501
        :rtype: str
        """
        return self._attachment_note

    @attachment_note.setter
    def attachment_note(self, attachment_note):
        """Sets the attachment_note of this Finding.


        :param attachment_note: The attachment_note of this Finding.  # noqa: E501
        :type attachment_note: str
        """

        self._attachment_note = attachment_note

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Finding):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Finding):
            return True

        return self.to_dict() != other.to_dict()
