# coding: utf-8

"""
    UniCatDB API

    UniCatDB application API documentation, with examples and live testing.  This API is built in accordance with the **JSON API 1.0 standard**. For general information, see [the documentation](http://jsonapi.org/format/).  -  JSON API standard requires use of the JSON API media type (application/vnd.api+json) for exchanging data. Clients must send all JSON API data with the headers `Content-Type: application/vnd.api+json` (POST, PATCH) and `Accept: application/vnd.api+json` (GET, DELETE). - [Relationships](http://jsonapi.org/format/#fetching-relationships) and their [inclusions](http://jsonapi.org/format/#fetching-includes) via the `include` query parameter, as specified by the standard, **are not implemented**, since there are no relationships present in the data model. - The standard does not prescribe any filtering strategies. This API implements two strategies which can be combined: **Basic filtering** based on the used [JSON API library](https://json-api-dotnet.github.io/#/filtering) and **Custom filtering** which allow for any possible query to the MongoDB server and can be extended and customize in the future. For more information about filtering, see the description of the `filter` down bellow. - **Non-standard PATCH behavior:** Sucessfull PATCH reuest always result in HTTP 200 response with the updated resource object, even if the server does not perform any additional modifications. HTTP 204 is never used in PATCH responses.  Attachment upload endpoint uses the **TUS protocol**. See [the documentation](https://tus.io/). When integrating, it is recommended to use one of the [official TUS client implementations](https://tus.io/implementations.html).  - **Supported TUS versions**:   -  1.0.0 - **Supported TUS extensions**:   - Creation   - Creation Defer Length   - Creation With Upload   - Checksum   - Checksum Trailer - **Required metadata**:   - `fileName` - name of the original file incl. file extension   - `contentType`- the MIME type of the file   # noqa: E501

    The version of the OpenAPI document: v2
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from unicatdb.openapi_client.api_client import ApiClient
from unicatdb.openapi_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class AttachmentsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def api_attachments_delete_by_id(self, tenant_id, id, **kwargs):  # noqa: E501
        """Delete a specific attachment, if exists  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_attachments_delete_by_id(tenant_id, id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.api_attachments_delete_by_id_with_http_info(tenant_id, id, **kwargs)  # noqa: E501

    def api_attachments_delete_by_id_with_http_info(self, tenant_id, id, **kwargs):  # noqa: E501
        """Delete a specific attachment, if exists  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_attachments_delete_by_id_with_http_info(tenant_id, id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_attachments_delete_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and ('tenant_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tenant_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `api_attachments_delete_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `api_attachments_delete_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.api+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/{tenantId}/attachments/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def api_attachments_get(self, tenant_id, **kwargs):  # noqa: E501
        """Get paged list of attachments matching optional criteria  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_attachments_get(tenant_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param sort: **Sort results by specified property name.**  ---------------  Default sorting order is descending. To sort in ascending order, prepend hypen charater (-) before the property name.  Nested object properties CAN be referenced by the dot notation (e.g: *taxonomyTree.root.name*). Entities with missing referenced property are sorted on top of the results (missing propety = smallest value).  Sorting by multiple properties is supported - individual property names can be separated by comma charater (,). Order of the properties does matter. 
        :type sort: str
        :param page: **Specifies page size and page number for paged data responses.**  ---------------  Paging is optional. If not specified, the result will be paged based on the application defaults.  Paging may be turned off by passing page size of -1.  Links to the next, previous, first and last pages are provided in the `meta` property of the response, if applicable.  **Examples:**   * `?page[number]=2&page[size]=15` * `?page[size]=-1` - turns of paging 
        :type page: PageQuery
        :param fields: **Returns sparse field sets for a given resource type.**  ---------------  Since relationships and inclusion are not supported, use only resource type of the main entity (in this case findings).  Only specified fields will be returned, individual fields needs to be separated by comma (,) character.  Field set limiting by the nested properties is NOT SUPPORTED and will result in HTTP 400 error. 
        :type fields: AttachmentFieldsQuery
        :param filter: **Provides filter to be applied on the result set returned.**  ---------------  Filters are specified as as collection of *key<>value* pairs representing individual filters. If more filters are specifies, they are combined using *AND* logic operator.  Two filtering strategies are suported:  **Basic filter**  * *Key* - property name (nested properties are supported via dot notation)  * *Value* - filter expression prefixed with operation (operation is optional, defaults to **eq:** if not specified). Supprted operations:   * <code>filter[*property*]=<b>eq:</b>*value*</code> - Is equal to   * <code>filter[*property*]=<b>eqi:</b>*value*</code> - Is equal to (case insensitive)   * <code>filter[*property*]=<b>ne:</b>*value*</code> - Is not equal to   * <code>filter[*property*]=<b>lt:</b>*value*</code> - Is less than   * <code>filter[*property*]=<b>gt:</b>*value*</code> - Is greater than   * <code>filter[*property*]=<b>le:</b>*value*</code> - Is less than or equal   * <code>filter[*property*]=<b>ge:</b>*value*</code> - Is greater than or equal   * <code>filter[*property*]=<b>like:</b>*value*</code> - Contains substring   * <code>filter[*property*]=<b>in:</b>*value1*,*value2*,...</code> - Is in list   * <code>filter[*property*]=<b>nin:</b>*value1*,*value2*,...</code> - Is not in list 
        :type filter: dict(str, str)
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AttachmentArrayResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.api_attachments_get_with_http_info(tenant_id, **kwargs)  # noqa: E501

    def api_attachments_get_with_http_info(self, tenant_id, **kwargs):  # noqa: E501
        """Get paged list of attachments matching optional criteria  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_attachments_get_with_http_info(tenant_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param sort: **Sort results by specified property name.**  ---------------  Default sorting order is descending. To sort in ascending order, prepend hypen charater (-) before the property name.  Nested object properties CAN be referenced by the dot notation (e.g: *taxonomyTree.root.name*). Entities with missing referenced property are sorted on top of the results (missing propety = smallest value).  Sorting by multiple properties is supported - individual property names can be separated by comma charater (,). Order of the properties does matter. 
        :type sort: str
        :param page: **Specifies page size and page number for paged data responses.**  ---------------  Paging is optional. If not specified, the result will be paged based on the application defaults.  Paging may be turned off by passing page size of -1.  Links to the next, previous, first and last pages are provided in the `meta` property of the response, if applicable.  **Examples:**   * `?page[number]=2&page[size]=15` * `?page[size]=-1` - turns of paging 
        :type page: PageQuery
        :param fields: **Returns sparse field sets for a given resource type.**  ---------------  Since relationships and inclusion are not supported, use only resource type of the main entity (in this case findings).  Only specified fields will be returned, individual fields needs to be separated by comma (,) character.  Field set limiting by the nested properties is NOT SUPPORTED and will result in HTTP 400 error. 
        :type fields: AttachmentFieldsQuery
        :param filter: **Provides filter to be applied on the result set returned.**  ---------------  Filters are specified as as collection of *key<>value* pairs representing individual filters. If more filters are specifies, they are combined using *AND* logic operator.  Two filtering strategies are suported:  **Basic filter**  * *Key* - property name (nested properties are supported via dot notation)  * *Value* - filter expression prefixed with operation (operation is optional, defaults to **eq:** if not specified). Supprted operations:   * <code>filter[*property*]=<b>eq:</b>*value*</code> - Is equal to   * <code>filter[*property*]=<b>eqi:</b>*value*</code> - Is equal to (case insensitive)   * <code>filter[*property*]=<b>ne:</b>*value*</code> - Is not equal to   * <code>filter[*property*]=<b>lt:</b>*value*</code> - Is less than   * <code>filter[*property*]=<b>gt:</b>*value*</code> - Is greater than   * <code>filter[*property*]=<b>le:</b>*value*</code> - Is less than or equal   * <code>filter[*property*]=<b>ge:</b>*value*</code> - Is greater than or equal   * <code>filter[*property*]=<b>like:</b>*value*</code> - Contains substring   * <code>filter[*property*]=<b>in:</b>*value1*,*value2*,...</code> - Is in list   * <code>filter[*property*]=<b>nin:</b>*value1*,*value2*,...</code> - Is not in list 
        :type filter: dict(str, str)
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AttachmentArrayResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'sort',
            'page',
            'fields',
            'filter'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_attachments_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and ('tenant_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tenant_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `api_attachments_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501

        query_params = []
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'fields' in local_var_params and local_var_params['fields'] is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
        if 'filter' in local_var_params and local_var_params['filter'] is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.api+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        response_types_map = {
            200: "AttachmentArrayResponse",
            400: "ErrorResponse",
            401: None,
            403: None,
            415: None,
        }

        return self.api_client.call_api(
            '/{tenantId}/attachments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def api_attachments_get_by_id(self, tenant_id, id, **kwargs):  # noqa: E501
        """Get a specific attachment, if exists  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_attachments_get_by_id(tenant_id, id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param fields: **Returns sparse field sets for a given resource type.**  ---------------  Since relationships and inclusion are not supported, use only resource type of the main entity (in this case findings).  Only specified fields will be returned, individual fields needs to be separated by comma (,) character.  Field set limiting by the nested properties is NOT SUPPORTED and will result in HTTP 400 error. 
        :type fields: AttachmentFieldsQuery
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AttachmentSingleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.api_attachments_get_by_id_with_http_info(tenant_id, id, **kwargs)  # noqa: E501

    def api_attachments_get_by_id_with_http_info(self, tenant_id, id, **kwargs):  # noqa: E501
        """Get a specific attachment, if exists  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_attachments_get_by_id_with_http_info(tenant_id, id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param fields: **Returns sparse field sets for a given resource type.**  ---------------  Since relationships and inclusion are not supported, use only resource type of the main entity (in this case findings).  Only specified fields will be returned, individual fields needs to be separated by comma (,) character.  Field set limiting by the nested properties is NOT SUPPORTED and will result in HTTP 400 error. 
        :type fields: AttachmentFieldsQuery
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AttachmentSingleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'id',
            'fields'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_attachments_get_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and ('tenant_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tenant_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `api_attachments_get_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `api_attachments_get_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'fields' in local_var_params and local_var_params['fields'] is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.api+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        response_types_map = {
            200: "AttachmentSingleResponse",
            400: "ErrorResponse",
            401: None,
            403: None,
            404: None,
            415: None,
        }

        return self.api_client.call_api(
            '/{tenantId}/attachments/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def api_attachments_get_by_id_download(self, tenant_id, id, **kwargs):  # noqa: E501
        """Get raw data of a specific attachment, if present (attachment is NOT in incomplete state)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_attachments_get_by_id_download(tenant_id, id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: file
        """
        kwargs['_return_http_data_only'] = True
        return self.api_attachments_get_by_id_download_with_http_info(tenant_id, id, **kwargs)  # noqa: E501

    def api_attachments_get_by_id_download_with_http_info(self, tenant_id, id, **kwargs):  # noqa: E501
        """Get raw data of a specific attachment, if present (attachment is NOT in incomplete state)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_attachments_get_by_id_download_with_http_info(tenant_id, id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(file, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_attachments_get_by_id_download" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and ('tenant_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tenant_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `api_attachments_get_by_id_download`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `api_attachments_get_by_id_download`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        response_types_map = {
            200: "file",
            204: None,
            401: None,
            403: None,
            404: None,
        }

        return self.api_client.call_api(
            '/{tenantId}/attachments/{id}/download', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def api_attachments_get_by_id_findings(self, tenant_id, id, **kwargs):  # noqa: E501
        """Get finding related to an attachment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_attachments_get_by_id_findings(tenant_id, id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FindingSingleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.api_attachments_get_by_id_findings_with_http_info(tenant_id, id, **kwargs)  # noqa: E501

    def api_attachments_get_by_id_findings_with_http_info(self, tenant_id, id, **kwargs):  # noqa: E501
        """Get finding related to an attachment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_attachments_get_by_id_findings_with_http_info(tenant_id, id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FindingSingleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_attachments_get_by_id_findings" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and ('tenant_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tenant_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `api_attachments_get_by_id_findings`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `api_attachments_get_by_id_findings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.api+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        response_types_map = {
            200: "FindingSingleResponse",
            400: "ErrorResponse",
            401: None,
            403: None,
            404: None,
            415: None,
        }

        return self.api_client.call_api(
            '/{tenantId}/attachments/{id}/finding', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def api_attachments_get_by_id_relationships_findings(self, tenant_id, id, **kwargs):  # noqa: E501
        """Get resource identifiers for a given relationship of an attachment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_attachments_get_by_id_relationships_findings(tenant_id, id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RelationshipResourceIdentifierArrayResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.api_attachments_get_by_id_relationships_findings_with_http_info(tenant_id, id, **kwargs)  # noqa: E501

    def api_attachments_get_by_id_relationships_findings_with_http_info(self, tenant_id, id, **kwargs):  # noqa: E501
        """Get resource identifiers for a given relationship of an attachment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_attachments_get_by_id_relationships_findings_with_http_info(tenant_id, id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RelationshipResourceIdentifierArrayResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_attachments_get_by_id_relationships_findings" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and ('tenant_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tenant_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `api_attachments_get_by_id_relationships_findings`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `api_attachments_get_by_id_relationships_findings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.api+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        response_types_map = {
            200: "RelationshipResourceIdentifierArrayResponse",
            401: None,
            403: None,
            404: None,
            415: None,
        }

        return self.api_client.call_api(
            '/{tenantId}/attachments/{id}/relationships/finding', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def api_attachments_get_by_id_thumbnail(self, tenant_id, id, **kwargs):  # noqa: E501
        """Get raw thumbnail data of a specific attachment, if available (attachment is NOT in incomplete state)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_attachments_get_by_id_thumbnail(tenant_id, id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: file
        """
        kwargs['_return_http_data_only'] = True
        return self.api_attachments_get_by_id_thumbnail_with_http_info(tenant_id, id, **kwargs)  # noqa: E501

    def api_attachments_get_by_id_thumbnail_with_http_info(self, tenant_id, id, **kwargs):  # noqa: E501
        """Get raw thumbnail data of a specific attachment, if available (attachment is NOT in incomplete state)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_attachments_get_by_id_thumbnail_with_http_info(tenant_id, id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(file, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_attachments_get_by_id_thumbnail" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and ('tenant_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tenant_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `api_attachments_get_by_id_thumbnail`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `api_attachments_get_by_id_thumbnail`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['image/jpeg'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        response_types_map = {
            200: "file",
            204: None,
            401: None,
            403: None,
            404: None,
        }

        return self.api_client.call_api(
            '/{tenantId}/attachments/{id}/thumbnail', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
