# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/10_scrapper_get_tweet.ipynb (unless otherwise specified).

__all__ = ['Scrapper', 'scrapper']

# Cell
import pandas as pd
import tweepy
from os import getenv
from dotenv import load_dotenv
import time
import datetime
import logging

# Cell
class Scrapper():

    logger = None

    def __init__(self):
        # TODO : accept a logger in constructor
        # TODO : accept the tweet config in constructor
        if getenv('TWITTER_CONSUMER_KEY') is None or len(getenv('TWITTER_CONSUMER_KEY')) == 0:
            # Load .env only in Notebook, it will be populated at runtime by docker
            from pathlib import Path
            env_path = Path('..') / '.env'
            if env_path.is_file():
                load_dotenv(dotenv_path=env_path)
            else:
                print('ERROR : no env !')
                exit(4)
        # Logging
        self.logger = logging.getLogger("tweet-archiveur")
        logFormatter = logging.Formatter("%(asctime)s -  %(name)-12s %(levelname)-8s %(message)s")
        self.logger.setLevel(logging.DEBUG)
        # # File logger
        # fh = logging.FileHandler("tweet-archiveur.log")
        # fh.setLevel(logging.DEBUG)
        # fh.setFormatter(logFormatter)
        # logger.addHandler(fh)
        if not len(self.logger.handlers):
            # Console logger
            consoleHandler = logging.StreamHandler()
            consoleHandler.setFormatter(logFormatter)
            self.logger.addHandler(consoleHandler)
        self.logger.info(f'Scrapper ready')

    def get_users_accounts(self, csv = None):
        csv = getenv("USERS_CSV") if csv is None else csv
        return pd.read_csv(csv)

    # Convert UTC to Local based on the current date (do not work well around the day we change from/to summertime)
    def datetime_from_utc_to_local(self, utc_datetime):
        now_timestamp = time.time()
        offset = datetime.datetime.fromtimestamp(now_timestamp) - datetime.datetime.utcfromtimestamp(now_timestamp)
        return utc_datetime + offset


    def get_user_tweets(self, user_id):
        auth = tweepy.AppAuthHandler(getenv("TWITTER_CONSUMER_KEY"), getenv("TWITTER_CONSUMER_SECRET"))
        api = tweepy.API(auth, wait_on_rate_limit=True)
        tweets = []
        hashtags = []
        for tweet in tweepy.Cursor(api.user_timeline, id=user_id, tweet_mode='extended').items(100):
            tweet_tmp = {
                'twitter_id' : user_id,
                'tweet_id' : tweet.id,
                'datetime_utc' : tweet.created_at,
                'datetime_local' : self.datetime_from_utc_to_local(tweet.created_at),
                'text' : tweet.full_text, # .encode('utf8')
                'retweet' : tweet.retweet_count,
                'favorite' : tweet.favorite_count
            }
            tweets.append(tweet_tmp)
            for h in tweet.entities.get('hashtags'):
                hashtag = {
                    'tweet_id' : tweet_tmp['tweet_id'],
                    'twitter_id' : tweet_tmp['twitter_id'],
                    'datetime_local' : tweet_tmp['datetime_local'],
                    'hashtag' : h['text']
                }
                hashtags.append(hashtag)
        return tweets, hashtags

    '''
    Get all the tweets of all the users
    input : a list of twitter_id
    output : a list of all tweets
    '''
    def get_all_tweet_as_array(self, users_id):
        tweets = []
        hashtags = []
        total_users = len(users_id)
        for i, user_id in enumerate(users_id):
            tweets_tmp, hashtags_tmp = self.get_user_tweets(user_id)
            tweets += tweets_tmp
            hashtags += hashtags_tmp
            if i % 10 == 0:
                info_str = f'Processing user {i} / {total_users} ({(i*100//total_users*100)/100}%)'
                if self.logger is not None:
                    self.logger.debug(info_str)
                else:
                    print(info_str)
            #if i>3:
            #    break
        return tweets, hashtags


    def get_all_tweet_and_store_them(self, database, users_id_to_process):
        # Do a while loop to handle retry on error
        # We store a list of remaining id to process
        total_tweet = 0
        total_users = len(users_id_to_process)
        consecutive_fail = 0
        while len(users_id_to_process) > 0:
            user_id = users_id_to_process[0]
            try:
                # Get tweets
                tweets, hashtags = self.get_user_tweets(user_id)
            except tweepy.TweepError as e:
                if '401' in e.reason :
                    self.logger.warning(f'Error processing {user_id} : The user have a private account, skipping.')
                    users_id_to_process.pop(0)
                    continue
                self.logger.warning(f'Error processing {user_id} : tweepy.TweepError={e.reason} We will retry in 16 minutes to respect twitter API Rate Limit')
                consecutive_fail += 1
                if consecutive_fail > 3:
                    self.logger.error(f'We fail {consecutive_fail} consecutive times, exiting.')
                    exit(3)
                time.sleep(16*60*consecutive_fail)
                # We shuffle the list to try another user next time
                random.shuffle(users_id_to_process)
                continue
            except:
                e = sys.exc_info()[0]
                self.logger.error(f'UNKNOW ERROR processing {user_id} STOPPING : Error={e}')
                exit(2)
            try:
                # Save them to database
                database.insert_tweets(pd.DataFrame(tweets))
                database.insert_hashtags(pd.DataFrame(hashtags))
            except:
                e = sys.exc_info()[0]
                self.logger.error(f'UNKNOW ERROR processing {user_id} STOPPING : Error={e}')
                exit(1)
            # Yes, we succeded
            consecutive_fail = 0
            # Remove user from the list to process
            users_id_to_process.pop(0)
            total_tweet += len(tweets)
            i = total_users - len(users_id_to_process)
            if i % 10 == 0:
                self.logger.debug(f'We got {total_tweet} tweets for now. Processing user {i} / {total_users} ({(i*100//total_users*100)/100}%) {user_id=} ...')
        self.logger.info(f'Done scrapping, we got {total_tweet} tweets from {total_users} tweetos.')

# Cell
scrapper = Scrapper()