# coding: utf-8

"""
    Turbinia API Server

    Turbinia is an open-source framework for deploying, managing, and running distributed forensic workloads

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic import BaseModel

class CompleteTurbiniaStats(BaseModel):
    """
    Statistics for different groups of tasks.  # noqa: E501
    """
    all_tasks: Optional[Dict[str, Any]] = None
    failed_tasks: Optional[Dict[str, Any]] = None
    requests: Optional[Dict[str, Any]] = None
    successful_tasks: Optional[Dict[str, Any]] = None
    tasks_per_type: Optional[Dict[str, Any]] = None
    tasks_per_user: Optional[Dict[str, Any]] = None
    tasks_per_worker: Optional[Dict[str, Any]] = None
    __properties = ["all_tasks", "failed_tasks", "requests", "successful_tasks", "tasks_per_type", "tasks_per_user", "tasks_per_worker"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CompleteTurbiniaStats:
        """Create an instance of CompleteTurbiniaStats from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CompleteTurbiniaStats:
        """Create an instance of CompleteTurbiniaStats from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CompleteTurbiniaStats.parse_obj(obj)

        _obj = CompleteTurbiniaStats.parse_obj({
            "all_tasks": obj.get("all_tasks"),
            "failed_tasks": obj.get("failed_tasks"),
            "requests": obj.get("requests"),
            "successful_tasks": obj.get("successful_tasks"),
            "tasks_per_type": obj.get("tasks_per_type"),
            "tasks_per_user": obj.get("tasks_per_user"),
            "tasks_per_worker": obj.get("tasks_per_worker")
        })
        return _obj


