# coding: utf-8

"""
    Turbinia API Server

    Turbinia is an open-source framework for deploying, managing, and running distributed forensic workloads

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, StrictInt, StrictStr, conlist

class BaseRequestOptions(BaseModel):
    """
    Base Request Options class to be extended by other option types.   # noqa: E501
    """
    filter_patterns: Optional[conlist(StrictStr)] = None
    group_id: Optional[StrictStr] = None
    jobs_allowlist: Optional[conlist(StrictStr)] = None
    jobs_denylist: Optional[conlist(StrictStr)] = None
    reason: Optional[StrictStr] = None
    recipe_data: Optional[StrictStr] = None
    recipe_name: Optional[StrictStr] = None
    request_id: Optional[StrictStr] = None
    requester: Optional[StrictStr] = None
    sketch_id: Optional[StrictInt] = None
    yara_rules: Optional[StrictStr] = None
    __properties = ["filter_patterns", "group_id", "jobs_allowlist", "jobs_denylist", "reason", "recipe_data", "recipe_name", "request_id", "requester", "sketch_id", "yara_rules"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BaseRequestOptions:
        """Create an instance of BaseRequestOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BaseRequestOptions:
        """Create an instance of BaseRequestOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return BaseRequestOptions.parse_obj(obj)

        _obj = BaseRequestOptions.parse_obj({
            "filter_patterns": obj.get("filter_patterns"),
            "group_id": obj.get("group_id"),
            "jobs_allowlist": obj.get("jobs_allowlist"),
            "jobs_denylist": obj.get("jobs_denylist"),
            "reason": obj.get("reason"),
            "recipe_data": obj.get("recipe_data"),
            "recipe_name": obj.get("recipe_name"),
            "request_id": obj.get("request_id"),
            "requester": obj.get("requester"),
            "sketch_id": obj.get("sketch_id"),
            "yara_rules": obj.get("yara_rules")
        })
        return _obj


