"use strict";
const assert_1 = require("@aws-cdk/assert");
const codecommit = require("@aws-cdk/aws-codecommit");
const codepipeline = require("@aws-cdk/aws-codepipeline");
const core_1 = require("@aws-cdk/core");
const cpactions = require("../../lib");
/**
 * A test stack with a half-prepared pipeline ready to add CloudFormation actions to
 */
class TestFixture extends core_1.Stack {
    constructor() {
        super();
        this.pipeline = new codepipeline.Pipeline(this, 'Pipeline');
        this.sourceStage = this.pipeline.addStage({ stageName: 'Source' });
        this.deployStage = this.pipeline.addStage({ stageName: 'Deploy' });
        this.repo = new codecommit.Repository(this, 'MyVeryImportantRepo', {
            repositoryName: 'my-very-important-repo',
        });
        this.sourceOutput = new codepipeline.Artifact('SourceArtifact');
        const source = new cpactions.CodeCommitSourceAction({
            actionName: 'Source',
            output: this.sourceOutput,
            repository: this.repo,
        });
        this.sourceStage.addAction(source);
    }
}
module.exports = {
    'addAction succesfully leads to creation of codepipeline service catalog action'(test) {
        // GIVEN
        const stack = new TestFixture();
        // WHEN
        stack.deployStage.addAction(new cpactions.ServiceCatalogDeployAction({
            actionName: 'ServiceCatalogTest',
            templatePath: stack.sourceOutput.atPath('template.yaml'),
            productVersionDescription: 'This is a description of the version.',
            productVersionName: 'VersionName',
            productId: 'prod-xxxxxxxxx',
        }));
        // THEN
        assert_1.expect(stack).to(assert_1.haveResourceLike('AWS::CodePipeline::Pipeline', {
            'Stages': [
                { 'Name': 'Source' /* don't care about the rest */ },
                {
                    'Name': 'Deploy',
                    'Actions': [
                        {
                            'ActionTypeId': {
                                'Category': 'Deploy',
                                'Owner': 'AWS',
                                'Provider': 'ServiceCatalog',
                                'Version': '1',
                            },
                            'Configuration': {
                                'TemplateFilePath': 'SourceArtifact::template.yaml',
                                'ProductVersionDescription': 'This is a description of the version.',
                                'ProductVersionName': 'VersionName',
                                'ProductType': 'CLOUD_FORMATION_TEMPLATE',
                                'ProductId': 'prod-xxxxxxxxx',
                            },
                            'InputArtifacts': [
                                {
                                    'Name': 'SourceArtifact',
                                },
                            ],
                            'Name': 'ServiceCatalogTest',
                        },
                    ],
                },
            ],
        }));
        test.done();
    },
    'deployment without a description works successfully'(test) {
        // GIVEN
        const stack = new TestFixture();
        // WHEN
        stack.deployStage.addAction(new cpactions.ServiceCatalogDeployAction({
            actionName: 'ServiceCatalogTest',
            templatePath: stack.sourceOutput.atPath('template.yaml'),
            productVersionName: 'VersionName',
            productId: 'prod-xxxxxxxxx',
        }));
        // THEN
        assert_1.expect(stack).to(assert_1.haveResourceLike('AWS::CodePipeline::Pipeline', {
            'Stages': [
                { 'Name': 'Source' /* don't care about the rest */ },
                {
                    'Name': 'Deploy',
                    'Actions': [
                        {
                            'ActionTypeId': {
                                'Category': 'Deploy',
                                'Owner': 'AWS',
                                'Provider': 'ServiceCatalog',
                                'Version': '1',
                            },
                            'Configuration': {
                                'TemplateFilePath': 'SourceArtifact::template.yaml',
                                'ProductVersionName': 'VersionName',
                                'ProductType': 'CLOUD_FORMATION_TEMPLATE',
                                'ProductId': 'prod-xxxxxxxxx',
                            },
                            'InputArtifacts': [
                                {
                                    'Name': 'SourceArtifact',
                                },
                            ],
                            'Name': 'ServiceCatalogTest',
                        },
                    ],
                },
            ],
        }));
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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