# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class WfmIntradayDataUpdateTopicIntradayPerformancePredictionQueueData(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        WfmIntradayDataUpdateTopicIntradayPerformancePredictionQueueData - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'service_level_percent': 'float',
            'average_speed_of_answer_seconds': 'float',
            'number_of_interactions': 'float'
        }

        self.attribute_map = {
            'service_level_percent': 'serviceLevelPercent',
            'average_speed_of_answer_seconds': 'averageSpeedOfAnswerSeconds',
            'number_of_interactions': 'numberOfInteractions'
        }

        self._service_level_percent = None
        self._average_speed_of_answer_seconds = None
        self._number_of_interactions = None

    @property
    def service_level_percent(self):
        """
        Gets the service_level_percent of this WfmIntradayDataUpdateTopicIntradayPerformancePredictionQueueData.


        :return: The service_level_percent of this WfmIntradayDataUpdateTopicIntradayPerformancePredictionQueueData.
        :rtype: float
        """
        return self._service_level_percent

    @service_level_percent.setter
    def service_level_percent(self, service_level_percent):
        """
        Sets the service_level_percent of this WfmIntradayDataUpdateTopicIntradayPerformancePredictionQueueData.


        :param service_level_percent: The service_level_percent of this WfmIntradayDataUpdateTopicIntradayPerformancePredictionQueueData.
        :type: float
        """
        

        self._service_level_percent = service_level_percent

    @property
    def average_speed_of_answer_seconds(self):
        """
        Gets the average_speed_of_answer_seconds of this WfmIntradayDataUpdateTopicIntradayPerformancePredictionQueueData.


        :return: The average_speed_of_answer_seconds of this WfmIntradayDataUpdateTopicIntradayPerformancePredictionQueueData.
        :rtype: float
        """
        return self._average_speed_of_answer_seconds

    @average_speed_of_answer_seconds.setter
    def average_speed_of_answer_seconds(self, average_speed_of_answer_seconds):
        """
        Sets the average_speed_of_answer_seconds of this WfmIntradayDataUpdateTopicIntradayPerformancePredictionQueueData.


        :param average_speed_of_answer_seconds: The average_speed_of_answer_seconds of this WfmIntradayDataUpdateTopicIntradayPerformancePredictionQueueData.
        :type: float
        """
        

        self._average_speed_of_answer_seconds = average_speed_of_answer_seconds

    @property
    def number_of_interactions(self):
        """
        Gets the number_of_interactions of this WfmIntradayDataUpdateTopicIntradayPerformancePredictionQueueData.


        :return: The number_of_interactions of this WfmIntradayDataUpdateTopicIntradayPerformancePredictionQueueData.
        :rtype: float
        """
        return self._number_of_interactions

    @number_of_interactions.setter
    def number_of_interactions(self, number_of_interactions):
        """
        Sets the number_of_interactions of this WfmIntradayDataUpdateTopicIntradayPerformancePredictionQueueData.


        :param number_of_interactions: The number_of_interactions of this WfmIntradayDataUpdateTopicIntradayPerformancePredictionQueueData.
        :type: float
        """
        

        self._number_of_interactions = number_of_interactions

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

