# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class KnowledgeExtendedCategory(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        KnowledgeExtendedCategory - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'knowledge_base': 'KnowledgeBase',
            'language_code': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'parent': 'KnowledgeCategory',
            'children': 'list[KnowledgeCategory]',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'knowledge_base': 'knowledgeBase',
            'language_code': 'languageCode',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'parent': 'parent',
            'children': 'children',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._description = None
        self._knowledge_base = None
        self._language_code = None
        self._date_created = None
        self._date_modified = None
        self._parent = None
        self._children = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this KnowledgeExtendedCategory.
        The globally unique identifier for the object.

        :return: The id of this KnowledgeExtendedCategory.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this KnowledgeExtendedCategory.
        The globally unique identifier for the object.

        :param id: The id of this KnowledgeExtendedCategory.
        :type: str
        """
        

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this KnowledgeExtendedCategory.
        Category name

        :return: The name of this KnowledgeExtendedCategory.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this KnowledgeExtendedCategory.
        Category name

        :param name: The name of this KnowledgeExtendedCategory.
        :type: str
        """
        

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this KnowledgeExtendedCategory.
        Category description

        :return: The description of this KnowledgeExtendedCategory.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this KnowledgeExtendedCategory.
        Category description

        :param description: The description of this KnowledgeExtendedCategory.
        :type: str
        """
        

        self._description = description

    @property
    def knowledge_base(self):
        """
        Gets the knowledge_base of this KnowledgeExtendedCategory.
        Knowledge base which category does belong to

        :return: The knowledge_base of this KnowledgeExtendedCategory.
        :rtype: KnowledgeBase
        """
        return self._knowledge_base

    @knowledge_base.setter
    def knowledge_base(self, knowledge_base):
        """
        Sets the knowledge_base of this KnowledgeExtendedCategory.
        Knowledge base which category does belong to

        :param knowledge_base: The knowledge_base of this KnowledgeExtendedCategory.
        :type: KnowledgeBase
        """
        

        self._knowledge_base = knowledge_base

    @property
    def language_code(self):
        """
        Gets the language_code of this KnowledgeExtendedCategory.
        Actual language of the category

        :return: The language_code of this KnowledgeExtendedCategory.
        :rtype: str
        """
        return self._language_code

    @language_code.setter
    def language_code(self, language_code):
        """
        Sets the language_code of this KnowledgeExtendedCategory.
        Actual language of the category

        :param language_code: The language_code of this KnowledgeExtendedCategory.
        :type: str
        """
        allowed_values = ["en-US", "en-UK", "en-AU", "en-CA", "en-HK", "en-IN", "en-IE", "en-NZ", "en-PH", "en-SG", "en-ZA", "de-DE", "de-AT", "de-CH", "es-AR", "es-CO", "es-MX", "es-US", "es-ES", "fr-FR", "fr-BE", "fr-CA", "fr-CH", "pt-BR", "pt-PT", "nl-NL", "nl-BE", "it-IT"]
        if language_code.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for language_code -> " + language_code)
            self._language_code = "outdated_sdk_version"
        else:
            self._language_code = language_code

    @property
    def date_created(self):
        """
        Gets the date_created of this KnowledgeExtendedCategory.
        Category creation date-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this KnowledgeExtendedCategory.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created):
        """
        Sets the date_created of this KnowledgeExtendedCategory.
        Category creation date-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this KnowledgeExtendedCategory.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self):
        """
        Gets the date_modified of this KnowledgeExtendedCategory.
        Category last modification date-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this KnowledgeExtendedCategory.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified):
        """
        Sets the date_modified of this KnowledgeExtendedCategory.
        Category last modification date-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this KnowledgeExtendedCategory.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def parent(self):
        """
        Gets the parent of this KnowledgeExtendedCategory.
        Category parent

        :return: The parent of this KnowledgeExtendedCategory.
        :rtype: KnowledgeCategory
        """
        return self._parent

    @parent.setter
    def parent(self, parent):
        """
        Sets the parent of this KnowledgeExtendedCategory.
        Category parent

        :param parent: The parent of this KnowledgeExtendedCategory.
        :type: KnowledgeCategory
        """
        

        self._parent = parent

    @property
    def children(self):
        """
        Gets the children of this KnowledgeExtendedCategory.
        Category children

        :return: The children of this KnowledgeExtendedCategory.
        :rtype: list[KnowledgeCategory]
        """
        return self._children

    @children.setter
    def children(self, children):
        """
        Sets the children of this KnowledgeExtendedCategory.
        Category children

        :param children: The children of this KnowledgeExtendedCategory.
        :type: list[KnowledgeCategory]
        """
        

        self._children = children

    @property
    def self_uri(self):
        """
        Gets the self_uri of this KnowledgeExtendedCategory.
        The URI for this object

        :return: The self_uri of this KnowledgeExtendedCategory.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this KnowledgeExtendedCategory.
        The URI for this object

        :param self_uri: The self_uri of this KnowledgeExtendedCategory.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

