# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ActionMapEstimateResult(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ActionMapEstimateResult - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'qualified_session_count': 'int',
            'total_session_count': 'int',
            'per_segment_counts': 'list[SegmentEstimateCount]',
            'outcomes_scores_count': 'int'
        }

        self.attribute_map = {
            'qualified_session_count': 'qualifiedSessionCount',
            'total_session_count': 'totalSessionCount',
            'per_segment_counts': 'perSegmentCounts',
            'outcomes_scores_count': 'outcomesScoresCount'
        }

        self._qualified_session_count = None
        self._total_session_count = None
        self._per_segment_counts = None
        self._outcomes_scores_count = None

    @property
    def qualified_session_count(self):
        """
        Gets the qualified_session_count of this ActionMapEstimateResult.
        Number of sessions qualified for Action map.

        :return: The qualified_session_count of this ActionMapEstimateResult.
        :rtype: int
        """
        return self._qualified_session_count

    @qualified_session_count.setter
    def qualified_session_count(self, qualified_session_count):
        """
        Sets the qualified_session_count of this ActionMapEstimateResult.
        Number of sessions qualified for Action map.

        :param qualified_session_count: The qualified_session_count of this ActionMapEstimateResult.
        :type: int
        """
        

        self._qualified_session_count = qualified_session_count

    @property
    def total_session_count(self):
        """
        Gets the total_session_count of this ActionMapEstimateResult.
        Total number of sessions.

        :return: The total_session_count of this ActionMapEstimateResult.
        :rtype: int
        """
        return self._total_session_count

    @total_session_count.setter
    def total_session_count(self, total_session_count):
        """
        Sets the total_session_count of this ActionMapEstimateResult.
        Total number of sessions.

        :param total_session_count: The total_session_count of this ActionMapEstimateResult.
        :type: int
        """
        

        self._total_session_count = total_session_count

    @property
    def per_segment_counts(self):
        """
        Gets the per_segment_counts of this ActionMapEstimateResult.
        Number of sessions qualified for Action map per segment.

        :return: The per_segment_counts of this ActionMapEstimateResult.
        :rtype: list[SegmentEstimateCount]
        """
        return self._per_segment_counts

    @per_segment_counts.setter
    def per_segment_counts(self, per_segment_counts):
        """
        Sets the per_segment_counts of this ActionMapEstimateResult.
        Number of sessions qualified for Action map per segment.

        :param per_segment_counts: The per_segment_counts of this ActionMapEstimateResult.
        :type: list[SegmentEstimateCount]
        """
        

        self._per_segment_counts = per_segment_counts

    @property
    def outcomes_scores_count(self):
        """
        Gets the outcomes_scores_count of this ActionMapEstimateResult.
        Difference made by outcome criteria to number of sessions qualified for Action map.

        :return: The outcomes_scores_count of this ActionMapEstimateResult.
        :rtype: int
        """
        return self._outcomes_scores_count

    @outcomes_scores_count.setter
    def outcomes_scores_count(self, outcomes_scores_count):
        """
        Sets the outcomes_scores_count of this ActionMapEstimateResult.
        Difference made by outcome criteria to number of sessions qualified for Action map.

        :param outcomes_scores_count: The outcomes_scores_count of this ActionMapEstimateResult.
        :type: int
        """
        

        self._outcomes_scores_count = outcomes_scores_count

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

