/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.AbstractPartial;
import org.joda.time.field.AbstractPartialFieldProperty;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class Partial
extends AbstractPartial
implements ReadablePartial,
Serializable {
    private static final long serialVersionUID = 12324121189002L;
    private final Chronology iChronology;
    private final DateTimeFieldType[] iTypes;
    private final int[] iValues;
    private transient DateTimeFormatter[] iFormatter;

    public Partial() {
        this((Chronology)null);
    }

    public Partial(Chronology chronology) {
        this.iChronology = DateTimeUtils.getChronology(chronology).withUTC();
        this.iTypes = new DateTimeFieldType[0];
        this.iValues = new int[0];
    }

    public Partial(DateTimeFieldType dateTimeFieldType, int n2) {
        this(dateTimeFieldType, n2, null);
    }

    public Partial(DateTimeFieldType dateTimeFieldType, int n2, Chronology chronology) {
        this.iChronology = chronology = DateTimeUtils.getChronology(chronology).withUTC();
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("The field type must not be null");
        }
        this.iTypes = new DateTimeFieldType[]{dateTimeFieldType};
        this.iValues = new int[]{n2};
        chronology.validate(this, this.iValues);
    }

    public Partial(DateTimeFieldType[] dateTimeFieldTypeArray, int[] nArray) {
        this(dateTimeFieldTypeArray, nArray, null);
    }

    public Partial(DateTimeFieldType[] dateTimeFieldTypeArray, int[] nArray, Chronology chronology) {
        this.iChronology = chronology = DateTimeUtils.getChronology(chronology).withUTC();
        if (dateTimeFieldTypeArray == null) {
            throw new IllegalArgumentException("Types array must not be null");
        }
        if (nArray == null) {
            throw new IllegalArgumentException("Values array must not be null");
        }
        if (nArray.length != dateTimeFieldTypeArray.length) {
            throw new IllegalArgumentException("Values array must be the same length as the types array");
        }
        if (dateTimeFieldTypeArray.length == 0) {
            this.iTypes = dateTimeFieldTypeArray;
            this.iValues = nArray;
            return;
        }
        for (int i2 = 0; i2 < dateTimeFieldTypeArray.length; ++i2) {
            if (dateTimeFieldTypeArray[i2] != null) continue;
            throw new IllegalArgumentException("Types array must not contain null: index " + i2);
        }
        DurationField durationField = null;
        for (int i3 = 0; i3 < dateTimeFieldTypeArray.length; ++i3) {
            DateTimeFieldType dateTimeFieldType = dateTimeFieldTypeArray[i3];
            DurationField durationField2 = dateTimeFieldType.getDurationType().getField(this.iChronology);
            if (i3 > 0) {
                if (!durationField2.isSupported()) {
                    if (durationField.isSupported()) {
                        throw new IllegalArgumentException("Types array must be in order largest-smallest: " + dateTimeFieldTypeArray[i3 - 1].getName() + " < " + dateTimeFieldType.getName());
                    }
                    throw new IllegalArgumentException("Types array must not contain duplicate unsupported: " + dateTimeFieldTypeArray[i3 - 1].getName() + " and " + dateTimeFieldType.getName());
                }
                int n2 = durationField.compareTo(durationField2);
                if (n2 < 0) {
                    throw new IllegalArgumentException("Types array must be in order largest-smallest: " + dateTimeFieldTypeArray[i3 - 1].getName() + " < " + dateTimeFieldType.getName());
                }
                if (n2 == 0) {
                    if (durationField.equals(durationField2)) {
                        DurationFieldType durationFieldType = dateTimeFieldTypeArray[i3 - 1].getRangeDurationType();
                        DurationFieldType durationFieldType2 = dateTimeFieldType.getRangeDurationType();
                        if (durationFieldType == null) {
                            if (durationFieldType2 == null) {
                                throw new IllegalArgumentException("Types array must not contain duplicate: " + dateTimeFieldTypeArray[i3 - 1].getName() + " and " + dateTimeFieldType.getName());
                            }
                        } else {
                            DurationField durationField3;
                            if (durationFieldType2 == null) {
                                throw new IllegalArgumentException("Types array must be in order largest-smallest: " + dateTimeFieldTypeArray[i3 - 1].getName() + " < " + dateTimeFieldType.getName());
                            }
                            DurationField durationField4 = durationFieldType.getField(this.iChronology);
                            if (durationField4.compareTo(durationField3 = durationFieldType2.getField(this.iChronology)) < 0) {
                                throw new IllegalArgumentException("Types array must be in order largest-smallest: " + dateTimeFieldTypeArray[i3 - 1].getName() + " < " + dateTimeFieldType.getName());
                            }
                            if (durationField4.compareTo(durationField3) == 0) {
                                throw new IllegalArgumentException("Types array must not contain duplicate: " + dateTimeFieldTypeArray[i3 - 1].getName() + " and " + dateTimeFieldType.getName());
                            }
                        }
                    } else if (durationField.isSupported() && durationField.getType() != DurationFieldType.YEARS_TYPE) {
                        throw new IllegalArgumentException("Types array must be in order largest-smallest, for year-based fields, years is defined as being largest: " + dateTimeFieldTypeArray[i3 - 1].getName() + " < " + dateTimeFieldType.getName());
                    }
                }
            }
            durationField = durationField2;
        }
        this.iTypes = (DateTimeFieldType[])dateTimeFieldTypeArray.clone();
        chronology.validate(this, nArray);
        this.iValues = (int[])nArray.clone();
    }

    public Partial(ReadablePartial readablePartial) {
        if (readablePartial == null) {
            throw new IllegalArgumentException("The partial must not be null");
        }
        this.iChronology = DateTimeUtils.getChronology(readablePartial.getChronology()).withUTC();
        this.iTypes = new DateTimeFieldType[readablePartial.size()];
        this.iValues = new int[readablePartial.size()];
        for (int i2 = 0; i2 < readablePartial.size(); ++i2) {
            this.iTypes[i2] = readablePartial.getFieldType(i2);
            this.iValues[i2] = readablePartial.getValue(i2);
        }
    }

    Partial(Partial partial, int[] nArray) {
        this.iChronology = partial.iChronology;
        this.iTypes = partial.iTypes;
        this.iValues = nArray;
    }

    Partial(Chronology chronology, DateTimeFieldType[] dateTimeFieldTypeArray, int[] nArray) {
        this.iChronology = chronology;
        this.iTypes = dateTimeFieldTypeArray;
        this.iValues = nArray;
    }

    public int size() {
        return this.iTypes.length;
    }

    public Chronology getChronology() {
        return this.iChronology;
    }

    protected DateTimeField getField(int n2, Chronology chronology) {
        return this.iTypes[n2].getField(chronology);
    }

    public DateTimeFieldType getFieldType(int n2) {
        return this.iTypes[n2];
    }

    public DateTimeFieldType[] getFieldTypes() {
        return (DateTimeFieldType[])this.iTypes.clone();
    }

    public int getValue(int n2) {
        return this.iValues[n2];
    }

    public int[] getValues() {
        return (int[])this.iValues.clone();
    }

    public Partial withChronologyRetainFields(Chronology chronology) {
        chronology = DateTimeUtils.getChronology(chronology);
        if ((chronology = chronology.withUTC()) == this.getChronology()) {
            return this;
        }
        Partial partial = new Partial(chronology, this.iTypes, this.iValues);
        chronology.validate(partial, this.iValues);
        return partial;
    }

    public Partial with(DateTimeFieldType dateTimeFieldType, int n2) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("The field type must not be null");
        }
        int n3 = this.indexOf(dateTimeFieldType);
        if (n3 == -1) {
            Serializable serializable;
            int n4;
            DateTimeFieldType[] dateTimeFieldTypeArray = new DateTimeFieldType[this.iTypes.length + 1];
            int[] nArray = new int[dateTimeFieldTypeArray.length];
            DurationField durationField = dateTimeFieldType.getDurationType().getField(this.iChronology);
            if (durationField.isSupported()) {
                DurationField durationField2;
                DurationField durationField3;
                int n5;
                DurationField durationField4;
                for (n4 = 0; !(n4 >= this.iTypes.length || (durationField4 = (serializable = this.iTypes[n4]).getDurationType().getField(this.iChronology)).isSupported() && ((n5 = durationField.compareTo(durationField4)) > 0 || n5 == 0 && (dateTimeFieldType.getRangeDurationType() == null || serializable.getRangeDurationType() != null && (durationField3 = dateTimeFieldType.getRangeDurationType().getField(this.iChronology)).compareTo(durationField2 = serializable.getRangeDurationType().getField(this.iChronology)) > 0))); ++n4) {
                }
            }
            System.arraycopy(this.iTypes, 0, dateTimeFieldTypeArray, 0, n4);
            System.arraycopy(this.iValues, 0, nArray, 0, n4);
            dateTimeFieldTypeArray[n4] = dateTimeFieldType;
            nArray[n4] = n2;
            System.arraycopy(this.iTypes, n4, dateTimeFieldTypeArray, n4 + 1, dateTimeFieldTypeArray.length - n4 - 1);
            System.arraycopy(this.iValues, n4, nArray, n4 + 1, nArray.length - n4 - 1);
            serializable = new Partial(dateTimeFieldTypeArray, nArray, this.iChronology);
            this.iChronology.validate((ReadablePartial)((Object)serializable), nArray);
            return serializable;
        }
        if (n2 == this.getValue(n3)) {
            return this;
        }
        int[] nArray = this.getValues();
        nArray = this.getField(n3).set(this, n3, nArray, n2);
        return new Partial(this, nArray);
    }

    public Partial without(DateTimeFieldType dateTimeFieldType) {
        int n2 = this.indexOf(dateTimeFieldType);
        if (n2 != -1) {
            DateTimeFieldType[] dateTimeFieldTypeArray = new DateTimeFieldType[this.size() - 1];
            int[] nArray = new int[this.size() - 1];
            System.arraycopy(this.iTypes, 0, dateTimeFieldTypeArray, 0, n2);
            System.arraycopy(this.iTypes, n2 + 1, dateTimeFieldTypeArray, n2, dateTimeFieldTypeArray.length - n2);
            System.arraycopy(this.iValues, 0, nArray, 0, n2);
            System.arraycopy(this.iValues, n2 + 1, nArray, n2, nArray.length - n2);
            Partial partial = new Partial(this.iChronology, dateTimeFieldTypeArray, nArray);
            this.iChronology.validate(partial, nArray);
            return partial;
        }
        return this;
    }

    public Partial withField(DateTimeFieldType dateTimeFieldType, int n2) {
        int n3 = this.indexOfSupported(dateTimeFieldType);
        if (n2 == this.getValue(n3)) {
            return this;
        }
        int[] nArray = this.getValues();
        nArray = this.getField(n3).set(this, n3, nArray, n2);
        return new Partial(this, nArray);
    }

    public Partial withFieldAdded(DurationFieldType durationFieldType, int n2) {
        int n3 = this.indexOfSupported(durationFieldType);
        if (n2 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        nArray = this.getField(n3).add(this, n3, nArray, n2);
        return new Partial(this, nArray);
    }

    public Partial withFieldAddWrapped(DurationFieldType durationFieldType, int n2) {
        int n3 = this.indexOfSupported(durationFieldType);
        if (n2 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        nArray = this.getField(n3).addWrapPartial(this, n3, nArray, n2);
        return new Partial(this, nArray);
    }

    public Partial withPeriodAdded(ReadablePeriod readablePeriod, int n2) {
        if (readablePeriod == null || n2 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        for (int i2 = 0; i2 < readablePeriod.size(); ++i2) {
            DurationFieldType durationFieldType = readablePeriod.getFieldType(i2);
            int n3 = this.indexOf(durationFieldType);
            if (n3 < 0) continue;
            nArray = this.getField(n3).add(this, n3, nArray, FieldUtils.safeMultiply(readablePeriod.getValue(i2), n2));
        }
        return new Partial(this, nArray);
    }

    public Partial plus(ReadablePeriod readablePeriod) {
        return this.withPeriodAdded(readablePeriod, 1);
    }

    public Partial minus(ReadablePeriod readablePeriod) {
        return this.withPeriodAdded(readablePeriod, -1);
    }

    public Property property(DateTimeFieldType dateTimeFieldType) {
        return new Property(this, this.indexOfSupported(dateTimeFieldType));
    }

    public boolean isMatch(ReadableInstant readableInstant) {
        long l2 = DateTimeUtils.getInstantMillis(readableInstant);
        Chronology chronology = DateTimeUtils.getInstantChronology(readableInstant);
        for (int i2 = 0; i2 < this.iTypes.length; ++i2) {
            int n2 = this.iTypes[i2].getField(chronology).get(l2);
            if (n2 == this.iValues[i2]) continue;
            return false;
        }
        return true;
    }

    public boolean isMatch(ReadablePartial readablePartial) {
        if (readablePartial == null) {
            throw new IllegalArgumentException("The partial must not be null");
        }
        for (int i2 = 0; i2 < this.iTypes.length; ++i2) {
            int n2 = readablePartial.get(this.iTypes[i2]);
            if (n2 == this.iValues[i2]) continue;
            return false;
        }
        return true;
    }

    public DateTimeFormatter getFormatter() {
        DateTimeFormatter[] dateTimeFormatterArray = this.iFormatter;
        if (dateTimeFormatterArray == null) {
            if (this.size() == 0) {
                return null;
            }
            dateTimeFormatterArray = new DateTimeFormatter[2];
            try {
                ArrayList<DateTimeFieldType> arrayList = new ArrayList<DateTimeFieldType>(Arrays.asList(this.iTypes));
                dateTimeFormatterArray[0] = ISODateTimeFormat.forFields(arrayList, true, false);
                if (arrayList.size() == 0) {
                    dateTimeFormatterArray[1] = dateTimeFormatterArray[0];
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.iFormatter = dateTimeFormatterArray;
        }
        return dateTimeFormatterArray[0];
    }

    public String toString() {
        DateTimeFormatter dateTimeFormatter;
        DateTimeFormatter[] dateTimeFormatterArray = this.iFormatter;
        if (dateTimeFormatterArray == null) {
            this.getFormatter();
            dateTimeFormatterArray = this.iFormatter;
            if (dateTimeFormatterArray == null) {
                return this.toStringList();
            }
        }
        if ((dateTimeFormatter = dateTimeFormatterArray[1]) == null) {
            return this.toStringList();
        }
        return dateTimeFormatter.print(this);
    }

    public String toStringList() {
        int n2 = this.size();
        StringBuilder stringBuilder = new StringBuilder(20 * n2);
        stringBuilder.append('[');
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',').append(' ');
            }
            stringBuilder.append(this.iTypes[i2].getName());
            stringBuilder.append('=');
            stringBuilder.append(this.iValues[i2]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString(String string) {
        if (string == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(string).print(this);
    }

    public String toString(String string, Locale locale) {
        if (string == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(string).withLocale(locale).print(this);
    }

    public static class Property
    extends AbstractPartialFieldProperty
    implements Serializable {
        private static final long serialVersionUID = 53278362873888L;
        private final Partial iPartial;
        private final int iFieldIndex;

        Property(Partial partial, int n2) {
            this.iPartial = partial;
            this.iFieldIndex = n2;
        }

        public DateTimeField getField() {
            return this.iPartial.getField(this.iFieldIndex);
        }

        protected ReadablePartial getReadablePartial() {
            return this.iPartial;
        }

        public Partial getPartial() {
            return this.iPartial;
        }

        public int get() {
            return this.iPartial.getValue(this.iFieldIndex);
        }

        public Partial addToCopy(int n2) {
            int[] nArray = this.iPartial.getValues();
            nArray = this.getField().add(this.iPartial, this.iFieldIndex, nArray, n2);
            return new Partial(this.iPartial, nArray);
        }

        public Partial addWrapFieldToCopy(int n2) {
            int[] nArray = this.iPartial.getValues();
            nArray = this.getField().addWrapField(this.iPartial, this.iFieldIndex, nArray, n2);
            return new Partial(this.iPartial, nArray);
        }

        public Partial setCopy(int n2) {
            int[] nArray = this.iPartial.getValues();
            nArray = this.getField().set(this.iPartial, this.iFieldIndex, nArray, n2);
            return new Partial(this.iPartial, nArray);
        }

        public Partial setCopy(String string, Locale locale) {
            int[] nArray = this.iPartial.getValues();
            nArray = this.getField().set(this.iPartial, this.iFieldIndex, nArray, string, locale);
            return new Partial(this.iPartial, nArray);
        }

        public Partial setCopy(String string) {
            return this.setCopy(string, null);
        }

        public Partial withMaximumValue() {
            return this.setCopy(this.getMaximumValue());
        }

        public Partial withMinimumValue() {
            return this.setCopy(this.getMinimumValue());
        }
    }
}

