/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.ml.metrics;

import ai.h2o.sparkling.ml.metrics.H2OGLMMetrics;
import ai.h2o.sparkling.ml.metrics.H2ORegressionMetrics;
import ai.h2o.sparkling.ml.metrics.MetricsDescription;
import com.google.gson.JsonObject;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.Identifiable$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@MetricsDescription(description="The class makes available all regression metrics supported by GLM algorithm.")
@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001B\u0001\u0003\u00015\u0011q\u0003\u0013\u001aP%\u0016<'/Z:tS>tw\tT'NKR\u0014\u0018nY:\u000b\u0005\r!\u0011aB7fiJL7m\u001d\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!C:qCJ\\G.\u001b8h\u0015\tI!\"A\u0002ie=T\u0011aC\u0001\u0003C&\u001c\u0001aE\u0002\u0001\u001dI\u0001\"a\u0004\t\u000e\u0003\tI!!\u0005\u0002\u0003)!\u0013tJU3he\u0016\u001c8/[8o\u001b\u0016$(/[2t!\ty1#\u0003\u0002\u0015\u0005\ti\u0001JM(H\u00196kU\r\u001e:jGND\u0001B\u0006\u0001\u0003\u0006\u0004%\teF\u0001\u0004k&$W#\u0001\r\u0011\u0005eybB\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\u0012A\u0002)sK\u0012,g-\u0003\u0002!C\t11\u000b\u001e:j]\u001eT!AH\u000e\t\u0011\r\u0002!\u0011!Q\u0001\na\tA!^5eA!)Q\u0005\u0001C\u0001M\u00051A(\u001b8jiz\"\"a\n\u0015\u0011\u0005=\u0001\u0001\"\u0002\f%\u0001\u0004A\u0002\"B\u0013\u0001\t\u0003QC#A\u0014\t\u000f1\u0002!\u0019!C\t[\u0005\u0001\"/Z:jIV\fG\u000eR3wS\u0006t7-Z\u000b\u0002]A\u0011q&O\u0007\u0002a)\u0011\u0011GM\u0001\u0006a\u0006\u0014\u0018-\u001c\u0006\u0003\u000bMR!\u0001N\u001b\u0002\u000bM\u0004\u0018M]6\u000b\u0005Y:\u0014AB1qC\u000eDWMC\u00019\u0003\ry'oZ\u0005\u0003uA\u00121\u0002R8vE2,\u0007+\u0019:b[\"1A\b\u0001Q\u0001\n9\n\u0011C]3tS\u0012,\u0018\r\u001c#fm&\fgnY3!\u0011\u001dq\u0004A1A\u0005\u00125\nAB\\;mY\u0012+g/[1oG\u0016Da\u0001\u0011\u0001!\u0002\u0013q\u0013!\u00048vY2$UM^5b]\u000e,\u0007\u0005C\u0004C\u0001\t\u0007I\u0011C\u0017\u0002\u0007\u0005L7\r\u0003\u0004E\u0001\u0001\u0006IAL\u0001\u0005C&\u001c\u0007\u0005C\u0004G\u0001\t\u0007I\u0011C$\u0002)9,H\u000e\u001c#fOJ,Wm](g\rJ,W\rZ8n+\u0005A\u0005CA\u0018J\u0013\tQ\u0005GA\u0005M_:<\u0007+\u0019:b[\"1A\n\u0001Q\u0001\n!\u000bQC\\;mY\u0012+wM]3fg>3gI]3fI>l\u0007\u0005C\u0004O\u0001\t\u0007I\u0011C$\u00021I,7/\u001b3vC2$Um\u001a:fKN|eM\u0012:fK\u0012|W\u000e\u0003\u0004Q\u0001\u0001\u0006I\u0001S\u0001\u001ae\u0016\u001c\u0018\u000eZ;bY\u0012+wM]3fg>3gI]3fI>l\u0007\u0005C\u0003S\u0001\u0011\u00051+A\nhKR\u0014Vm]5ek\u0006dG)\u001a<jC:\u001cW\rF\u0001U!\tQR+\u0003\u0002W7\t1Ai\\;cY\u0016DQ\u0001\u0017\u0001\u0005\u0002M\u000bqbZ3u\u001dVdG\u000eR3wS\u0006t7-\u001a\u0005\u00065\u0002!\taU\u0001\u0007O\u0016$\u0018)S\"\t\u000bq\u0003A\u0011A/\u0002/\u001d,GOT;mY\u0012+wM]3fg>3gI]3fI>lG#\u00010\u0011\u0005iy\u0016B\u00011\u001c\u0005\u0011auN\\4\t\u000b\t\u0004A\u0011A/\u00027\u001d,GOU3tS\u0012,\u0018\r\u001c#fOJ,Wm](g\rJ,W\rZ8n\u0011\u0015!\u0007\u0001\"\u0011f\u0003)\u0019X\r^'fiJL7m\u001d\u000b\u0004M&,\bC\u0001\u000eh\u0013\tA7D\u0001\u0003V]&$\b\"\u00026d\u0001\u0004Y\u0017\u0001\u00026t_:\u0004\"\u0001\\:\u000e\u00035T!A\\8\u0002\t\u001d\u001cxN\u001c\u0006\u0003aF\faaZ8pO2,'\"\u0001:\u0002\u0007\r|W.\u0003\u0002u[\nQ!j]8o\u001f\nTWm\u0019;\t\u000bY\u001c\u0007\u0019\u0001\r\u0002\u000f\r|g\u000e^3yi\")\u0001\u0010\u0001C!s\u0006!1m\u001c9z)\tQ80D\u0001\u0001\u0011\u0015ax\u000f1\u0001~\u0003\u0015)\u0007\u0010\u001e:b!\tyc0\u0003\u0002\u0000a\tA\u0001+\u0019:b[6\u000b\u0007\u000fK\u0004\u0001\u0003\u0007\tI!a\u0003\u0011\u0007=\t)!C\u0002\u0002\b\t\u0011!#T3ue&\u001c7\u000fR3tGJL\u0007\u000f^5p]\u0006YA-Z:de&\u0004H/[8oC\t\ti!\u0001'UQ\u0016\u00043\r\\1tg\u0002j\u0017m[3tA\u00054\u0018-\u001b7bE2,\u0007%\u00197mAI,wM]3tg&|g\u000eI7fiJL7m\u001d\u0011tkB\u0004xN\u001d;fI\u0002\u0012\u0017\u0010I$M\u001b\u0002\nGnZ8sSRDWN\f")
public class H2ORegressionGLMMetrics
extends H2ORegressionMetrics
implements H2OGLMMetrics {
    private final String uid;
    private final DoubleParam residualDeviance;
    private final DoubleParam nullDeviance;
    private final DoubleParam aic;
    private final LongParam nullDegreesOfFreedom;
    private final LongParam residualDegreesOfFreedom;

    @Override
    public String uid() {
        return this.uid;
    }

    public DoubleParam residualDeviance() {
        return this.residualDeviance;
    }

    public DoubleParam nullDeviance() {
        return this.nullDeviance;
    }

    public DoubleParam aic() {
        return this.aic;
    }

    public LongParam nullDegreesOfFreedom() {
        return this.nullDegreesOfFreedom;
    }

    public LongParam residualDegreesOfFreedom() {
        return this.residualDegreesOfFreedom;
    }

    @Override
    public double getResidualDeviance() {
        return BoxesRunTime.unboxToDouble(this.$(this.residualDeviance()));
    }

    @Override
    public double getNullDeviance() {
        return BoxesRunTime.unboxToDouble(this.$(this.nullDeviance()));
    }

    @Override
    public double getAIC() {
        return BoxesRunTime.unboxToDouble(this.$(this.aic()));
    }

    @Override
    public long getNullDegreesOfFreedom() {
        return BoxesRunTime.unboxToLong(this.$(this.nullDegreesOfFreedom()));
    }

    @Override
    public long getResidualDegreesOfFreedom() {
        return BoxesRunTime.unboxToLong(this.$(this.residualDegreesOfFreedom()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setMetrics(JsonObject json, String context) {
        Params params;
        Params params2;
        Params params3;
        Params params4;
        super.setMetrics(json, context);
        if (json.has("residual_deviance")) {
            try {
                params4 = this.set("residualDeviance", BoxesRunTime.boxToDouble((double)json.get("residual_deviance").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 == null) throw throwable;
                Throwable throwable3 = throwable2;
                String string = System.getProperty("spark.testing", "false");
                String string2 = "true";
                if (string == null) {
                    if (string2 == null) throw throwable;
                } else if (string.equals(string2)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'residual_deviance' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable3);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params4 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'residual_deviance' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string3 = "true";
            if (string == null) {
                if (string3 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string3)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$1;

                public final String apply() {
                    return this.message$1;
                }
                {
                    this.message$1 = message$1;
                }
            });
            params4 = BoxedUnit.UNIT;
        }
        if (json.has("null_deviance")) {
            try {
                params3 = this.set("nullDeviance", BoxesRunTime.boxToDouble((double)json.get("null_deviance").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable4 = throwable;
                if (throwable4 == null) throw throwable;
                Throwable throwable5 = throwable4;
                String string = System.getProperty("spark.testing", "false");
                String string4 = "true";
                if (string == null) {
                    if (string4 == null) throw throwable;
                } else if (string.equals(string4)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'null_deviance' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable5);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params3 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'null_deviance' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string5 = "true";
            if (string == null) {
                if (string5 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string5)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$2;

                public final String apply() {
                    return this.message$2;
                }
                {
                    this.message$2 = message$2;
                }
            });
            params3 = BoxedUnit.UNIT;
        }
        if (json.has("AIC")) {
            try {
                params2 = this.set("aic", BoxesRunTime.boxToDouble((double)json.get("AIC").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable6 = throwable;
                if (throwable6 == null) throw throwable;
                Throwable throwable7 = throwable6;
                String string = System.getProperty("spark.testing", "false");
                String string6 = "true";
                if (string == null) {
                    if (string6 == null) throw throwable;
                } else if (string.equals(string6)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'AIC' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable7);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params2 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'AIC' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string7 = "true";
            if (string == null) {
                if (string7 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string7)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$3;

                public final String apply() {
                    return this.message$3;
                }
                {
                    this.message$3 = message$3;
                }
            });
            params2 = BoxedUnit.UNIT;
        }
        if (json.has("null_degrees_of_freedom")) {
            try {
                params = this.set("nullDegreesOfFreedom", BoxesRunTime.boxToLong((long)json.get("null_degrees_of_freedom").getAsLong()));
            }
            catch (Throwable throwable) {
                Throwable throwable8 = throwable;
                if (throwable8 == null) throw throwable;
                Throwable throwable9 = throwable8;
                String string = System.getProperty("spark.testing", "false");
                String string8 = "true";
                if (string == null) {
                    if (string8 == null) throw throwable;
                } else if (string.equals(string8)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'null_degrees_of_freedom' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable9);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'null_degrees_of_freedom' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string9 = "true";
            if (string == null) {
                if (string9 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string9)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$4;

                public final String apply() {
                    return this.message$4;
                }
                {
                    this.message$4 = message$4;
                }
            });
            params = BoxedUnit.UNIT;
        }
        if (json.has("residual_degrees_of_freedom")) {
            try {
                this.set("residualDegreesOfFreedom", BoxesRunTime.boxToLong((long)json.get("residual_degrees_of_freedom").getAsLong()));
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable10 = throwable;
                if (throwable10 == null) throw throwable;
                Throwable throwable11 = throwable10;
                String string = System.getProperty("spark.testing", "false");
                String string10 = "true";
                if (string == null) {
                    if (string10 == null) throw throwable;
                } else if (string.equals(string10)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'residual_degrees_of_freedom' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable11);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'residual_degrees_of_freedom' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string11 = "true";
            if (string == null) {
                if (string11 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string11)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$5;

                public final String apply() {
                    return this.message$5;
                }
                {
                    this.message$5 = message$5;
                }
            });
            return;
        }
    }

    @Override
    public H2ORegressionGLMMetrics copy(ParamMap extra) {
        return (H2ORegressionGLMMetrics)this.defaultCopy(extra);
    }

    public H2ORegressionGLMMetrics(String uid) {
        this.uid = uid;
        this.residualDeviance = this.doubleParam("residualDeviance", "residual deviance.");
        this.nullDeviance = this.doubleParam("nullDeviance", "null deviance.");
        this.aic = this.doubleParam("aic", "AIC.");
        this.nullDegreesOfFreedom = this.longParam("nullDegreesOfFreedom", "null DOF.");
        this.residualDegreesOfFreedom = this.longParam("residualDegreesOfFreedom", "residual DOF.");
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.residualDeviance().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.nullDeviance().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.aic().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
    }

    public H2ORegressionGLMMetrics() {
        this(Identifiable$.MODULE$.randomUID("H2ORegressionGLMMetrics"));
    }
}

