/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.api.backend;

import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class ReaderBackendUtils {
    public static final int BUFFER_SIZE = 16384;

    private ReaderBackendUtils() {
    }

    public static BufferedReader asReader(InputStream is) throws IOException {
        return new BufferedReader(new InputStreamReader(is));
    }

    public static byte[] getBytes(InputStream is) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ReaderBackendUtils.copy(is, baos, 16384);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public static void export(ReaderBackend backend, String subdir, File dest) throws IOException {
        String prefix = subdir + "/";
        for (String name : backend.list()) {
            if (!name.startsWith(prefix)) continue;
            File file = new File(dest, name);
            file.getParentFile().mkdirs();
            FileOutputStream os = new FileOutputStream(file);
            Throwable throwable = null;
            try {
                InputStream is = backend.getInputStream(name);
                Throwable throwable2 = null;
                try {
                    ReaderBackendUtils.copy(is, os, 16384);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (is == null) continue;
                    if (throwable2 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (os == null) continue;
                if (throwable != null) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                ((OutputStream)os).close();
            }
        }
    }

    public static void copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        byte[] buffer = new byte[bufferSize];
        int n2 = 0;
        while (0 <= (n2 = input.read(buffer))) {
            output.write(buffer, 0, n2);
        }
    }
}

