/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.api;

import ai.h2o.mojos.runtime.MojoPipeline;
import ai.h2o.mojos.runtime.api.PipelineLoader;
import ai.h2o.mojos.runtime.api.PipelineLoaderFactory;
import ai.h2o.mojos.runtime.api.backend.DirReaderBackend;
import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import ai.h2o.mojos.runtime.api.backend.ZipFileReaderBackend;
import ai.h2o.mojos.runtime.lic.LicenseException;
import ai.h2o.mojos.runtime.utils.ClassLoaderUtils;
import ai.h2o.mojos.runtime.utils.Consts;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MojoPipelineService {
    private static final Logger log = LoggerFactory.getLogger(MojoPipelineService.class);
    private final LinkedHashMap<String, PipelineLoaderFactory> registry = new LinkedHashMap();
    public static MojoPipelineService INSTANCE = new MojoPipelineService(Consts.getSysProp("pipelineFormats", "pbuf,toml,klime,h2o3").split(","));

    private MojoPipelineService(String ... pipelineFormats) {
        LinkedHashMap<String, PipelineLoaderFactory> factories = new LinkedHashMap<String, PipelineLoaderFactory>();
        ServiceLoader<PipelineLoaderFactory> loader = ServiceLoader.load(PipelineLoaderFactory.class, ClassLoaderUtils.getPreferredSpiClassLoader(PipelineLoaderFactory.class));
        for (PipelineLoaderFactory factory : loader) {
            String name = factory.getName();
            PipelineLoaderFactory existing = factories.put(name, factory);
            if (existing == null) continue;
            throw new IllegalStateException(String.format("Pipeline loader '%s' is already registered with class '%s'", name, existing.getClass().getName()));
        }
        for (String pipelineFormat : pipelineFormats) {
            PipelineLoaderFactory provider = (PipelineLoaderFactory)factories.remove(pipelineFormat);
            if (provider != null) {
                this.registry.put(pipelineFormat, provider);
                continue;
            }
            log.warn("No pipeline format provider for '{}'%n", (Object)pipelineFormat);
        }
        this.registry.putAll(factories);
    }

    public PipelineLoaderFactory get(ReaderBackend backend) throws IOException {
        if (this.registry.isEmpty()) {
            throw new IllegalStateException("No pipeline factory is available");
        }
        for (Map.Entry<String, PipelineLoaderFactory> entry : this.registry.entrySet()) {
            PipelineLoaderFactory factory = entry.getValue();
            String rootResource = factory.getRootResource();
            if (!backend.exists(rootResource)) continue;
            return factory;
        }
        throw new IOException(String.format("None of %d available pipeline factories %s can read this mojo.", this.registry.size(), this.registry.keySet()));
    }

    private static ReaderBackend autodetectBackend(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            return DirReaderBackend.open(file);
        }
        if (file.isFile()) {
            return ZipFileReaderBackend.open(file);
        }
        throw new IOException("Unsupported file type: " + file.getAbsolutePath());
    }

    public static MojoPipeline loadPipeline(File file) throws IOException, LicenseException {
        ReaderBackend backend = MojoPipelineService.autodetectBackend(file);
        return MojoPipelineService.loadPipeline(backend);
    }

    public static MojoPipeline loadPipeline(ReaderBackend backend) throws IOException, LicenseException {
        PipelineLoaderFactory loaderFactory = INSTANCE.get(backend);
        PipelineLoader loader = loaderFactory.createLoader(backend, null);
        try {
            Method method = loader.getClass().getMethod("load", new Class[0]);
            int modifiers = method.getModifiers();
            if (!Modifier.isFinal(modifiers)) {
                throw new IllegalStateException(String.format("Internal error: Method %s#%s() is required to be declared final", loader.getClass().getName(), method.getName()));
            }
            return loader.load();
        }
        catch (NoSuchMethodException e2) {
            throw new IllegalStateException(e2);
        }
    }
}

