/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.AbstractProtobufList;
import java.util.ArrayList;
import java.util.List;

final class ProtobufArrayList<E>
extends AbstractProtobufList<E> {
    private static final ProtobufArrayList<Object> EMPTY_LIST = new ProtobufArrayList(new ArrayList(0));
    private final List<E> list;

    public static <E> ProtobufArrayList<E> emptyList() {
        return EMPTY_LIST;
    }

    ProtobufArrayList() {
        this(new ArrayList(10));
    }

    private ProtobufArrayList(List<E> list) {
        this.list = list;
    }

    @Override
    public final ProtobufArrayList<E> mutableCopyWithCapacity(int capacity) {
        if (capacity < this.size()) {
            throw new IllegalArgumentException();
        }
        ArrayList<E> arrayList = new ArrayList<E>(capacity);
        arrayList.addAll(this.list);
        return new ProtobufArrayList(arrayList);
    }

    @Override
    public final void add(int index, E element) {
        this.ensureIsMutable();
        this.list.add(index, element);
        ++this.modCount;
    }

    @Override
    public final E get(int index) {
        return this.list.get(index);
    }

    @Override
    public final E remove(int index) {
        this.ensureIsMutable();
        E e2 = this.list.remove(index);
        ++this.modCount;
        return e2;
    }

    @Override
    public final E set(int index, E element) {
        this.ensureIsMutable();
        E e2 = this.list.set(index, element);
        ++this.modCount;
        return e2;
    }

    @Override
    public final int size() {
        return this.list.size();
    }

    static {
        EMPTY_LIST.makeImmutable();
    }
}

