# flake8: noqa

ZIP_LOCALES = [
    {"abbrev": "AF", "name": "Afghanistan", "zip": "[0-9]{4}"},
    {"abbrev": "AL", "name": "Albania", "zip": "(120|122)[0-9]{2}"},
    {"abbrev": "DZ", "name": "Algeria", "zip": "[0-9]{5}"},
    {"abbrev": "AS", "name": "American Samoa", "zip": "[0-9]{5}"},
    {"abbrev": "AD", "name": "Andorra", "zip": "[0-9]{5}"},
    {"abbrev": "AO", "name": "Angola"},
    {"abbrev": "AI", "name": "Anguilla", "zip": "AI-2640"},
    {"abbrev": "AG", "name": "Antigua and Barbuda"},
    {"abbrev": "AR", "name": "Argentina", "zip": "[A-Z]{1}[0-9]{4}[A-Z]{3}"},
    {"abbrev": "AM", "name": "Armenia", "zip": "[0-9]{4}"},
    {"abbrev": "AW", "name": "Aruba"},
    {"abbrev": "AU", "name": "Australia", "zip": "[0-9]{4}"},
    {"abbrev": "AT", "name": "Austria", "zip": "[0-9]{4}"},
    {"abbrev": "AZ", "name": "Azerbaijan", "zip": "[0-9]{4}"},
    {"abbrev": "BS", "name": "Bahamas"},
    {"abbrev": "BH", "name": "Bahrain"},
    {"abbrev": "BD", "name": "Bangladesh", "zip": "[0-9]{4}"},
    {"abbrev": "BB", "name": "Barbados", "zip": "BB[0-9]{5}"},
    {"abbrev": "BY", "name": "Belarus", "zip": "[0-9]{6}"},
    {"abbrev": "BE", "name": "Belgium", "zip": "[0-9]{4}"},
    {"abbrev": "BZ", "name": "Belize"},
    {"abbrev": "BJ", "name": "Benin"},
    {"abbrev": "BM", "name": "Bermuda", "zip": "[A-Z]{2}[0-9]{2}"},
    {"abbrev": "BT", "name": "Bhutan", "zip": "[0-9]{5}"},
    {"abbrev": "BO", "name": "Bolivia"},
    {"abbrev": "BQ", "name": "Bonaire"},
    {"abbrev": "BA", "name": "Bosnia and Herzegovina", "zip": "[0-9]{5}"},
    {"abbrev": "BW", "name": "Botswana"},
    {"abbrev": "BR", "name": "Brazil", "zip": "[0-9]{5}-[0-9]{3}"},
    {"abbrev": "BN", "name": "Brunei", "zip": "[A-Z]{2}[0-9]{4}"},
    {"abbrev": "BG", "name": "Bulgaria", "zip": "[0-9]{4}"},
    {"abbrev": "BF", "name": "Burkina Faso"},
    {"abbrev": "BI", "name": "Burundi"},
    {"abbrev": "KH", "name": "Cambodia", "zip": "[0-9]{5}"},
    {"abbrev": "CM", "name": "Cameroon"},
    {"abbrev": "CA", "name": "Canada", "zip": "[A-Z][0-9][A-Z] ?[0-9][A-Z][0-9]"},
    {"abbrev": "CI", "name": "Canary Islands", "zip": "[0-9]{5}"},
    {"abbrev": "CV", "name": "Cape Verde", "zip": "[0-9]{4}"},
    {"abbrev": "KY", "name": "Cayman Islands", "zip": "[A-Z]{2}[0-9]-[0-9]{4}"},
    {"abbrev": "CF", "name": "Central African Republic"},
    {"abbrev": "TD", "name": "Chad"},
    {"abbrev": "CI", "name": "Channel Islands", "zip": "[A-Z]{2}[0-9]{2}"},
    {"abbrev": "CL", "name": "Chile", "zip": "[0-9]{7}"},
    {"abbrev": "CN", "name": "China, People's Republic", "zip": "[0-9]{6}"},
    {"abbrev": "CO", "name": "Colombia", "zip": "[0-9]{6}"},
    {"abbrev": "KM", "name": "Comoros"},
    {"abbrev": "CG", "name": "Congo"},
    {"abbrev": "CD", "name": "Congo, The Democratic Republic of"},
    {"abbrev": "CK", "name": "Cook Islands"},
    {"abbrev": "CR", "name": "Costa Rica", "zip": "[0-9]{5}"},
    {"abbrev": "CI", "name": "Côte d'Ivoire"},
    {"abbrev": "HR", "name": "Croatia", "zip": "[0-9]{5}"},
    {"abbrev": "CU", "name": "Cuba", "zip": "[0-9]{5}"},
    {"abbrev": "CW", "name": "Curacao"},
    {"abbrev": "CY", "name": "Cyprus", "zip": "[0-9]{4}"},
    {"abbrev": "CZ", "name": "Czech Republic", "zip": "[0-9]{3} [0-9]{2}"},
    {"abbrev": "DK", "name": "Denmark", "zip": "[0-9]{5}"},
    {"abbrev": "DJ", "name": "Djibouti"},
    {"abbrev": "DM", "name": "Dominica"},
    {"abbrev": "DO", "name": "Dominican Republic", "zip": "[0-9]{5}"},
    {"abbrev": "TL", "name": "East Timor"},
    {"abbrev": "EC", "name": "Ecuador", "zip": "[0-9]{6}"},
    {"abbrev": "EG", "name": "Egypt", "zip": "[0-9]{5}"},
    {"abbrev": "SV", "name": "El Salvador", "zip": "[0-9]{4}"},
    {"abbrev": "ER", "name": "Eritrea"},
    {"abbrev": "EE", "name": "Estonia", "zip": "[0-9]{5}"},
    {"abbrev": "ET", "name": "Ethiopia", "zip": "[0-9]{4}"},
    {"abbrev": "FK", "name": "Falkland Islands", "zip": "FIQQ 1ZZ"},
    {"abbrev": "FO", "name": "Faroe Islands", "zip": "[0-9]{3}"},
    {"abbrev": "FJ", "name": "Fiji"},
    {"abbrev": "FI", "name": "Finland", "zip": "[0-9]{5}"},
    {"abbrev": "FR", "name": "France", "zip": "[0-9]{5}"},
    {"abbrev": "PF", "name": "French Polynesia", "zip": "987[0-9]{2}", "range": ["98700", "98790"]},
    {"abbrev": "GA", "name": "Gabon"},
    {"abbrev": "GM", "name": "Gambia"},
    {"abbrev": "GE", "name": "Georgia"},
    {"abbrev": "DE", "name": "Germany", "zip": "[0-9]{5}"},
    {"abbrev": "GH", "name": "Ghana"},
    {"abbrev": "GI", "name": "Gibraltar", "zip": "GX11 1AA"},
    {"abbrev": "GR", "name": "Greece", "zip": "[0-9]{3} [0-9]{2}"},
    {"abbrev": "GL", "name": "Greenland", "zip": "[0-9]{4}"},
    {"abbrev": "GD", "name": "Grenada"},
    {"abbrev": "GP", "name": "Guadeloupe", "zip": "971[0-9]{2}", "range": ["97100", "97190"]},
    {"abbrev": "GU", "name": "Guam", "zip": "\\d{5}(?:[-\\s]\\d{4})?", "range": ["96910", "96932"]},
    {"abbrev": "GT", "name": "Guatemala", "zip": "[0-9]{5}"},
    {
        "abbrev": "GG",
        "name": "Guernsey",
        "zip": "([Gg][Ii][Rr] 0[Aa]{2})|((([A-Za-z][0-9]{1,2})|(([A-Za-z][A-Ha-hJ-Yj-y][0-9]{1,2})|(([A-Za-z][0-9][A-Za-z])|([A-Za-z][A-Ha-hJ-Yj-y][0-9][A-Za-z]?))))\\s?[0-9][A-Za-z]{2})",
    },
    {"abbrev": "GW", "name": "Guinea-Bissau", "zip": "[0-9]{4}"},
    {"abbrev": "GQ", "name": "Guinea-Equatorial"},
    {"abbrev": "GN", "name": "Guinea Republic", "zip": "[0-9]{3}"},
    {"abbrev": "GY", "name": "Guyana (British)"},
    {"abbrev": "GF", "name": "Guyana (French)", "zip": "973[0-9]{2}", "range": ["97300", "97390"]},
    {"abbrev": "HT", "name": "Haiti", "zip": "[0-9]{4}"},
    {"abbrev": "HN", "name": "Honduras", "zip": "[0-9]{5}"},
    {"abbrev": "HK", "name": "Hong Kong"},
    {"abbrev": "HU", "name": "Hungary", "zip": "[0-9]{4}"},
    {"abbrev": "IS", "name": "Iceland", "zip": "[0-9]{3}"},
    {"abbrev": "IN", "name": "India", "zip": "^(?!0{1})\d{6}$"},
    {"abbrev": "ID", "name": "Indonesia", "zip": "[0-9]{5}"},
    {"abbrev": "IR", "name": "Iran", "zip": "[0-9]{5}"},
    {"abbrev": "IQ", "name": "Iraq", "zip": "[0-9]{5}"},
    {"abbrev": "IE", "name": "Ireland, Republic of", "zip": "(?:^[AC-FHKNPRTV-Y][0-9]{2}|D6W)[ -]?[0-9AC-FHKNPRTV-Y]{4}$"},
    {"abbrev": "FK", "name": "Islas Malvinas", "zip": "FIQQ 1ZZ"},
    {"abbrev": "IL", "name": "Israel", "zip": "[0-9]{5}|[0-9]{7}"},
    {"abbrev": "IT", "name": "Italy", "zip": "[0-9]{5}"},
    {"abbrev": "CI", "name": "Ivory Coast"},
    {"abbrev": "JM", "name": "Jamaica"},
    {"abbrev": "JP", "name": "Japan", "zip": "[0-9]{3}-[0-9]{4}"},
    {
        "abbrev": "JE",
        "name": "Jersey",
        "zip": "([Gg][Ii][Rr] 0[Aa]{2})|((([A-Za-z][0-9]{1,2})|(([A-Za-z][A-Ha-hJ-Yj-y][0-9]{1,2})|(([A-Za-z][0-9][A-Za-z])|([A-Za-z][A-Ha-hJ-Yj-y][0-9][A-Za-z]?))))\\s?[0-9][A-Za-z]{2})",
    },
    {"abbrev": "JO", "name": "Jordan", "zip": "[0-9]{5}"},
    {"abbrev": "KZ", "name": "Kazakhstan", "zip": "[0-9]{6}"},
    {"abbrev": "KE", "name": "Kenya", "zip": "[0-9]{5}"},
    {"abbrev": "KI", "name": "Kiribati"},
    {"abbrev": "KR", "name": "Korea, Republic of", "zip": "[0-9]{5}"},
    {"abbrev": "KP", "name": "Korea, The D.P.R of"},
    {"abbrev": "XK", "name": "Kosovo", "zip": "[0-9]{5}"},
    {"abbrev": "KW", "name": "Kuwait", "zip": "[0-9]{5}"},
    {"abbrev": "KG", "name": "Kyrgyzstan", "zip": "[0-9]{6}"},
    {"abbrev": "LA", "name": "Laos", "zip": "[0-9]{5}"},
    {"abbrev": "LV", "name": "Latvia", "zip": "LV-[0-9]{4}"},
    {"abbrev": "LB", "name": "Lebanon", "zip": "[0-9]{4} [0-9]{4}"},
    {"abbrev": "LS", "name": "Lesotho", "zip": "[0-9]{3}"},
    {"abbrev": "LR", "name": "Liberia", "zip": "[0-9]{4}"},
    {"abbrev": "LY", "name": "Libya"},
    {"abbrev": "LI", "name": "Liechtenstein", "zip": "[0-9]{4}", "range": ["9485", "9498"]},
    {"abbrev": "LT", "name": "Lithuania", "zip": "LT-[0-9]{5}"},
    {"abbrev": "LU", "name": "Luxembourg", "zip": "[0-9]{4}"},
    {"abbrev": "MO", "name": "Macau"},
    {"abbrev": "MK", "name": "Macedonia, Republic of", "zip": "[0-9]{4}"},
    {"abbrev": "MG", "name": "Madagascar", "zip": "[0-9]{3}"},
    {"abbrev": "MW", "name": "Malawi"},
    {"abbrev": "MY", "name": "Malaysia", "zip": "[0-9]{5}"},
    {"abbrev": "MV", "name": "Maldives", "zip": "[0-9]{5}"},
    {"abbrev": "ML", "name": "Mali"},
    {"abbrev": "MT", "name": "Malta", "zip": "[A-Z]{3} [0-9]{4}"},
    {"abbrev": "MH", "name": "Marshall Islands", "zip": "\\d{5}(?:[-\\s]\\d{4})?", "range": ["96960", "96970"]},
    {"abbrev": "MQ", "name": "Martinique", "zip": "972[0-9]{2}", "range": ["97200", "97290"]},
    {"abbrev": "MR", "name": "Mauritania"},
    {"abbrev": "MU", "name": "Mauritius", "zip": "[0-9]{5}"},
    {"abbrev": "YT", "name": "Mayotte", "zip": "976[0-9]{2}", "range": ["97600", "97690"]},
    {"abbrev": "MX", "name": "Mexico", "zip": "[0-9]{5}"},
    {"abbrev": "MD", "name": "Moldova, Republic of", "zip": "MD-?[0-9]{4}"},
    {"abbrev": "MC", "name": "Monaco", "zip": "980[0-9]{2}"},
    {"abbrev": "MN", "name": "Mongolia", "zip": "[0-9]{5}"},
    {"abbrev": "ME", "name": "Montenegro", "zip": "[0-9]{5}"},
    {"abbrev": "MS", "name": "Montserrat", "zip": "MSR [0-9]{4}", "range": ["MSR 1110", "MSR 1350"]},
    {"abbrev": "MA", "name": "Morocco", "zip": "[0-9]{5}"},
    {"abbrev": "MZ", "name": "Mozambique", "zip": "[0-9]{4}"},
    {"abbrev": "MM", "name": "Myanmar", "zip": "[0-9]{5}"},
    {"abbrev": "NA", "name": "Namibia"},
    {"abbrev": "NR", "name": "Nauru"},
    {"abbrev": "NP", "name": "Nepal", "zip": "[0-9]{5}"},
    {"abbrev": "NL", "name": "Netherlands", "zip": "(?:NL-)?(\\d{4})\\s*([A-Z]{2})"},
    {"abbrev": "NC", "name": "New Caledonia", "zip": "988[0-9]{2}", "range": ["96950", "96952"]},
    {"abbrev": "NZ", "name": "New Zealand", "zip": "[0-9]{4}"},
    {"abbrev": "NI", "name": "Nicaragua"},
    {"abbrev": "NE", "name": "Niger", "zip": "[0-9]{4}"},
    {"abbrev": "NG", "name": "Nigeria", "zip": "[0-9]{6}"},
    {"abbrev": "NU", "name": "Niue"},
    {"abbrev": "MP", "name": "Northern Mariana Islands", "zip": "^\\d{5}(?:[-\\s]\\d{4})?$"},
    {"abbrev": "NO", "name": "Norway", "zip": "[0-9]{4}"},
    {"abbrev": "OM", "name": "Oman", "zip": "[0-9]{3}"},
    {"abbrev": "PK", "name": "Pakistan", "zip": "[0-9]{5}"},
    {"abbrev": "PW", "name": "Palau", "zip": "\\d{5}(?:[-\\s]\\d{4})?"},
    {"abbrev": "PA", "name": "Panama", "zip": "[0-9]{4}"},
    {"abbrev": "PG", "name": "Papua New Guinea", "zip": "[0-9]{3}"},
    {"abbrev": "PY", "name": "Paraguay", "zip": "[0-9]{4}"},
    {"abbrev": "PE", "name": "Peru", "zip": "[0-9]{5}"},
    {"abbrev": "PH", "name": "Philippines", "zip": "[0-9]{4}"},
    {"abbrev": "PL", "name": "Poland", "zip": "[0-9]{2}-[0-9]{3}"},
    {"abbrev": "PT", "name": "Portugal", "zip": "[0-9]{4}-[0-9]{3}"},
    {"abbrev": "PR", "name": "Puerto Rico", "zip": "\\d{5}(?:[-\\s]\\d{4})?"},
    {"abbrev": "QA", "name": "Qatar"},
    {"abbrev": "RE", "name": "Réunion", "zip": "974[0-9]{2}", "range": ["97400", "97490"]},
    {"abbrev": "RO", "name": "Romania", "zip": "[0-9]{6}"},
    {"abbrev": "RU", "name": "Russian Federation", "zip": "[0-9]{6}"},
    {"abbrev": "RW", "name": "Rwanda"},
    {"abbrev": "MP", "name": "Saipan", "zip": "96950"},
    {"abbrev": "WS", "name": "Samoa", "zip": "WS[0-9]{4}"},
    {"abbrev": "ST", "name": "Sao Tome and Principe"},
    {"abbrev": "SA", "name": "Saudi Arabia", "zip": "[0-9]{5}(-[0-9]{4})?"},
    {"abbrev": "SN", "name": "Senegal", "zip": "[0-9]{5}"},
    {"abbrev": "RS", "name": "Serbia", "zip": "[0-9]{5}"},
    {"abbrev": "SC", "name": "Seychelles"},
    {"abbrev": "SL", "name": "Sierra Leone"},
    {"abbrev": "SG", "name": "Singapore", "zip": "[0-9]{6}"},
    {"abbrev": "SK", "name": "Slovakia", "zip": "[0-9]{3} [0-9]{2}"},
    {"abbrev": "SI", "name": "Slovenia", "zip": "[0-9]{4}"},
    {"abbrev": "SB", "name": "Solomon Islands"},
    {"abbrev": "SO", "name": "Somalia", "zip": "[A-Z]{2} [0-9]{5}"},
    {"abbrev": "ZA", "name": "South Africa", "zip": "[0-9]{4}"},
    {"abbrev": "SS", "name": "South Sudan"},
    {"abbrev": "ES", "name": "Spain", "zip": "[0-9]{5}"},
    {"abbrev": "LK", "name": "Sri Lanka", "zip": "[0-9]{4}"},
    {"abbrev": "BL", "name": "St. Barthélemy", "zip": "[0-9]{5}", "range": ["97100", "97190"]},
    {"abbrev": "VI", "name": "St. Croix", "zip": "[0-9]{5}"},
    {"abbrev": "SE", "name": "St. Eustatius"},
    {"abbrev": "SH", "name": "St. Helena", "zip": "STHL 1ZZ"},
    {"abbrev": "AG", "name": "St. John", "zip": "\\d{5}(?:[-\\s]\\d{4})?"},
    {"abbrev": "KN", "name": "St. Kitts and Nevis", "zip": "[A-Z]{2}[0-9]{4}"},
    {"abbrev": "LC", "name": "St. Lucia", "zip": "[A-Z]{2}[0-9]{2} [0-9]{3}"},
    {"abbrev": "SX", "name": "St. Maarten"},
    {"abbrev": "VI", "name": "St. Thomas"},
    {"abbrev": "VC", "name": "St. Vincent and the Grenadines", "zip": "VC[0-9]{4}"},
    {"abbrev": "SD", "name": "Sudan", "zip": "[0-9]{5}"},
    {"abbrev": "SR", "name": "Suriname"},
    {"abbrev": "SZ", "name": "Swaziland", "zip": "[A-Z]{1}[0-9]{3}"},
    {"abbrev": "SE", "name": "Sweden", "zip": "[0-9]{3} [0-9]{2}"},
    {"abbrev": "CH", "name": "Switzerland", "zip": "[0-9]{4}"},
    {"abbrev": "SY", "name": "Syria"},
    {"abbrev": "PF", "name": "Tahiti", "zip": "[0-9]{5}"},
    {"abbrev": "TW", "name": "Taiwan", "zip": "[0-9]{3}(-[0-9]{2})?"},
    {"abbrev": "TZ", "name": "Tanzania", "zip": "[0-9]{5}"},
    {"abbrev": "TH", "name": "Thailand", "zip": "[0-9]{5}"},
    {"abbrev": "TG", "name": "Togo"},
    {"abbrev": "TO", "name": "Tonga"},
    {"abbrev": "VG", "name": "Tortola", "zip": "VG[0-9]{4}"},
    {"abbrev": "TT", "name": "Trinidad and Tobago", "zip": "[0-9]{6}"},
    {"abbrev": "TN", "name": "Tunisia", "zip": "[0-9]{4}"},
    {"abbrev": "TR", "name": "Turkey", "zip": "[0-9]{5}"},
    {"abbrev": "TM", "name": "Turkmenistan", "zip": "[0-9]{6}"},
    {"abbrev": "TC", "name": "Turks and Caicos Islands", "zip": "TKCA 1ZZ"},
    {"abbrev": "TV", "name": "Tuvalu"},
    {"abbrev": "UG", "name": "Uganda"},
    {"abbrev": "UA", "name": "Ukraine", "zip": "[0-9]{5}"},
    {"abbrev": "AE", "name": "United Arab Emirates"},
    {
        "abbrev": "GB",
        "name": "United Kingdom",
        "zip": "([Gg][Ii][Rr] 0[Aa]{2})|((([A-Za-z][0-9]{1,2})|(([A-Za-z][A-Ha-hJ-Yj-y][0-9]{1,2})|(([A-Za-z][0-9][A-Za-z])|([A-Za-z][A-Ha-hJ-Yj-y][0-9][A-Za-z]?))))\\s?[0-9][A-Za-z]{2})",
    },
    {"abbrev": "US", "name": "United States of America", "zip": "^[0-9]{5}(?:-[0-9]{4})?$"},
    {"abbrev": "UY", "name": "Uruguay", "zip": "[0-9]{5}"},
    {"abbrev": "UZ", "name": "Uzbekistan", "zip": "[0-9]{6}"},
    {"abbrev": "VU", "name": "Vanuatu"},
    {"abbrev": "VE", "name": "Venezuela", "zip": "[0-9]{4}(-[A-Z]{1})?"},
    {"abbrev": "VN", "name": "Vietnam", "zip": "[0-9]{6}"},
    {"abbrev": "VG", "name": "Virgin Islands (British)", "zip": "VG[0-9]{4}"},
    {"abbrev": "VI", "name": "Virgin Islands (US)", "range": ["00801", "00851"], "zip": "\\d{5}(?:[-\\s]\\d{4})?"},
    {"abbrev": "YE", "name": "Yemen"},
    {"abbrev": "ZM", "name": "Zambia", "zip": "[0-9]{5}"},
    {"abbrev": "ZW", "name": "Zimbabwe"},
]
