from .core import as_type
from .core import deferred_type

t = {
    'root': as_type('root')(),
    'noop': as_type('noop')(),
    'start_of_input': as_type('start_of_input')(),
    'end_of_input': as_type('end_of_input')(),
    'any_char': as_type('any_char')(),
    'whitespace_char': as_type('whitespace_char')(),
    'non_whitespace_char': as_type('non_whitespace_char')(),
    'digit': as_type('digit')(),
    'non_digit': as_type('non_digit')(),
    'word': as_type('word')(),
    'non_word': as_type('non_word')(),
    'word_boundary': as_type('word_boundary')(),
    'non_word_boundary': as_type('non_word_boundary')(),
    'new_line': as_type('new_line')(),
    'carriage_return': as_type('carriage_return')(),
    'tab': as_type('tab')(),
    'null_byte': as_type('null_byte')(),
    'any_of_chars': as_type('any_of_chars'),
    'anything_but_string': as_type('anything_but_string'),
    'anything_but_chars': as_type('anything_but_chars'),
    'anything_but_range': as_type('anything_but_range'),
    'char': as_type('char'),
    'range': as_type('range'),
    'string': as_type('string', {'quantifiers_require_group': True}),
    'named_back_reference': lambda name: deferred_type('named_back_reference', {'name': name}),
    'back_reference': lambda index: deferred_type('back_reference', {'index': index}),
    'capture': deferred_type('capture', {'contains_children': True}),
    'subexpression': as_type('subexpression', {'contains_children': True, 'quantifiers_require_group': True}),
    'named_capture': lambda name: deferred_type('named_capture', {'name': name, 'contains_children': True}),
    'group': deferred_type('group', {'contains_children': True}),
    'any_of': deferred_type('any_of', {'contains_children': True}),
    'assert_ahead': deferred_type('assert_ahead', {'contains_children': True}),
    'assert_not_ahead': deferred_type('assert_not_ahead', {'contains_children': True}),
    'assert_behind': deferred_type('assert_behind', {'contains_children': True}),
    'assert_not_behind': deferred_type('assert_not_behind', {'contains_children': True}),
    'exactly': lambda times: deferred_type('exactly', {'times': times, 'contains_child': True}),
    'at_least': lambda times: deferred_type('at_least', {'times': times, 'contains_child': True}),
    'between': lambda x, y: deferred_type('between', {'times': [x, y], 'contains_child': True}),
    'between_lazy': lambda x, y: deferred_type('between_lazy', {'times': [x, y], 'contains_child': True}),
    'zero_or_more': deferred_type('zero_or_more', {'contains_child': True}),
    'zero_or_more_lazy': deferred_type('zero_or_more_lazy', {'contains_child': True}),
    'one_or_more': deferred_type('one_or_more', {'contains_child': True}),
    'one_or_more_lazy': deferred_type('one_or_more_lazy', {'contains_child': True}),
    'optional': deferred_type('optional', {'contains_child': True}),
}
