COUNTRY_CODES = {
    "Argentina": {"address": "es-ar"},
    "Australia": {"address": "en-au"},
    "Austria (Österreich)": {"address": "de-at"},
    "Bahrain (English)": {"address": "en-bh"},
    "Belgium (Français)": {"address": "fr-be"},
    "Belgium (Nederlands)": {"address": "nl-be"},
    "Bolivia": {"address": "es-bo"},
    "Brasil": {"address": "pt-br"},
    "Bulgaria (English)": {"address": "en-bg"},
    "Canada": {"address": "en-ca"},
    "Canada (French)": {"address": "fr-ca"},
    "Chile": {"address": "es-cl"},
    "Colombia": {"address": "es-co"},
    "Costa Rica": {"address": "es-cr"},
    "Croatia (English)": {"address": "en-hr"},
    "Cyprus": {"address": "en-cy"},
    "Czech Republic (English)": {"address": "en-cz"},
    "Denmark (Danmark)": {"address": "da-dk"},
    "Ecuador": {"address": "es-ec"},
    "El Salvador": {"address": "es-sv"},
    "Finland (English)": {"address": "en-fi"},
    "France": {"address": "fr-fr"},
    "Germany (Deutschland)": {"address": "de-de"},
    "Greece (English)": {"address": "en-gr"},
    "Guatemala": {"address": "es-gt"},
    "Honduras": {"address": "es-hn"},
    "Hong Kong (English)": {"address": "en-hk"},
    "Iceland (English)": {"address": "en-is"},
    "India": {"address": "en-in"},
    "Indonesia (English)": {"address": "en-id"},
    "Ireland": {"address": "en-ie"},
    "Israel (English)": {"address": "en-il"},
    "Italy": {"address": "it-it"},
    "Japan (日本)": {"address": "ja-jp"},
    "Korea (한국어)": {"address": "ko-kr"},
    "Kuwait (English)": {"address": "en-kw"},
    "Lebanon (English)": {"address": "en-lb"},
    "Luxembourg (Deutsch)": {"address": "de-lu"},
    "Malaysia (English)": {"address": "en-my"},
    "Malta": {"address": "en-mt"},
    "Mexico (México)": {"address": "es-mx"},
    "Nederland": {"address": "nl-nl"},
    "New Zealand": {"address": "en-nz"},
    "Nicaragua": {"address": "es-ni"},
    "Norway (English)": {"address": "en-no"},
    "Oman (English)": {"address": "en-om"},
    "Panama (Panamá)": {"address": "es-pa"},
    "Paraguay": {"address": "es-py"},
    "Peru (Perú)": {"address": "es-pe"},
    "Philippines (English)": {"address": "en-ph"},
    "Poland (English)": {"address": "en-pl"},
    "Portugal": {"address": "pt-pt"},
    "Qatar (English)": {"address": "en-qa"},
    "Romania (English)": {"address": "en-ro"},
    "Saudi Arabia (English)": {"address": "en-sa"},
    "Serbia (Srbija)": {"address": "sr-rs"},
    "Singapore (English)": {"address": "en-sg"},
    "Slovenia (English)": {"address": "en-si"},
    "Slovakia (English)": {"address": "en-sk"},
    "South Africa": {"address": "en-za"},
    "Spain (España)": {"address": "es-es"},
    "Sweden (English)": {"address": "en-se"},
    "Switzerland (Deutsch)": {"address": "de-ch"},
    "Taiwan (English)": {"address": "en-tw"},
    "Thailand (English)": {"address": "en-th"},
    "Ukraine (Українська мова)": {"address": "uk-ua"},
    "United Arab Emirates/ Middle East (English)": {"address": "en-ae"},
    "United States": {"address": "en-us"},
    "United Kingdom: {Great Britain": {"address": "en-gb"},
    "Uruguay": {"address": "es-uy"},
    "Vietnam (English)": {"address": "en-vn"},
}


# Check the country code and return us if not found
def store(country):
    for key in COUNTRY_CODES:
        if country.strip().lower() in key.lower():
            return COUNTRY_CODES[key]["address"]
        else:
            continue

    return "en-us"
