# Generated by Django 3.2.12 on 2022-04-02 03:04

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import filer.fields.image
import mptt.fields


class Migration(migrations.Migration):

    dependencies = [
        ('simpel_themes', '0004_alter_screenshoot_template'),
        ('sites', '0002_alter_domain_unique'),
        migrations.swappable_dependency(settings.FILER_IMAGE_MODEL),
        ('simpel_pages', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='RootPage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
            options={
                'verbose_name': 'Root',
                'verbose_name_plural': 'Roots',
                'swappable': 'SIMPEL_PAGE_SITE_MODEL',
            },
        ),
        migrations.RemoveField(
            model_name='post',
            name='page_ptr',
        ),
        migrations.RemoveField(
            model_name='post',
            name='thumbnail',
        ),
        migrations.AlterModelOptions(
            name='page',
            options={'ordering': ['-created_at']},
        ),
        migrations.RemoveField(
            model_name='page',
            name='sites',
        ),
        migrations.RemoveField(
            model_name='page',
            name='url',
        ),
        migrations.AddField(
            model_name='category',
            name='description',
            field=models.TextField(blank=True, null=True, verbose_name='Description'),
        ),
        migrations.AddField(
            model_name='category',
            name='thumbnail',
            field=filer.fields.image.FilerImageField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='pagecategories', to=settings.FILER_IMAGE_MODEL),
        ),
        migrations.AddField(
            model_name='page',
            name='live',
            field=models.BooleanField(default=True, verbose_name='live'),
        ),
        migrations.AddField(
            model_name='page',
            name='text',
            field=models.TextField(blank=True, null=True, verbose_name='Content'),
        ),
        migrations.AddField(
            model_name='page',
            name='url_path',
            field=models.CharField(blank=True, max_length=255, null=True, unique=True),
        ),
        migrations.AlterField(
            model_name='page',
            name='parent',
            field=mptt.fields.TreeForeignKey(blank=True, help_text='Pages, unlike tags, can have a hierarchy. You might have a Index page, and under that have children pages for post and story. Totally optional.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='page_children', to='simpel_pages.page'),
        ),
        migrations.AlterField(
            model_name='page',
            name='slug',
            field=models.SlugField(blank=True, max_length=255, null=True, unique=True),
        ),
        migrations.AlterField(
            model_name='page',
            name='template',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='page_templates', to='simpel_themes.modeltemplate', verbose_name='Template'),
        ),
        migrations.AlterField(
            model_name='taggedpage',
            name='content_object',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tagged_posts', to='simpel_pages.page'),
        ),
        migrations.AlterField(
            model_name='taggedpage',
            name='tag',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tagged_posts', to='simpel_pages.tag'),
        ),
        migrations.DeleteModel(
            name='PageGallery',
        ),
        migrations.DeleteModel(
            name='Post',
        ),
        migrations.AddField(
            model_name='rootpage',
            name='page',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='site', to='simpel_pages.page', verbose_name='Page'),
        ),
        migrations.AddField(
            model_name='rootpage',
            name='site',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='rootpage', to='sites.site', verbose_name='Site'),
        ),
    ]
