"""
``rising.loading`` provides an alternative :class:`DataLoader` that extends
:class:`torch.utils.data.DataLoader` by the following:

* Seeding of Numpy in each worker process: The seed is generated by numpy in
  the main process before starting the workers. For reproducibility numpy must
  be seeded in the main process.

* Per-Sample Transforms outside the dataset (optional with pseudo
  batch dimension if the transforms require it).
  Will be executed within the spawned worker processes before batching.

* Batched Transforms for better performance.
  Will be executed within the worker processes after batching.

* Batched GPU-Transforms. Will be executed after syncing results back to
  main process (i.e. as last transforms) to avoid multiple CUDA initializations.

Furthermore it also provides a :class:`Dataset` (based on
:class:`torch.utils.data.Dataset`)that can create subsets from itself by
given indices and an :class:`AsyncDataset` as well as different options for
collation.

"""

from rising.loading.collate import numpy_collate
from rising.loading.dataset import Dataset, AsyncDataset
from rising.loading.loader import DataLoader, default_transform_call
