# FolderGenie
### Are you fed up with the time-consuming task of creating multiple folders for your project? Say goodbye to that tedious task and welcome FolderGenie - the ultimate solution to your folder creation needs!
FolderGenie is a Python script that reads a text file containing a list of folder names and creates the corresponding directory structure on the user's computer. The text file should contain one folder name per line. The user can specify the name of the input text file as a command line argument when running the script.

# Usage
To use FolderGenie, run the script `foldergenie.py` with the name of the input text file as a command line argument:

```python
python foldergenie.py input.txt
```

# Example Input
```
parent1
child1
child2
  grandchild1
    greatgrandchild1
  grandchild2
  grandchild3
child3
parent2
  child4
    grandchild4
```

# Example Output
```
parent1/
├── child1/
├── child2/
│   ├── grandchild1/
│   │   └── greatgrandchild1
│   ├── grandchild2/
│   └── grandchild3/
└── child3/
parent2/
└── child4/
    └── grandchild4/
```

# Script Description
The `foldergenie` script defines a `FolderGenie` class, which contains the following methods:

* `__init__`: initializes the class with the input filename and an empty tree dictionary
* `__create_folder_tree`: reads the input file and creates a dictionary that represents the folder structure hierarchy
* `create_directories`: creates the directory structure on the user's computer, based on the tree dictionary generated by __create_folder_tree

The `create_directories` method uses the `pathlib` and `os` modules to create directories and files on the user's computer. It recursively traverses the tree dictionary and creates directories using the `mkdir` method of the `pathlib.Path` class and files using the `touch` method of the same class.

# Customization
The `FolderGenie` class can be easily customized to change the directory structure or the format of the input file. The `__create_folder_tree` method can be modified to handle different input formats or to generate different tree dictionary structures.

# Conclusion
FolderGenie is a simple and useful tool for creating directory structures from text files. It can be customized to handle different input formats and directory structures, making it a flexible and versatile tool for managing directory hierarchies.