"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsClusterAutoScalerPolicyHelper = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const AwsClusterAutoScalerPolicy = [
    {
        Effect: 'Allow',
        Action: [
            'autoscaling:DescribeAutoScalingGroups',
            'autoscaling:DescribeAutoScalingInstances',
            'autoscaling:DescribeLaunchConfigurations',
            'autoscaling:SetDesiredCapacity',
            'autoscaling:TerminateInstanceInAutoScalingGroup',
            'autoscaling:DescribeTags',
            'ec2:DescribeLaunchTemplateVersions',
            'autoscaling:DescribeLaunchConfigurations',
        ],
        Resource: ['*'],
    },
];
/**
 * (experimental) Aws External Dns Policy class ,help you add policy to your Iam Role for service account.
 *
 * @experimental
 */
class AwsClusterAutoScalerPolicyHelper {
    /**
     * @experimental
     */
    static addPolicy(role) {
        AwsClusterAutoScalerPolicy.forEach(e => {
            role.addToPolicy(iam.PolicyStatement.fromJson(e));
        });
        return role;
    }
}
exports.AwsClusterAutoScalerPolicyHelper = AwsClusterAutoScalerPolicyHelper;
_a = JSII_RTTI_SYMBOL_1;
AwsClusterAutoScalerPolicyHelper[_a] = { fqn: "@opencdk8s/cdk8s-cluster-autoscaler-aws.AwsClusterAutoScalerPolicyHelper", version: "0.1.1" };
;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicG9saWN5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL3BvbGljeS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDJDQUEyQztBQUUzQyxNQUFNLDBCQUEwQixHQUFHO0lBQ2pDO1FBQ0UsTUFBTSxFQUFFLE9BQU87UUFDZixNQUFNLEVBQUU7WUFDTix1Q0FBdUM7WUFDdkMsMENBQTBDO1lBQzFDLDBDQUEwQztZQUMxQyxnQ0FBZ0M7WUFDaEMsaURBQWlEO1lBQ2pELDBCQUEwQjtZQUMxQixvQ0FBb0M7WUFDcEMsMENBQTBDO1NBQzNDO1FBQ0QsUUFBUSxFQUFFLENBQUMsR0FBRyxDQUFDO0tBQ2hCO0NBQ0YsQ0FBQzs7Ozs7O0FBR0YsTUFBYSxnQ0FBZ0M7Ozs7SUFDcEMsTUFBTSxDQUFDLFNBQVMsQ0FBQyxJQUFTO1FBQy9CLDBCQUEwQixDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsRUFBRTtZQUNyQyxJQUFJLENBQUMsV0FBVyxDQUFDLEdBQUcsQ0FBQyxlQUFlLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDcEQsQ0FBQyxDQUFDLENBQUM7UUFDSCxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7O0FBTkgsNEVBT0M7OztBQUFBLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBpYW0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWlhbSc7XG5cbmNvbnN0IEF3c0NsdXN0ZXJBdXRvU2NhbGVyUG9saWN5ID0gW1xuICB7XG4gICAgRWZmZWN0OiAnQWxsb3cnLFxuICAgIEFjdGlvbjogW1xuICAgICAgJ2F1dG9zY2FsaW5nOkRlc2NyaWJlQXV0b1NjYWxpbmdHcm91cHMnLFxuICAgICAgJ2F1dG9zY2FsaW5nOkRlc2NyaWJlQXV0b1NjYWxpbmdJbnN0YW5jZXMnLFxuICAgICAgJ2F1dG9zY2FsaW5nOkRlc2NyaWJlTGF1bmNoQ29uZmlndXJhdGlvbnMnLFxuICAgICAgJ2F1dG9zY2FsaW5nOlNldERlc2lyZWRDYXBhY2l0eScsXG4gICAgICAnYXV0b3NjYWxpbmc6VGVybWluYXRlSW5zdGFuY2VJbkF1dG9TY2FsaW5nR3JvdXAnLFxuICAgICAgJ2F1dG9zY2FsaW5nOkRlc2NyaWJlVGFncycsXG4gICAgICAnZWMyOkRlc2NyaWJlTGF1bmNoVGVtcGxhdGVWZXJzaW9ucycsXG4gICAgICAnYXV0b3NjYWxpbmc6RGVzY3JpYmVMYXVuY2hDb25maWd1cmF0aW9ucycsXG4gICAgXSxcbiAgICBSZXNvdXJjZTogWycqJ10sXG4gIH0sXG5dO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBBd3NDbHVzdGVyQXV0b1NjYWxlclBvbGljeUhlbHBlciB7XG4gIHB1YmxpYyBzdGF0aWMgYWRkUG9saWN5KHJvbGU6IGFueSkgOmFueSB7XG4gICAgQXdzQ2x1c3RlckF1dG9TY2FsZXJQb2xpY3kuZm9yRWFjaChlID0+IHtcbiAgICAgIHJvbGUuYWRkVG9Qb2xpY3koaWFtLlBvbGljeVN0YXRlbWVudC5mcm9tSnNvbihlKSk7XG4gICAgfSk7XG4gICAgcmV0dXJuIHJvbGU7XG4gIH1cbn07Il19