/*
Copyright (C) 2017 Ming-Shing Chen

This file is part of BitPolyMul.

BitPolyMul is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

BitPolyMul is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with BitPolyMul.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "libOTe/config.h"
#ifdef ENABLE_SILENTOT

#include "stdint.h"
#include "bpmDefines.h"
namespace bpm{
alignas(32) const uint64_t gf2128toCantor[2*128] = {
 0x1, 0x0,
 0xF62DA500563A6180, 0x4E8FB76FADDE40EA,
 0x8D3B77807D275140, 0x69C86CD87B31609F,
 0x49EA0BE5A4B1D580, 0x45EA054D27F72703,
 0x4BA6CC4043B4F9E0, 0x5D2C5AB446A9D0D0,
 0xF4C6A222652D980, 0x6DFCF2E44CA64DDD,
 0xED1F0E1776E93F40, 0x671F07EBB40CB482,
 0x938422464F555D80, 0x53C60B27554DCB46,
 0x6E75AA60626E8510, 0x73BA77EE65FD38B8,
 0x5176A0B45A20DD80, 0x79AB26E5F2005EB2,
 0x88EA5F33357BB540, 0x5B028B966AF56B33,
 0xEBAA5B08988BAB80, 0xFBB35DBFEACA77C,
 0x9B90891CCD9DA0E0, 0x5490841E6E0AEEC3,
 0x71E8F62AD6538480, 0x10FF7AE9FD162518,
 0xDA46336568FFF340, 0x7A250EB4FFEB2EE5,
 0x73070BB8FBFBAE80, 0x51F6B50B77FB18D,
 0x594F7F505359C798, 0x4A674C195703A4E4,
 0xAC5CBADDD0A35780, 0x7993D46D3C8420E0,
 0x79CDF0EE7730B340, 0x457EB5970B0071EB,
 0x2F29A7F7044EF00, 0x1CA1EA3434B30DF4,
 0x4C9F70AAAFC66FE0, 0x7683CE5D5F8FDEAA,
 0xF7FF15EC6E75A480, 0x68383CB9786AF78A,
 0x9E7F768CD4CE7E40, 0x866AF3601FAF4C2,
 0xF8BFFFDCEB48F300, 0x8BBB968CDA7AEB6,
 0x5658CD92AB537090, 0x7ED8C611590F99A2,
 0x97F31AC8BFCF79C0, 0x41A564EF69F0061B,
 0x491C8D3FBD7A46C0, 0x1880C79D039D3794,
 0x5320998DC8436EE0, 0x2AD36EC06C212493,
 0x37652AD7DC800AE0, 0x473789EE801EB997,
 0xCDE57AFDED182E80, 0x599CBAF635479BBF,
 0xCA848E64860679C0, 0x790DEF8ECC0694B,
 0xBDE78F553997130, 0x31B03D86963281E0,
 0x75E8C0F87AF52454, 0x6F54EA15FC827696,
 0x57B33C64A3509080, 0x4AC5E2D5008CA73C,
 0xFA72E7B338F2FC40, 0x455A3E5BA2C63090,
 0xC25A47DAA93BCA80, 0x28DC1D391FAF20F7,
 0xC52B08994CA8EAE0, 0x67C1EF5C8E80491E,
 0x38335D064E98E300, 0x300D6942F7CD9EC1,
 0x38BD740C8669880, 0x12F11F2E2EEA8B0E,
 0x684DE1EFE77B4680, 0x3E7995B45292DCBA,
 0x6AD0C8FFF8255810, 0x4DC22973F04831FF,
 0x588C3C0E52306980, 0x229EF6C52FB0F783,
 0x8C009F1A594F76C0, 0x5C2422E5C45F8C4F,
 0x703CB1D20CEAE280, 0x6F04D24433FB96B2,
 0xD140CDCABEA94160, 0xC55F8AD01078EA3,
 0x3CD36E9A93B35C40, 0x6192262CAD674B9A,
 0x84E000329EEC8A80, 0xCE665DCAB7479ED,
 0xD15CD3373C46EC20, 0x7855D70FAEEF256F,
 0x7D74AB5BFEFAC8D8, 0x41B4A519F5885573,
 0xEED73249B9735400, 0x3F530821D3B2A371,
 0x5C0A97ACE028C520, 0x6177D698DD080516,
 0x85403EC43C26CD80, 0x15E45D883811CFCA,
 0x6D92CBA063C765A0, 0x14C0A4538253AC5E,
 0xBE016081553C8480, 0x705D0E8E57E8B405,
 0xFAB0D54B2C62D990, 0x3FBAD9A05A31B6DA,
 0xEAB9F006B6A248C0, 0x10D0FD26BA749E1F,
 0xACD7BFBC32C00F90, 0x64AC4D19C011E55C,
 0x22E05BA415139BC0, 0x1BEC30C48396C0BC,
 0x2B17C7831B9439C0, 0x7552E78D2FE45660,
 0x9AC4CB562DC6B3E0, 0x22D1DCDA09B437FD,
 0x2FC6C956C5054520, 0x458B1849AA05DEE,
 0x4507CA313AF999C0, 0x2E67CE80AC133372,
 0xE31448FFA55C9A8, 0x29682345DD2BC110,
 0x40F823A5051005B0, 0x5CD66FBEDCA1416,
 0x4F1CA084478FB67E, 0x58FE9F1F02C34DDD,
 0x9401E0E17FFCC0C0, 0xF39E6874FB57154,
 0x7C6AA256F2F8D8C0, 0x6FA713BF80CAF4A2,
 0x41FBA012F6FE4260, 0x6517FE8DAECC43B8,
 0x874B946AA48B8260, 0x67F7217673A528D8,
 0x67082553208B4EC0, 0x512CB42B7B65FC48,
 0x23776437FDA62FC0, 0x3CB213A59078B08C,
 0x55E63BECBCFD490, 0x69B9E67845568804,
 0xA7BE8CD5EAFC9F90, 0x542118F2C9C06D91,
 0x3F9DFF5DE5A98C40, 0x4B5159E1F17738CB,
 0xA42AF38569D49280, 0x280BDDE38C2B51A1,
 0x56562BD5AE896260, 0x3AEE4CD13FE66FB1,
 0x24E3CE0AC55D4C0, 0x1B8990B9399FCE89,
 0x534C03FE0CB12380, 0x2AC17C44B5CBF6C8,
 0x5C6B111814C6E5C0, 0x21455F6E7BDBB2E7,
 0xF701B24ABEA37538, 0x4E51BFCE5ED600A8,
 0xDFB8AC800437F418, 0x6B233DCA086C2900,
 0xC6F518AB0A6126C0, 0x3091D352179134AC,
 0xF4CA22097B285D40, 0x33D18DA7B8688C42,
 0x29791F73870D6C60, 0x90F979C19A369E,
 0x4A00D09775E8CDA0, 0x7236339726704A68,
 0x82CD618D9C5501C0, 0x3BFFC9C61E25CA,
 0x4822E93B0A9F93C0, 0x5886BB662A065DEB,
 0x1B71EF6A0E483350, 0x7993EE78C552D6A7,
 0x39E0AB2FE1FDE1D0, 0xA7F04FB818449F2,
 0xE42FD1B7336CA480, 0x52D5EAFAB8973BD4,
 0x22BAD9D7DA6AF260, 0x515B353AFBD4EE57,
 0x516E6080E351FA00, 0x46C13A15087AAB4D,
 0x4690002BD19ACFC0, 0xA955732FECE451B,
 0xC1839BCF7320A80, 0x68BC48675D86763A,
 0x39F2BAACA2659A30, 0x447F3C887998B7D8,
 0xBB694356EF81D8C4, 0x39A5B4F38E7A471D,
 0xC3CEFEF60187ACB4, 0x616EF7950F4C7FCA,
 0x67A4E5D8638E700, 0x3BE4E6C6C898C5F1,
 0x19BCAB6D65CAFE00, 0x20FA8C313A6BF2C9,
 0x636D0F3C9FC78580, 0x32B2E1B2CE393D61,
 0x720FDC7A903CA7B0, 0x51CC3DD4B38C079D,
 0x248557EDBE4E0340, 0x2EA9636EE97D7826,
 0xC7E021A62235AB40, 0x1F16734C2419282F,
 0x5BEA4B95DC05B9C0, 0x7F7C33D4DAAD4F9,
 0x5B5BAE705224D770, 0x1EA0F67A437A7A71,
 0x5D17D7932CC19000, 0x1D3CC922BA197240,
 0x6101D0C1FFA2C6C0, 0x487389C97C1CEE07,
 0xBB32E77C1C107280, 0x7D641103DD9B2707,
 0x87E8BFEEBA53B558, 0x2067B57077296DB7,
 0x222B5A3E4B11C0C0, 0x3B4D2B6D795086A0,
 0x1FE50805EDF36CA0, 0x18B883B5E74ED110,
 0x469F9F415C36B600, 0x23E9E8FFE162A5CE,
 0xFABC60622BA00858, 0x56FA6B95201917F2,
 0x668ECAD07B5F8820, 0x6B2F11A6A97AD3A6,
 0x339076761F9A5620, 0x161A28A6C25DA0E2,
 0x46531456BA060620, 0x29F7B64462EE0005,
 0x3E9C2442965E2520, 0x4FFB944BB8167D50,
 0x2D9983023CD4F1D0, 0x546A2817AA985A1E,
 0x57A6AEFD3B25EA10, 0x33B932B70D6E2C03,
 0xB95A7C73B21C230, 0x2E81CF70F7362E23,
 0x3825ADFDA787E7B0, 0x674E946D7F07319,
 0x96BE8CC46784EA40, 0xE02C1552314BBB6E,
 0x67842F29A7855520, 0x395429C0FA1AAACB,
 0x90E53100E5E8C150, 0xDD6B3CB98F7F4E3,
 0x929E6C8077F2D7C, 0x3DDC32E733BE2198,
 0x3C810D47309F6E68, 0x1071FEAF79247FAB,
 0x6084327787980768, 0x72BD5861B2F1E1D,
 0xC4A21BBC6346E312, 0xFC3EFE40B6C053E8
};


alignas(32) const uint64_t gfCantorto2128[2*128] = {
 0x1, 0x0,
 0x676AAC9FA4B20B08, 0x295AC0B1F4731AF9,
 0xFF1099C31BBE8F22, 0xA2134422CD4054C9,
 0x53B85B6402B1E848, 0x7959D70CE1EE6942,
 0xCABCD8E4694E5644, 0x8F6B313E935B8E2,
 0x4D48B16661E860EC, 0x49C9321635282198,
 0xA13FE8AC5560CE0C, 0x53D8555A9979A1C,
 0x5CB10FBABCF00118, 0x4D52354A3A3D8C86,
 0xE18C55B8E07D3612, 0x2CCAE6ED8D6B4CD0,
 0x588B6244C5D74470, 0x210D8FBE72672C66,
 0xD047DADA84654DA4, 0xC211182C85E148B3,
 0xFED3B473EEB39DF8, 0x104D101E47F1F112,
 0xBF199EB4F675F2AC, 0xCE955EA0DA2A682B,
 0x19C55B8D6BEF4C98, 0xDBACFB2AC336178F,
 0xF5531B28858156D0, 0x58770BC4E101AB94,
 0x8B97B65B221CC4E4, 0x497F8ADB47E0AE82,
 0xA10CFC6A1654C578, 0x5AA755DF14F64DA,
 0xBAE99A4E3FBE0C54, 0x82DB354523F40C7B,
 0x8E808EC2A80C4662, 0xBA5BA13DBF25EE6B,
 0x5C2B82C39EF7A93C, 0x300B8602354DBC70,
 0x882E2943D5EE4534, 0xC25F5E75EDAA4FA9,
 0x95D3204B1D1DD922, 0x39092E35DE04CC32,
 0xCB6E1A7035541FD6, 0x8AB363F0B1F0F211,
 0xA1318678293664F4, 0xBE1ECA746232042B,
 0xE684ECC9B397A5FE, 0xB3B2D35103F1A3ED,
 0x6DA6F30E41A8EDF0, 0x34B0CC6CCF4EE620,
 0xACD605531D728F16, 0xA6AF6A59808B2143,
 0x36771E3CA90CA14, 0x3555819A552C1192,
 0xC6C1932EEB78B72A, 0xEABEA114C8AE9A9F,
 0xFC5874DD3B9425CE, 0x1988519C2A18A57C,
 0x70EC558472062C44, 0x60ABFABC33F697DE,
 0xA9E47128863BA654, 0xDF68FE1CDF73F30,
 0x8B6F419EA9E92F64, 0x87506CBE98650EE9,
 0xAE03A86096676122, 0xBB5791719BA8F14F,
 0xBA49EF0905BED85A, 0x9AE42542DB02833B,
 0x997880BEBF7EB61C, 0xF29856CA664755B9,
 0x16CB3187D20086C, 0x9E37D35816D18239,
 0x248C663B21703ABE, 0x71815387F77F4DBC,
 0x143024F5848F1090, 0xA6D469FDBE031AB9,
 0x790935AF79870BE0, 0x1D83AB0444495694,
 0xBE2444C534740484, 0xCBAF5837829B974F,
 0x5EFC7F3AA24D39CA, 0xF36A42B3E5F1CBBB,
 0x92372DB327A9D5EE, 0x1CF5645B85D85AC4,
 0xD48CD14917A38034, 0xE374C7526E3ABF93,
 0x2490765A301E28C2, 0xB608A7B1ADE6F573,
 0xAA56DFD514863CF6, 0x9EC927E0EA730849,
 0xB493920663B35D20, 0xF2EEE16207FA6641,
 0x9B78C9542BBA3A2E, 0x79C54CDD0E226966,
 0x456895C1D95FE234, 0xEE72B1A21497E77B,
 0x4EB77B48CC5F7038, 0x9AD3C105B155FFEF,
 0x68F65FA05931208C, 0x585B4042D008C9DA,
 0x16DDE2BB2B38DCFA, 0xAECA82EE463B0B3B,
 0x3904C8D2F5C3D2D6, 0x54D2B7C147B9EAB0,
 0x8B1C8BD76F237756, 0x4D81761CE690153E,
 0x8A2133F2160FC5EC, 0x614A21C3FF3BF28A,
 0x4B053B0413B7ED2A, 0xA7CDB8C6809748D7,
 0x14E4307F9D1772B6, 0x515219CA23F9CE5C,
 0x511E34506522E6AE, 0x8247627F48FF1F7F,
 0xE3A3756C6EFACFC4, 0xF788C793E7244E9F,
 0x5A70839FC81FB4C0, 0xD35F0EB88CAE752B,
 0xDA8E23483A97853A, 0x38F065E6EC77C32C,
 0xD1700CE51721220C, 0xEE558F30070E0C3D,
 0x249484A90E31EF88, 0xD78F250953E96933,
 0x771A1494D77054AC, 0xDE34B71E0312848F,
 0x27F349141093E620, 0x97E14E9448DECAE7,
 0x8DA828E52BE94D70, 0x928DE3C8E22C0F1D,
 0xC1E9DB8AC9F1C256, 0xBA586143DFE63DEB,
 0xD9B45813424B2B38, 0xB2052CA6FB35EAA9,
 0x10F28AB6172A4EFA, 0x794A2A7C84A76D2C,
 0x213491AF2F858C38, 0xA3FB2735D34FBAA7,
 0xDD93CC151A20DCDA, 0xFA7CA4A3574C6525,
 0x3190A2225AB65E2C, 0xFF5E390DA90F4835,
 0x71389B2A8246F5E4, 0xD79573B001F21771,
 0x6AE0532AE2BBFB90, 0xDFD3122B95E92C4F,
 0xCD6B22D4C21C7758, 0x59EE81E35141D3CC,
 0x85E338536EB1BBC, 0xCA785A7F809253D7,
 0xA602F3FD08BBCA2A, 0x3CF77B9A1DED625A,
 0x9CFB59155F2C296A, 0xC74456A7F1E3B58B,
 0xBC92DE7F7EBFD6C4, 0x38FF17882D7D411C,
 0x49DD31700DF81D26, 0x6DAAB92652394278,
 0x3B8F902C0A858E4E, 0x8B95B6A7427690CB,
 0xD525A8185F8AF324, 0xF31F1E9DAABBFF9F,
 0x17F87F09BC736F26, 0xFAFD49E2EE8251E9,
 0xAE5FB3551C95931E, 0x1863362E3AE97756,
 0x9B8F8F876479058E, 0xCAD343E8080CBA83,
 0x51BBCC440C472768, 0xF2E5A279864A60F5,
 0x6340402C3F7FFEBE, 0xB70B9103D1CD6617,
 0xDEB9EF235F15FF90, 0xB7959B94E1E22D49,
 0x5A9D3675A3531196, 0x3524CE9C7F7B56E2,
 0xCE10620E568164C2, 0x8EF7EE5CECDB882D,
 0x854D0FEA22C345B2, 0xDA3844C594D764BF,
 0x16C016C2D631AE74, 0xF2328DF87CDF3E71,
 0x3A9122C15F3AB78, 0x9EB8B35A2448EEFF,
 0x4AC1AB2D94AA463E, 0x3C449B0A0456C972,
 0x70D846AE38FFB938, 0x6CDDD4542B3A7254,
 0x3F1AB33BDD022656, 0xEE26C355DCAC88CF,
 0xA2DEF1742F3B5916, 0x55FE928CCC907446,
 0xC0536B0BE526EB6, 0xCE0290A08EA7ED67,
 0x63118F8310AFBD9C, 0xF3BFE1A1625671EF,
 0x5C5AD70DD7F32AE, 0xFBDCAF23D12E7A5D,
 0x2CD73C266F68DA36, 0x9BFCFCADD6ED8B57,
 0x6D8E1FE42B061D44, 0x3DB9C6976DF592A6,
 0x80CA05549A4DC27C, 0xC75A42071FF8895D,
 0xD1FBFF53B9E5B9A0, 0x11F736ABDBE2672A,
 0xC1CA004429D1C70C, 0x83670004DBE27F63,
 0x7ADE7BA41DA719E2, 0x75FF5173392AD2EA,
 0x2DA0B1432202BAE2, 0xC33784B9B478B88B,
 0x88CC8045CDFF4040, 0x39324DFDAD64AA8E,
 0xD1537109B42CC8A0, 0x8B6232E621520CA1,
 0xC5585EC70C29B8F0, 0x961F8FACDB0EA92D,
 0x641E0BBE37274246, 0x38E42A8AE4B60F8E,
 0xB1F69A8517D41456, 0xC70E543A5A80F74B,
 0xBCCF8CA839BFE3A8, 0x38BD7652FBB4463C,
 0xC4FAB69066E3433A, 0xEFA5F7CA9F6294C1,
 0xB54AFAD4CD1155A8, 0x31317C030896C74A,
 0x7D4BBA2CBAE355D4, 0xD5FB04E16DA98B6,
 0xFD2B185552FCCA1E, 0xAF27A2C3C9AF3B15,
 0xA74E3032C1C70940, 0xB22C87060644347D,
 0x96784C18FA9A222C, 0x9F1317DD9BD62B2B,
 0xA055412A1255732C, 0x9675E5102F20A86D,
 0xBD9E54181B305F0, 0x1196F9167176350A,
 0x2DE9C7568EC18048, 0x4C7D6F6A66426BC8,
 0xF69478D0555733BE, 0x2CF2076679E35CAE,
 0xA0DEA3EAEE857928, 0xEFF27F24FDCF1CB1,
 0x22DE535186312472, 0xB2C39CCA82539E4D,
 0x1C881E66C80D1A94, 0x79FFDC889D966BB8,
 0x34209CFCCF813712, 0xA2DACC7D457CFCD7,
 0xDBFA17232FFAA1AA, 0x9D8978748EA31B83
};


alignas(32) const uint64_t gf2128toCantor_4R[2*(16*2*16)]  = {

0x0,0x0,
0x1,0x0,
0xf62da500563a6180,0x4e8fb76fadde40ea,
0xf62da500563a6181,0x4e8fb76fadde40ea,
0x8d3b77807d275140,0x69c86cd87b31609f,
0x8d3b77807d275141,0x69c86cd87b31609f,
0x7b16d2802b1d30c0,0x2747dbb7d6ef2075,
0x7b16d2802b1d30c1,0x2747dbb7d6ef2075,
0x49ea0be5a4b1d580,0x45ea054d27f72703,
0x49ea0be5a4b1d581,0x45ea054d27f72703,
0xbfc7aee5f28bb400,0xb65b2228a2967e9,
0xbfc7aee5f28bb401,0xb65b2228a2967e9,
0xc4d17c65d99684c0,0x2c2269955cc6479c,
0xc4d17c65d99684c1,0x2c2269955cc6479c,
0x32fcd9658face540,0x62addefaf1180776,
0x32fcd9658face541,0x62addefaf1180776,
0x0,0x0,
0x4ba6cc4043b4f9e0,0x5d2c5ab446a9d0d0,
0xf4c6a222652d980,0x6dfcf2e44ca64ddd,
0x44eaa66265e62060,0x30d0a8500a0f9d0d,
0xed1f0e1776e93f40,0x671f07ebb40cb482,
0xa6b9c257355dc6a0,0x3a335d5ff2a56452,
0xe253643550bbe6c0,0xae3f50ff8aaf95f,
0xa9f5a875130f1f20,0x57cfafbbbe03298f,
0x938422464f555d80,0x53c60b27554dcb46,
0xd822ee060ce1a460,0xeea519313e41b96,
0x9cc8486469078400,0x3e3af9c319eb869b,
0xd76e84242ab37de0,0x6316a3775f42564b,
0x7e9b2c5139bc62c0,0x34d90ccce1417fc4,
0x353de0117a089b20,0x69f55678a7e8af14,
0x71d746731feebb40,0x5925fe28ade73219,
0x3a718a335c5a42a0,0x409a49ceb4ee2c9,
0x0,0x0,
0x6e75aa60626e8510,0x73ba77ee65fd38b8,
0x5176a0b45a20dd80,0x79ab26e5f2005eb2,
0x3f030ad4384e5890,0xa11510b97fd660a,
0x88ea5f33357bb540,0x5b028b966af56b33,
0xe69ff55357153050,0x28b8fc780f08538b,
0xd99cff876f5b68c0,0x22a9ad7398f53581,
0xb7e955e70d35edd0,0x5113da9dfd080d39,
0xebaa5b08988bab80,0xfbb35dbfeaca77c,
0x85dff168fae52e90,0x7c0142359b519fc4,
0xbadcfbbcc2ab7600,0x7610133e0cacf9ce,
0xd4a951dca0c5f310,0x5aa64d06951c176,
0x6340043badf01ec0,0x54b9be4d9459cc4f,
0xd35ae5bcf9e9bd0,0x2703c9a3f1a4f4f7,
0x3236a48ff7d0c340,0x2d1298a8665992fd,
0x5c430eef95be4650,0x5ea8ef4603a4aa45,
0x0,0x0,
0x9b90891ccd9da0e0,0x5490841e6e0aeec3,
0x71e8f62ad6538480,0x10ff7ae9fd162518,
0xea787f361bce2460,0x446ffef7931ccbdb,
0xda46336568fff340,0x7a250eb4ffeb2ee5,
0x41d6ba79a56253a0,0x2eb58aaa91e1c026,
0xabaec54fbeac77c0,0x6ada745d02fd0bfd,
0x303e4c537331d720,0x3e4af0436cf7e53e,
0x73070bb8fbfbae80,0x51f6b50b77fb18d,
0xe89782a436660e60,0x518fef4ed9755f4e,
0x2effd922da82a00,0x15e011b94a699495,
0x997f748ee0358ae0,0x417095a724637a56,
0xa94138dd93045dc0,0x7f3a65e448949f68,
0x32d1b1c15e99fd20,0x2baae1fa269e71ab,
0xd8a9cef74557d940,0x6fc51f0db582ba70,
0x433947eb88ca79a0,0x3b559b13db8854b3,
0x0,0x0,
0x594f7f505359c798,0x4a674c195703a4e4,
0xac5cbaddd0a35780,0x7993d46d3c8420e0,
0xf513c58d83fa9018,0x33f498746b878404,
0x79cdf0ee7730b340,0x457eb5970b0071eb,
0x20828fbe246974d8,0xf19f98e5c03d50f,
0xd5914a33a793e4c0,0x3ced61fa3784510b,
0x8cde3563f4ca2358,0x768a2de36087f5ef,
0x2f29a7f7044ef00,0x1ca1ea3434b30df4,
0x5bbde52f231d2898,0x56c6a62d63b0a910,
0xaeae20a2a0e7b880,0x65323e5908372d14,
0xf7e15ff2f3be7f18,0x2f5572405f3489f0,
0x7b3f6a9107745c40,0x59df5fa33fb37c1f,
0x227015c1542d9bd8,0x13b813ba68b0d8fb,
0xd763d04cd7d70bc0,0x204c8bce03375cff,
0x8e2caf1c848ecc58,0x6a2bc7d75434f81b,
0x0,0x0,
0x4c9f70aaafc66fe0,0x7683ce5d5f8fdeaa,
0xf7ff15ec6e75a480,0x68383cb9786af78a,
0xbb606546c1b3cb60,0x1ebbf2e427e52920,
0x9e7f768cd4ce7e40,0x866af3601faf4c2,
0xd2e006267b0811a0,0x7ee5616b5e752a68,
0x69806360babbdac0,0x605e938f79900348,
0x251f13ca157db520,0x16dd5dd2261fdde2,
0xf8bfffdceb48f300,0x8bbb968cda7aeb6,
0xb4208f76448e9ce0,0x7e3877359228701c,
0xf40ea30853d5780,0x608385d1b5cd593c,
0x43df9a9a2afb3860,0x16004b8cea428796,
0x66c089503f868d40,0xdd165ecc5d5a74,
0x2a5ff9fa9040e2a0,0x765ed80393d284de,
0x913f9cbc51f329c0,0x68e52ae7b437adfe,
0xdda0ec16fe354620,0x1e66e4baebb87354,
0x0,0x0,
0x5658cd92ab537090,0x7ed8c611590f99a2,
0x97f31ac8bfcf79c0,0x41a564ef69f0061b,
0xc1abd75a149c0950,0x3f7da2fe30ff9fb9,
0x491c8d3fbd7a46c0,0x1880c79d039d3794,
0x1f4440ad16293650,0x6658018c5a92ae36,
0xdeef97f702b53f00,0x5925a3726a6d318f,
0x88b75a65a9e64f90,0x27fd65633362a82d,
0x5320998dc8436ee0,0x2ad36ec06c212493,
0x578541f63101e70,0x540ba8d1352ebd31,
0xc4d38345778c1720,0x6b760a2f05d12288,
0x928b4ed7dcdf67b0,0x15aecc3e5cdebb2a,
0x1a3c14b275392820,0x3253a95d6fbc1307,
0x4c64d920de6a58b0,0x4c8b6f4c36b38aa5,
0x8dcf0e7acaf651e0,0x73f6cdb2064c151c,
0xdb97c3e861a52170,0xd2e0ba35f438cbe,
0x0,0x0,
0x37652ad7dc800ae0,0x473789ee801eb997,
0xcde57afded182e80,0x599cbaf635479bbf,
0xfa80502a31982460,0x1eab3318b5592228,
0xca848e64860679c0,0x790def8ecc0694b,
0xfde1a4b35a867320,0x40a757166cded0dc,
0x761f4996b1e5740,0x5e0c640ed987f2f4,
0x3004de4eb79e5da0,0x193bede059994b63,
0xbde78f553997130,0x31b03d86963281e0,
0x3cbb52228f197bd0,0x7687b468162c3877,
0xc63b0208be815fb0,0x682c8770a3751a5f,
0xf15e28df62015550,0x2f1b0e9e236ba3c8,
0xc15af691d59f08f0,0x3620e37e7af2e8ab,
0xf63fdc46091f0210,0x71176a90faec513c,
0xcbf8c6c38872670,0x6fbc59884fb57314,
0x3bdaa6bbe4072c90,0x288bd066cfabca83,
0x0,0x0,
0x75e8c0f87af52454,0x6f54ea15fc827696,
0x57b33c64a3509080,0x4ac5e2d5008ca73c,
0x225bfc9cd9a5b4d4,0x259108c0fc0ed1aa,
0xfa72e7b338f2fc40,0x455a3e5ba2c63090,
0x8f9a274b4207d814,0x2a0ed44e5e444606,
0xadc1dbd79ba26cc0,0xf9fdc8ea24a97ac,
0xd8291b2fe1574894,0x60cb369b5ec8e13a,
0xc25a47daa93bca80,0x28dc1d391faf20f7,
0xb7b28722d3ceeed4,0x4788f72ce32d5661,
0x95e97bbe0a6b5a00,0x6219ffec1f2387cb,
0xe001bb46709e7e54,0xd4d15f9e3a1f15d,
0x3828a06991c936c0,0x6d862362bd691067,
0x4dc06091eb3c1294,0x2d2c97741eb66f1,
0x6f9b9c0d3299a640,0x2743c1b7bde5b75b,
0x1a735cf5486c8214,0x48172ba24167c1cd,
0x0,0x0,
0xc52b08994ca8eae0,0x67c1ef5c8e80491e,
0x38335d064e98e300,0x300d6942f7cd9ec1,
0xfd18559f023009e0,0x57cc861e794dd7df,
0x38bd740c8669880,0x12f11f2e2eea8b0e,
0xc6a0dfd984ce7260,0x7530f072a06ac210,
0x3bb88a4686fe7b80,0x22fc766cd92715cf,
0xfe9382dfca569160,0x453d993057a75cd1,
0x684de1efe77b4680,0x3e7995b45292dcba,
0xad66e976abd3ac60,0x59b87ae8dc1295a4,
0x507ebce9a9e3a580,0xe74fcf6a55f427b,
0x9555b470e54b4f60,0x69b513aa2bdf0b65,
0x6bc636af2f1dde00,0x2c888a9a7c7857b4,
0xaeed3e3663b534e0,0x4b4965c6f2f81eaa,
0x53f56ba961853d00,0x1c85e3d88bb5c975,
0x96de63302d2dd7e0,0x7b440c840535806b,
0x0,0x0,
0x6ad0c8fff8255810,0x4dc22973f04831ff,
0x588c3c0e52306980,0x229ef6c52fb0f783,
0x325cf4f1aa153190,0x6f5cdfb6dff8c67c,
0x8c009f1a594f76c0,0x5c2422e5c45f8c4f,
0xe6d057e5a16a2ed0,0x11e60b963417bdb0,
0xd48ca3140b7f1f40,0x7ebad420ebef7bcc,
0xbe5c6bebf35a4750,0x3378fd531ba74a33,
0x703cb1d20ceae280,0x6f04d24433fb96b2,
0x1aec792df4cfba90,0x22c6fb37c3b3a74d,
0x28b08ddc5eda8b00,0x4d9a24811c4b6131,
0x42604523a6ffd310,0x580df2ec0350ce,
0xfc3c2ec855a59440,0x3320f0a1f7a41afd,
0x96ece637ad80cc50,0x7ee2d9d207ec2b02,
0xa4b012c60795fdc0,0x11be0664d814ed7e,
0xce60da39ffb0a5d0,0x5c7c2f17285cdc81,
0x0,0x0,
0xd140cdcabea94160,0xc55f8ad01078ea3,
0x3cd36e9a93b35c40,0x6192262cad674b9a,
0xed93a3502d1a1d20,0x6dc7de81ac60c539,
0x84e000329eec8a80,0xce665dcab7479ed,
0x55a0cdf82045cbe0,0xb39d71aa73f74e,
0xb8336ea80d5fd6c0,0x6d7443f006133277,
0x6973a362b3f697a0,0x6121bb5d0714bcd4,
0xd15cd3373c46ec20,0x7855d70faeef256f,
0x1c1efd82efad40,0x74002fa2afe8abcc,
0xed8fbdadaff5b060,0x19c7f12303886ef5,
0x3ccf7067115cf100,0x1592098e028fe056,
0x55bcd305a2aa66a0,0x74b3b2d3059b5c82,
0x84fc1ecf1c0327c0,0x78e64a7e049cd221,
0x696fbd9f31193ae0,0x152194ffa8fc1718,
0xb82f70558fb07b80,0x19746c52a9fb99bb,
0x0,0x0,
0x7d74ab5bfefac8d8,0x41b4a519f5885573,
0xeed73249b9735400,0x3f530821d3b2a371,
0x93a3991247899cd8,0x7ee7ad38263af602,
0x5c0a97ace028c520,0x6177d698dd080516,
0x217e3cf71ed20df8,0x20c3738128805065,
0xb2dda5e5595b9120,0x5e24deb90ebaa667,
0xcfa90ebea7a159f8,0x1f907ba0fb32f314,
0x85403ec43c26cd80,0x15e45d883811cfca,
0xf834959fc2dc0558,0x5450f891cd999ab9,
0x6b970c8d85559980,0x2ab755a9eba36cbb,
0x16e3a7d67baf5158,0x6b03f0b01e2b39c8,
0xd94aa968dc0e08a0,0x74938b10e519cadc,
0xa43e023322f4c078,0x35272e0910919faf,
0x379d9b21657d5ca0,0x4bc0833136ab69ad,
0x4ae9307a9b879478,0xa742628c3233cde,
0x0,0x0,
0x6d92cba063c765a0,0x14c0a4538253ac5e,
0xbe016081553c8480,0x705d0e8e57e8b405,
0xd393ab2136fbe120,0x649daaddd5bb185b,
0xfab0d54b2c62d990,0x3fbad9a05a31b6da,
0x97221eeb4fa5bc30,0x2b7a7df3d8621a84,
0x44b1b5ca795e5d10,0x4fe7d72e0dd902df,
0x29237e6a1a9938b0,0x5b27737d8f8aae81,
0xeab9f006b6a248c0,0x10d0fd26ba749e1f,
0x872b3ba6d5652d60,0x410597538273241,
0x54b89087e39ecc40,0x608df3a8ed9c2a1a,
0x392a5b278059a9e0,0x744d57fb6fcf8644,
0x1009254d9ac09150,0x2f6a2486e04528c5,
0x7d9beeedf907f4f0,0x3baa80d56216849b,
0xae0845cccffc15d0,0x5f372a08b7ad9cc0,
0xc39a8e6cac3b7070,0x4bf78e5b35fe309e,
0x0,0x0,
0xacd7bfbc32c00f90,0x64ac4d19c011e55c,
0x22e05ba415139bc0,0x1bec30c48396c0bc,
0x8e37e41827d39450,0x7f407ddd438725e0,
0x2b17c7831b9439c0,0x7552e78d2fe45660,
0x87c0783f29543650,0x11feaa94eff5b33c,
0x9f79c270e87a200,0x6ebed749ac7296dc,
0xa520239b3c47ad90,0xa129a506c637380,
0x9ac4cb562dc6b3e0,0x22d1dcda09b437fd,
0x361374ea1f06bc70,0x467d91c3c9a5d2a1,
0xb82490f238d52820,0x393dec1e8a22f741,
0x14f32f4e0a1527b0,0x5d91a1074a33121d,
0xb1d30cd536528a20,0x57833b572650619d,
0x1d04b369049285b0,0x332f764ee64184c1,
0x93335771234111e0,0x4c6f0b93a5c6a121,
0x3fe4e8cd11811e70,0x28c3468a65d7447d,
0x0,0x0,
0x2fc6c956c5054520,0x458b1849aa05dee,
0x4507ca313af999c0,0x2e67ce80ac133372,
0x6ac10367fffcdce0,0x2a3f7f0436b36e9c,
0xe31448ffa55c9a8,0x29682345dd2bc110,
0x21f78dd93f508c88,0x2d3092c1478b9cfe,
0x4b368ebec0ac5068,0x70fedc57138f262,
0x64f047e805a91548,0x3575c41eb98af8c,
0x40f823a5051005b0,0x5cd66fbedca1416,
0x6f3eeaf3c0154090,0x195d77f776a49f8,
0x5ffe9943fe99c70,0x2baaa87b41d92764,
0x2a3920c2faecd950,0x2ff219ffdb797a8a,
0x4ec9672aff45cc18,0x2ca545be30e1d506,
0x610fae7c3a408938,0x28fdf43aaa4188e8,
0xbcead1bc5bc55d8,0x2c28b3e9cf2e674,
0x2408644d00b910f8,0x69a3aba0652bb9a,
0x0,0x0,
0x4f1ca084478fb67e,0x58fe9f1f02c34ddd,
0x9401e0e17ffcc0c0,0xf39e6874fb57154,
0xdb1d4065387376be,0x57c779984d763c89,
0x7c6aa256f2f8d8c0,0x6fa713bf80caf4a2,
0x337602d2b5776ebe,0x37598ca08209b97f,
0xe86b42b78d041800,0x609ef538cf7f85f6,
0xa777e233ca8bae7e,0x38606a27cdbcc82b,
0x41fba012f6fe4260,0x6517fe8daecc43b8,
0xee70096b171f41e,0x3de96192ac0f0e65,
0xd5fa40f3890282a0,0x6a2e180ae17932ec,
0x9ae6e077ce8d34de,0x32d08715e3ba7f31,
0x3d91024404069aa0,0xab0ed322e06b71a,
0x728da2c043892cde,0x524e722d2cc5fac7,
0xa990e2a57bfa5a60,0x5890bb561b3c64e,
0xe68c42213c75ec1e,0x5d7794aa63708b93,
0x0,0x0,
0x874b946aa48b8260,0x67f7217673a528d8,
0x67082553208b4ec0,0x512cb42b7b65fc48,
0xe043b1398400cca0,0x36db955d08c0d490,
0x23776437fda62fc0,0x3cb213a59078b08c,
0xa43cf05d592dada0,0x5b4532d3e3dd9854,
0x447f4164dd2d6100,0x6d9ea78eeb1d4cc4,
0xc334d50e79a6e360,0xa6986f898b8641c,
0x55e63becbcfd490,0x69b9e67845568804,
0x8215f7d46f4456f0,0xe4ec70e36f3a0dc,
0x625646edeb449a50,0x389552533e33744c,
0xe51dd2874fcf1830,0x5f6273254d965c94,
0x262907893669fb50,0x550bf5ddd52e3888,
0xa16293e392e27930,0x32fcd4aba68b1050,
0x412122da16e2b590,0x42741f6ae4bc4c0,
0xc66ab6b0b26937f0,0x63d06080ddeeec18,
0x0,0x0,
0xa7be8cd5eafc9f90,0x542118f2c9c06d91,
0x3f9dff5de5a98c40,0x4b5159e1f17738cb,
0x982373880f5513d0,0x1f70411338b7555a,
0xa42af38569d49280,0x280bdde38c2b51a1,
0x3947f5083280d10,0x7c2ac51145eb3c30,
0x9bb70cd88c7d1ec0,0x635a84027d5c696a,
0x3c09800d66818150,0x377b9cf0b49c04fb,
0x56562bd5ae896260,0x3aee4cd13fe66fb1,
0xf1e8a7004475fdf0,0x6ecf5423f6260220,
0x69cbd4884b20ee20,0x71bf1530ce91577a,
0xce75585da1dc71b0,0x259e0dc207513aeb,
0xf27cd850c75df0e0,0x12e59132b3cd3e10,
0x55c254852da16f70,0x46c489c07a0d5381,
0xcde1270d22f47ca0,0x59b4c8d342ba06db,
0x6a5fabd8c808e330,0xd95d0218b7a6b4a,
0x0,0x0,
0x24e3ce0ac55d4c0,0x1b8990b9399fce89,
0x534c03fe0cb12380,0x2ac17c44b5cbf6c8,
0x51023f1ea0e4f740,0x3148ecfd8c543841,
0x5c6b111814c6e5c0,0x21455f6e7bdbb2e7,
0x5e252df8b8933100,0x3acccfd742447c6e,
0xf2712e61877c640,0xb84232ace10442f,
0xd692e06b4221280,0x100db393f78f8aa6,
0xf701b24abea37538,0x4e51bfce5ed600a8,
0xf54f8eaa12f6a1f8,0x55d82f776749ce21,
0xa44db1b4b21256b8,0x6490c38aeb1df660,
0xa6038d541e478278,0x7f195333d28238e9,
0xab6aa352aa6590f8,0x6f14e0a0250db24f,
0xa9249fb206304438,0x749d70191c927cc6,
0xf826a0aca6d4b378,0x45d59ce490c64487,
0xfa689c4c0a8167b8,0x5e5c0c5da9598a0e,
0x0,0x0,
0xdfb8ac800437f418,0x6b233dca086c2900,
0xc6f518ab0a6126c0,0x3091d352179134ac,
0x194db42b0e56d2d8,0x5bb2ee981ffd1dac,
0xf4ca22097b285d40,0x33d18da7b8688c42,
0x2b728e897f1fa958,0x58f2b06db004a542,
0x323f3aa271497b80,0x3405ef5aff9b8ee,
0xed879622757e8f98,0x6863633fa79591ee,
0x29791f73870d6c60,0x90f979c19a369e,
0xf6c1b3f3833a9878,0x6bb3c4b3c9f61f9e,
0xef8c07d88d6c4aa0,0x30012a2bd60b0232,
0x3034ab58895bbeb8,0x5b2217e1de672b32,
0xddb33d7afc253120,0x334174de79f2badc,
0x20b91faf812c538,0x58624914719e93dc,
0x1b4625d1f64417e0,0x3d0a78c6e638e70,
0xc4fe8951f273e3f8,0x68f39a46660fa770,
0x0,0x0,
0x4a00d09775e8cda0,0x7236339726704a68,
0x82cd618d9c5501c0,0x3bffc9c61e25ca,
0xc8cdb11ae9bdcc60,0x720dcc5ee06e6fa2,
0x4822e93b0a9f93c0,0x5886bb662a065deb,
0x22239ac7f775e60,0x2ab088f10c761783,
0xcaef88b696ca9200,0x58bd44afec187821,
0x80ef5821e3225fa0,0x2a8b7738ca683249,
0x1b71ef6a0e483350,0x7993ee78c552d6a7,
0x51713ffd7ba0fef0,0xba5ddefe3229ccf,
0x99bc8ee7921d3290,0x79a811b1034cf36d,
0xd3bc5e70e7f5ff30,0xb9e2226253cb905,
0x5353065104d7a090,0x2115551eef548b4c,
0x1953d6c6713f6d30,0x53236689c924c124,
0xd19e67dc9882a150,0x212eaad7294aae86,
0x9b9eb74bed6a6cf0,0x531899400f3ae4ee,
0x0,0x0,
0x39e0ab2fe1fde1d0,0xa7f04fb818449f2,
0xe42fd1b7336ca480,0x52d5eafab8973bd4,
0xddcf7a98d2914550,0x58aaee0139137226,
0x22bad9d7da6af260,0x515b353afbd4ee57,
0x1b5a72f83b9713b0,0x5b2431c17a50a7a5,
0xc6950860e90656e0,0x38edfc04343d583,
0xff75a34f08fbb730,0x9f1db3bc2c79c71,
0x516e6080e351fa00,0x46c13a15087aab4d,
0x688ecbaf02ac1bd0,0x4cbe3eee89fee2bf,
0xb541b137d03d5e80,0x1414d0efb0ed9099,
0x8ca11a1831c0bf50,0x1e6bd4143169d96b,
0x73d4b957393b0860,0x179a0f2ff3ae451a,
0x4a341278d8c6e9b0,0x1de50bd4722a0ce8,
0x97fb68e00a57ace0,0x454fe5d54b397ece,
0xae1bc3cfebaa4d30,0x4f30e12ecabd373c,
0x0,0x0,
0x4690002bd19acfc0,0xa955732fece451b,
0xc1839bcf7320a80,0x68bc48675d86763a,
0x4a88399726a8c540,0x62291f55a3483321,
0x39f2baaca2659a30,0x447f3c887998b7d8,
0x7f62ba8773ff55f0,0x4eea6bba8756f2c3,
0x35ea8310555790b0,0x2cc374ef241ec1e2,
0x737a833b84cd5f70,0x265623dddad084f9,
0xbb694356ef81d8c4,0x39a5b4f38e7a471d,
0xfdf9437d3e1b1704,0x3330e3c170b40206,
0xb7717aea18b3d244,0x5119fc94d3fc3127,
0xf1e17ac1c9291d84,0x5b8caba62d32743c,
0x829bf9fa4de442f4,0x7dda887bf7e2f0c5,
0xc40bf9d19c7e8d34,0x774fdf49092cb5de,
0x8e83c046bad64874,0x1566c01caa6486ff,
0xc813c06d6b4c87b4,0x1ff3972e54aac3e4,
0x0,0x0,
0xc3cefef60187acb4,0x616ef7950f4c7fca,
0x67a4e5d8638e700,0x3be4e6c6c898c5f1,
0xc5b4b0ab87bf4bb4,0x5a8a1153c7d4ba3b,
0x19bcab6d65cafe00,0x20fa8c313a6bf2c9,
0xda72559b644d52b4,0x41947ba435278d03,
0x1fc6e530e3f21900,0x1b1e6af7f2f33738,
0xdc081bc6e275b5b4,0x7a709d62fdbf48f2,
0x636d0f3c9fc78580,0x32b2e1b2ce393d61,
0xa0a3f1ca9e402934,0x53dc1627c17542ab,
0x6517416119ff6280,0x956077406a1f890,
0xa6d9bf971878ce34,0x6838f0e109ed875a,
0x7ad1a451fa0d7b80,0x12486d83f452cfa8,
0xb91f5aa7fb8ad734,0x73269a16fb1eb062,
0x7cabea0c7c359c80,0x29ac8b453cca0a59,
0xbf6514fa7db23034,0x48c27cd033867593,
0x0,0x0,
0x720fdc7a903ca7b0,0x51cc3dd4b38c079d,
0x248557edbe4e0340,0x2ea9636ee97d7826,
0x568a8b972e72a4f0,0x7f655eba5af17fbb,
0xc7e021a62235ab40,0x1f16734c2419282f,
0xb5effddcb2090cf0,0x4eda4e9897952fb2,
0xe365764b9c7ba800,0x31bf1022cd645009,
0x916aaa310c470fb0,0x60732df67ee85794,
0x5bea4b95dc05b9c0,0x7f7c33d4daad4f9,
0x29e597ef4c391e70,0x563bfee9fe26d364,
0x7f6f1c78624bba80,0x295ea053a4d7acdf,
0xd60c002f2771d30,0x78929d87175bab42,
0x9c0a6a33fe301280,0x18e1b07169b3fcd6,
0xee05b6496e0cb530,0x492d8da5da3ffb4b,
0xb88f3dde407e11c0,0x3648d31f80ce84f0,
0xca80e1a4d042b670,0x6784eecb3342836d,
0x0,0x0,
0x5b5bae705224d770,0x1ea0f67a437a7a71,
0x5d17d7932cc19000,0x1d3cc922ba197240,
0x64c79e37ee54770,0x39c3f58f9630831,
0x6101d0c1ffa2c6c0,0x487389c97c1cee07,
0x3a5a7eb1ad8611b0,0x56d37fb33f669476,
0x3c160752d36356c0,0x554f40ebc6059c47,
0x674da922814781b0,0x4befb691857fe636,
0xbb32e77c1c107280,0x7d641103dd9b2707,
0xe069490c4e34a5f0,0x63c4e7799ee15d76,
0xe62530ef30d1e280,0x6058d82167825547,
0xbd7e9e9f62f535f0,0x7ef82e5b24f82f36,
0xda3337bde3b2b440,0x351798caa187c900,
0x816899cdb1966330,0x2bb76eb0e2fdb371,
0x8724e02ecf732440,0x282b51e81b9ebb40,
0xdc7f4e5e9d57f330,0x368ba79258e4c131,
0x0,0x0,
0x87e8bfeeba53b558,0x2067b57077296db7,
0x222b5a3e4b11c0c0,0x3b4d2b6d795086a0,
0xa5c3e5d0f1427598,0x1b2a9e1d0e79eb17,
0x1fe50805edf36ca0,0x18b883b5e74ed110,
0x980db7eb57a0d9f8,0x38df36c59067bca7,
0x3dce523ba6e2ac60,0x23f5a8d89e1e57b0,
0xba26edd51cb11938,0x3921da8e9373a07,
0x469f9f415c36b600,0x23e9e8ffe162a5ce,
0xc17720afe6650358,0x38e5d8f964bc879,
0x64b4c57f172776c0,0x18a4c3929832236e,
0xe35c7a91ad74c398,0x38c376e2ef1b4ed9,
0x597a9744b1c5daa0,0x3b516b4a062c74de,
0xde9228aa0b966ff8,0x1b36de3a71051969,
0x7b51cd7afad41a60,0x1c40277f7cf27e,
0xfcb972944087af38,0x207bf55708559fc9,
0x0,0x0,
0xfabc60622ba00858,0x56fa6b95201917f2,
0x668ecad07b5f8820,0x6b2f11a6a97ad3a6,
0x9c32aab250ff8078,0x3dd57a338963c454,
0x339076761f9a5620,0x161a28a6c25da0e2,
0xc92c1614343a5e78,0x40e04333e244b710,
0x551ebca664c5de00,0x7d3539006b277344,
0xafa2dcc44f65d658,0x2bcf52954b3e64b6,
0x46531456ba060620,0x29f7b64462ee0005,
0xbcef743491a60e78,0x7f0dddd142f717f7,
0x20ddde86c1598e00,0x42d8a7e2cb94d3a3,
0xda61bee4eaf98658,0x1422cc77eb8dc451,
0x75c36220a59c5000,0x3fed9ee2a0b3a0e7,
0x8f7f02428e3c5858,0x6917f57780aab715,
0x134da8f0dec3d820,0x54c28f4409c97341,
0xe9f1c892f563d078,0x238e4d129d064b3,
0x0,0x0,
0x3e9c2442965e2520,0x4ffb944bb8167d50,
0x2d9983023cd4f1d0,0x546a2817aa985a1e,
0x1305a740aa8ad4f0,0x1b91bc5c128e274e,
0x57a6aefd3b25ea10,0x33b932b70d6e2c03,
0x693a8abfad7bcf30,0x7c42a6fcb5785153,
0x7a3f2dff07f11bc0,0x67d31aa0a7f6761d,
0x44a309bd91af3ee0,0x28288eeb1fe00b4d,
0xb95a7c73b21c230,0x2e81cf70f7362e23,
0x35098385ad7fe710,0x617a5b3b4f205373,
0x260c24c507f533e0,0x7aebe7675dae743d,
0x1890008791ab16c0,0x3510732ce5b8096d,
0x5c33093a00042820,0x1d38fdc7fa580220,
0x62af2d78965a0d00,0x52c3698c424e7f70,
0x71aa8a383cd0d9f0,0x4952d5d050c0583e,
0x4f36ae7aaa8efcd0,0x6a9419be8d6256e,
0x0,0x0,
0x3825adfda787e7b0,0x674e946d7f07319,
0x96be8cc46784ea40,0xe02c1552314bbb6e,
0xae9b2139c0030df0,0xe658fc14e6bbc877,
0x67842f29a7855520,0x395429c0fa1aaacb,
0x5fa182d40002b290,0x3f20c0862dead9d2,
0xf13aa3edc001bf60,0xd9783c92cb5111a5,
0xc91f0e10678658d0,0xdf0cd5d41ca162bc,
0x90e53100e5e8c150,0xdd6b3cb98f7f4e3,
0xa8c09cfd426f26e0,0xba25a8d4f0787fa,
0x65bbdc4826c2b10,0xedfaa699a9bc4f8d,
0x3e7e103925ebcca0,0xeb8e4fdf7e4c3c94,
0xf7611e29426d9470,0x34829a0b62ed5e28,
0xcf44b3d4e5ea73c0,0x32f6734db51d2d31,
0x61df92ed25e97e30,0xd4ae8f5953a6e546,
0x59fa3f10826e9980,0xd2da661f8456965f,
0x0,0x0,
0x929e6c8077f2d7c,0x3ddc32e733be2198,
0x3c810d47309f6e68,0x1071feaf79247fab,
0x35a8eb8f37e04314,0x2dadcc484a9a5e33,
0x6084327787980768,0x72bd5861b2f1e1d,
0x69add4bf80e72a14,0x3af7e76128913f85,
0x5c053f30b7076900,0x175a2b29620b61b6,
0x552cd9f8b078447c,0x2a8619ce51b5402e,
0xc4a21bbc6346e312,0xfc3efe40b6c053e8,
0xcd8bfd746439ce6e,0xc1e2cca7857e7270,
0xf82316fb53d98d7a,0xec4f00efcfe42c43,
0xf10af03354a6a006,0xd1933208fc5a0ddb,
0xa42629cbe4dee47a,0xfb152bc6adef4df5,
0xad0fcf03e3a1c906,0xc6c919219e516c6d,
0x98a7248cd4418a12,0xeb64d569d4cb325e,
0x918ec244d33ea76e,0xd6b8e78ee77513c6,
};
//
//alignas(32) const uint64_t gfCantorto2128_4R[2*(16*2*16)] = {
//0x0,0x0,
//0x1,0x0,
//0x676aac9fa4b20b08,0x295ac0b1f4731af9,
//0x676aac9fa4b20b09,0x295ac0b1f4731af9,
//0xff1099c31bbe8f22,0xa2134422cd4054c9,
//0xff1099c31bbe8f23,0xa2134422cd4054c9,
//0x987a355cbf0c842a,0x8b49849339334e30,
//0x987a355cbf0c842b,0x8b49849339334e30,
//0x53b85b6402b1e848,0x7959d70ce1ee6942,
//0x53b85b6402b1e849,0x7959d70ce1ee6942,
//0x34d2f7fba603e340,0x500317bd159d73bb,
//0x34d2f7fba603e341,0x500317bd159d73bb,
//0xaca8c2a7190f676a,0xdb4a932e2cae3d8b,
//0xaca8c2a7190f676b,0xdb4a932e2cae3d8b,
//0xcbc26e38bdbd6c62,0xf210539fd8dd2772,
//0xcbc26e38bdbd6c63,0xf210539fd8dd2772,
//0x0,0x0,
//0xcabcd8e4694e5644,0x8f6b313e935b8e2,
//0x4d48b16661e860ec,0x49c9321635282198,
//0x87f4698208a636a8,0x413f8105dc1d997a,
//0xa13fe8ac5560ce0c,0x53d8555a9979a1c,
//0x6b8330483c2e9848,0xdcb364640a222fe,
//0xec7759ca3488aee0,0x4cf4b7439cbfbb84,
//0x26cb812e5dc6f8a4,0x44020450758a0366,
//0x5cb10fbabcf00118,0x4d52354a3a3d8c86,
//0x960dd75ed5be575c,0x45a48659d3083464,
//0x11f9bedcdd1861f4,0x49b075c0f15ad1e,
//0xdb456638b45637b0,0xc6db44fe62015fc,
//0xfd8ee716e990cf14,0x486fb01f93aa169a,
//0x37323ff280de9950,0x4099030c7a9fae78,
//0xb0c656708878aff8,0x1a68209a6823702,
//0x7a7a8e94e136f9bc,0x950311a4fb78fe0,
//0x0,0x0,
//0xe18c55b8e07d3612,0x2ccae6ed8d6b4cd0,
//0x588b6244c5d74470,0x210d8fbe72672c66,
//0xb90737fc25aa7262,0xdc76953ff0c60b6,
//0xd047dada84654da4,0xc211182c85e148b3,
//0x31cb8f6264187bb6,0xeedbfec1088a0463,
//0x88ccb89e41b209d4,0xe31c9792f78664d5,
//0x6940ed26a1cf3fc6,0xcfd6717f7aed2805,
//0xfed3b473eeb39df8,0x104d101e47f1f112,
//0x1f5fe1cb0eceabea,0x3c87f6f3ca9abdc2,
//0xa658d6372b64d988,0x31409fa03596dd74,
//0x47d4838fcb19ef9a,0x1d8a794db8fd91a4,
//0x2e946ea96ad6d05c,0xd25c0832c210b9a1,
//0xcf183b118aabe64e,0xfe96eedf4f7bf571,
//0x761f0cedaf01942c,0xf351878cb07795c7,
//0x979359554f7ca23e,0xdf9b61613d1cd917,
//0x0,0x0,
//0xbf199eb4f675f2ac,0xce955ea0da2a682b,
//0x19c55b8d6bef4c98,0xdbacfb2ac336178f,
//0xa6dcc5399d9abe34,0x1539a58a191c7fa4,
//0xf5531b28858156d0,0x58770bc4e101ab94,
//0x4a4a859c73f4a47c,0x96e255643b2bc3bf,
//0xec9640a5ee6e1a48,0x83dbf0ee2237bc1b,
//0x538fde11181be8e4,0x4d4eae4ef81dd430,
//0x8b97b65b221cc4e4,0x497f8adb47e0ae82,
//0x348e28efd4693648,0x87ead47b9dcac6a9,
//0x9252edd649f3887c,0x92d371f184d6b90d,
//0x2d4b7362bf867ad0,0x5c462f515efcd126,
//0x7ec4ad73a79d9234,0x1108811fa6e10516,
//0xc1dd33c751e86098,0xdf9ddfbf7ccb6d3d,
//0x6701f6fecc72deac,0xcaa47a3565d71299,
//0xd818684a3a072c00,0x4312495bffd7ab2,
//0x0,0x0,
//0xa10cfc6a1654c578,0x5aa755df14f64da,
//0xbae99a4e3fbe0c54,0x82db354523f40c7b,
//0x1be5662429eac92c,0x87714018d2bb68a1,
//0x8e808ec2a80c4662,0xba5ba13dbf25ee6b,
//0x2f8c72a8be58831a,0xbff1d4604e6a8ab1,
//0x3469148c97b24a36,0x388094789cd1e210,
//0x9565e8e681e68f4e,0x3d2ae1256d9e86ca,
//0x5c2b82c39ef7a93c,0x300b8602354dbc70,
//0xfd277ea988a36c44,0x35a1f35fc402d8aa,
//0xe6c2188da149a568,0xb2d0b34716b9b00b,
//0x47cee4e7b71d6010,0xb77ac61ae7f6d4d1,
//0xd2ab0c0136fbef5e,0x8a50273f8a68521b,
//0x73a7f06b20af2a26,0x8ffa52627b2736c1,
//0x6842964f0945e30a,0x88b127aa99c5e60,
//0xc94e6a251f112672,0xd21672758d33aba,
//0x0,0x0,
//0x882e2943d5ee4534,0xc25f5e75edaa4fa9,
//0x95d3204b1d1dd922,0x39092e35de04cc32,
//0x1dfd0908c8f39c16,0xfb56704033ae839b,
//0xcb6e1a7035541fd6,0x8ab363f0b1f0f211,
//0x43403333e0ba5ae2,0x48ec3d855c5abdb8,
//0x5ebd3a3b2849c6f4,0xb3ba4dc56ff43e23,
//0xd6931378fda783c0,0x71e513b0825e718a,
//0xa1318678293664f4,0xbe1eca746232042b,
//0x291faf3bfcd821c0,0x7c4194018f984b82,
//0x34e2a633342bbdd6,0x8717e441bc36c819,
//0xbccc8f70e1c5f8e2,0x4548ba34519c87b0,
//0x6a5f9c081c627b22,0x34ada984d3c2f63a,
//0xe271b54bc98c3e16,0xf6f2f7f13e68b993,
//0xff8cbc43017fa200,0xda487b10dc63a08,
//0x77a29500d491e734,0xcffbd9c4e06c75a1,
//0x0,0x0,
//0xe684ecc9b397a5fe,0xb3b2d35103f1a3ed,
//0x6da6f30e41a8edf0,0x34b0cc6ccf4ee620,
//0x8b221fc7f23f480e,0x87021f3dccbf45cd,
//0xacd605531d728f16,0xa6af6a59808b2143,
//0x4a52e99aaee52ae8,0x151db908837a82ae,
//0xc170f65d5cda62e6,0x921fa6354fc5c763,
//0x27f41a94ef4dc718,0x21ad75644c34648e,
//0x36771e3ca90ca14,0x3555819a552c1192,
//0xe5e39d2a79076fea,0x86e752cb56ddb27f,
//0x6ec182ed8b3827e4,0x1e54df69a62f7b2,
//0x88456e2438af821a,0xb2579ea79993545f,
//0xafb174b0d7e24502,0x93faebc3d5a730d1,
//0x493598796475e0fc,0x20483892d656933c,
//0xc21787be964aa8f2,0xa74a27af1ae9d6f1,
//0x24936b7725dd0d0c,0x14f8f4fe1918751c,
//0x0,0x0,
//0xc6c1932eeb78b72a,0xeabea114c8ae9a9f,
//0xfc5874dd3b9425ce,0x1988519c2a18a57c,
//0x3a99e7f3d0ec92e4,0xf336f088e2b63fe3,
//0x70ec558472062c44,0x60abfabc33f697de,
//0xb62dc6aa997e9b6e,0x8a155ba8fb580d41,
//0x8cb421594992098a,0x7923ab2019ee32a2,
//0x4a75b277a2eabea0,0x939d0a34d140a83d,
//0xa9e47128863ba654,0xdf68fe1cdf73f30,
//0x6f25e2066d43117e,0xe7482ef50559a5af,
//0x55bc05f5bdaf839a,0x147ede7de7ef9a4c,
//0x937d96db56d734b0,0xfec07f692f4100d3,
//0xd90824acf43d8a10,0x6d5d755dfe01a8ee,
//0x1fc9b7821f453d3a,0x87e3d44936af3271,
//0x25505071cfa9afde,0x74d524c1d4190d92,
//0xe391c35f24d118f4,0x9e6b85d51cb7970d,
//0x0,0x0,
//0x8b6f419ea9e92f64,0x87506cbe98650ee9,
//0xae03a86096676122,0xbb5791719ba8f14f,
//0x256ce9fe3f8e4e46,0x3c07fdcf03cdffa6,
//0xba49ef0905bed85a,0x9ae42542db02833b,
//0x3126ae97ac57f73e,0x1db449fc43678dd2,
//0x144a476993d9b978,0x21b3b43340aa7274,
//0x9f2506f73a30961c,0xa6e3d88dd8cf7c9d,
//0x997880bebf7eb61c,0xf29856ca664755b9,
//0x1217c12016979978,0x75c83a74fe225b50,
//0x377b28de2919d73e,0x49cfc7bbfdefa4f6,
//0xbc14694080f0f85a,0xce9fab05658aaa1f,
//0x23316fb7bac06e46,0x687c7388bd45d682,
//0xa85e2e2913294122,0xef2c1f362520d86b,
//0x8d32c7d72ca70f64,0xd32be2f926ed27cd,
//0x65d8649854e2000,0x547b8e47be882924,
//0x0,0x0,
//0x16cb3187d20086c,0x9e37d35816d18239,
//0x248c663b21703abe,0x71815387f77f4dbc,
//0x25e0d5235c5032d2,0xefb680dfe1aecf85,
//0x143024f5848f1090,0xa6d469fdbe031ab9,
//0x155c97edf9af18fc,0x38e3baa5a8d29880,
//0x30bc42cea5ff2a2e,0xd7553a7a497c5705,
//0x31d0f1d6d8df2242,0x4962e9225fadd53c,
//0x790935af79870be0,0x1d83ab0444495694,
//0x786586b704a7038c,0x83b4785c5298d4ad,
//0x5d85539458f7315e,0x6c02f883b3361b28,
//0x5ce9e08c25d73932,0xf2352bdba5e79911,
//0x6d39115afd081b70,0xbb57c2f9fa4a4c2d,
//0x6c55a2428028131c,0x256011a1ec9bce14,
//0x49b57761dc7821ce,0xcad6917e0d350191,
//0x48d9c479a15829a2,0x54e142261be483a8,
//0x0,0x0,
//0xbe2444c534740484,0xcbaf5837829b974f,
//0x5efc7f3aa24d39ca,0xf36a42b3e5f1cbbb,
//0xe0d83bff96393d4e,0x38c51a84676a5cf4,
//0x92372db327a9d5ee,0x1cf5645b85d85ac4,
//0x2c13697613ddd16a,0xd75a3c6c0743cd8b,
//0xcccb528985e4ec24,0xef9f26e86029917f,
//0x72ef164cb190e8a0,0x24307edfe2b20630,
//0xd48cd14917a38034,0xe374c7526e3abf93,
//0x6aa8958c23d784b0,0x28db9f65eca128dc,
//0x8a70ae73b5eeb9fe,0x101e85e18bcb7428,
//0x3454eab6819abd7a,0xdbb1ddd60950e367,
//0x46bbfcfa300a55da,0xff81a309ebe2e557,
//0xf89fb83f047e515e,0x342efb3e69797218,
//0x184783c092476c10,0xcebe1ba0e132eec,
//0xa663c705a6336894,0xc744b98d8c88b9a3,
//0x0,0x0,
//0x2490765a301e28c2,0xb608a7b1ade6f573,
//0xaa56dfd514863cf6,0x9ec927e0ea730849,
//0x8ec6a98f24981434,0x28c180514795fd3a,
//0xb493920663b35d20,0xf2eee16207fa6641,
//0x9003e45c53ad75e2,0x44e646d3aa1c9332,
//0x1ec54dd3773561d6,0x6c27c682ed896e08,
//0x3a553b89472b4914,0xda2f6133406f9b7b,
//0x9b78c9542bba3a2e,0x79c54cdd0e226966,
//0xbfe8bf0e1ba412ec,0xcfcdeb6ca3c49c15,
//0x312e16813f3c06d8,0xe70c6b3de451612f,
//0x15be60db0f222e1a,0x5104cc8c49b7945c,
//0x2feb5b524809670e,0x8b2badbf09d80f27,
//0xb7b2d0878174fcc,0x3d230a0ea43efa54,
//0x85bd84875c8f5bf8,0x15e28a5fe3ab076e,
//0xa12df2dd6c91733a,0xa3ea2dee4e4df21d,
//0x0,0x0,
//0x456895c1d95fe234,0xee72b1a21497e77b,
//0x4eb77b48cc5f7038,0x9ad3c105b155ffef,
//0xbdfee891500920c,0x74a170a7a5c21894,
//0x68f65fa05931208c,0x585b4042d008c9da,
//0x2d9eca61806ec2b8,0xb629f1e0c49f2ea1,
//0x264124e8956e50b4,0xc2888147615d3635,
//0x6329b1294c31b280,0x2cfa30e575cad14e,
//0x16dde2bb2b38dcfa,0xaeca82ee463b0b3b,
//0x53b5777af2673ece,0x40b8334c52acec40,
//0x586a99f3e767acc2,0x341943ebf76ef4d4,
//0x1d020c323e384ef6,0xda6bf249e3f913af,
//0x7e2bbd1b7209fc76,0xf691c2ac9633c2e1,
//0x3b4328daab561e42,0x18e3730e82a4259a,
//0x309cc653be568c4e,0x6c4203a927663d0e,
//0x75f4539267096e7a,0x8230b20b33f1da75,
//0x0,0x0,
//0x3904c8d2f5c3d2d6,0x54d2b7c147b9eab0,
//0x8b1c8bd76f237756,0x4d81761ce690153e,
//0xb21843059ae0a580,0x1953c1dda129ff8e,
//0x8a2133f2160fc5ec,0x614a21c3ff3bf28a,
//0xb325fb20e3cc173a,0x35989602b882183a,
//0x13db825792cb2ba,0x2ccb57df19abe7b4,
//0x383970f78cef606c,0x7819e01e5e120d04,
//0x4b053b0413b7ed2a,0xa7cdb8c6809748d7,
//0x7201f3d6e6743ffc,0xf31f0f07c72ea267,
//0xc019b0d37c949a7c,0xea4cceda66075de9,
//0xf91d7801895748aa,0xbe9e791b21beb759,
//0xc12408f605b828c6,0xc68799057facba5d,
//0xf820c024f07bfa10,0x92552ec4381550ed,
//0x4a3883216a9b5f90,0x8b06ef19993caf63,
//0x733c4bf39f588d46,0xdfd458d8de8545d3,
//0x0,0x0,
//0x14e4307f9d1772b6,0x515219ca23f9ce5c,
//0x511e34506522e6ae,0x8247627f48ff1f7f,
//0x45fa042ff8359418,0xd3157bb56b06d123,
//0xe3a3756c6efacfc4,0xf788c793e7244e9f,
//0xf7474513f3edbd72,0xa6dade59c4dd80c3,
//0xb2bd413c0bd8296a,0x75cfa5ecafdb51e0,
//0xa659714396cf5bdc,0x249dbc268c229fbc,
//0x5a70839fc81fb4c0,0xd35f0eb88cae752b,
//0x4e94b3e05508c676,0x820d1772af57bb77,
//0xb6eb7cfad3d526e,0x51186cc7c4516a54,
//0x1f8a87b0302a20d8,0x4a750de7a8a408,
//0xb9d3f6f3a6e57b04,0x24d7c92b6b8a3bb4,
//0xad37c68c3bf209b2,0x7585d0e14873f5e8,
//0xe8cdc2a3c3c79daa,0xa690ab54237524cb,
//0xfc29f2dc5ed0ef1c,0xf7c2b29e008cea97,
//0x0,0x0,
//0xda8e23483a97853a,0x38f065e6ec77c32c,
//0xd1700ce51721220c,0xee558f30070e0c3d,
//0xbfe2fad2db6a736,0xd6a5ead6eb79cf11,
//0x249484a90e31ef88,0xd78f250953e96933,
//0xfe1aa7e134a66ab2,0xef7f40efbf9eaa1f,
//0xf5e4884c1910cd84,0x39daaa3954e7650e,
//0x2f6aab04238748be,0x12acfdfb890a622,
//0x771a1494d77054ac,0xde34b71e0312848f,
//0xad9437dcede7d196,0xe6c4d2f8ef6547a3,
//0xa66a1871c05176a0,0x3061382e041c88b2,
//0x7ce43b39fac6f39a,0x8915dc8e86b4b9e,
//0x538e903dd941bb24,0x9bb921750fbedbc,
//0x8900b375e3d63e1e,0x314bf7f1bc8c2e90,
//0x82fe9cd8ce609928,0xe7ee1d2757f5e181,
//0x5870bf90f4f71c12,0xdf1e78c1bb8222ad,
//0x0,0x0,
//0x27f349141093e620,0x97e14e9448decae7,
//0x8da828e52be94d70,0x928de3c8e22c0f1d,
//0xaa5b61f13b7aab50,0x56cad5caaf2c5fa,
//0xc1e9db8ac9f1c256,0xba586143dfe63deb,
//0xe61a929ed9622476,0x2db92fd79738f70c,
//0x4c41f36fe2188f26,0x28d5828b3dca32f6,
//0x6bb2ba7bf28b6906,0xbf34cc1f7514f811,
//0xd9b45813424b2b38,0xb2052ca6fb35eaa9,
//0xfe47110752d8cd18,0x25e46232b3eb204e,
//0x541c70f669a26648,0x2088cf6e1919e5b4,
//0x73ef39e279318068,0xb76981fa51c72f53,
//0x185d83998bbae96e,0x85d4de524d3d742,
//0x3faeca8d9b290f4e,0x9fbc03716c0d1da5,
//0x95f5ab7ca053a41e,0x9ad0ae2dc6ffd85f,
//0xb206e268b0c0423e,0xd31e0b98e2112b8,
//0x0,0x0,
//0x10f28ab6172a4efa,0x794a2a7c84a76d2c,
//0x213491af2f858c38,0xa3fb2735d34fbaa7,
//0x31c61b1938afc2c2,0xdab10d4957e8d78b,
//0xdd93cc151a20dcda,0xfa7ca4a3574c6525,
//0xcd6146a30d0a9220,0x83368edfd3eb0809,
//0xfca75dba35a550e2,0x598783968403df82,
//0xec55d70c228f1e18,0x20cda9ea00a4b2ae,
//0x3190a2225ab65e2c,0xff5e390da90f4835,
//0x216228944d9c10d6,0x861413712da82519,
//0x10a4338d7533d214,0x5ca51e387a40f292,
//0x56b93b62199cee,0x25ef3444fee79fbe,
//0xec036e37409682f6,0x5229daefe432d10,
//0xfcf1e48157bccc0c,0x7c68b7d27ae4403c,
//0xcd37ff986f130ece,0xa6d9ba9b2d0c97b7,
//0xddc5752e78394034,0xdf9390e7a9abfa9b,
//0x0,0x0,
//0x71389b2a8246f5e4,0xd79573b001f21771,
//0x6ae0532ae2bbfb90,0xdfd3122b95e92c4f,
//0x1bd8c80060fd0e74,0x846619b941b3b3e,
//0xcd6b22d4c21c7758,0x59ee81e35141d3cc,
//0xbc53b9fe405a82bc,0x8e7bf25350b3c4bd,
//0xa78b71fe20a78cc8,0x863d93c8c4a8ff83,
//0xd6b3ead4a2e1792c,0x51a8e078c55ae8f2,
//0x85e338536eb1bbc,0xca785a7f809253d7,
//0x7966a8afb4adee58,0x1ded29cf816044a6,
//0x62be60afd450e02c,0x15ab4854157b7f98,
//0x1386fb85561615c8,0xc23e3be4148968e9,
//0xc5351151f4f76ce4,0x9396db9cd1d3801b,
//0xb40d8a7b76b19900,0x4403a82cd021976a,
//0xafd5427b164c9774,0x4c45c9b7443aac54,
//0xdeedd951940a6290,0x9bd0ba0745c8bb25,
//0x0,0x0,
//0xa602f3fd08bbca2a,0x3cf77b9a1ded625a,
//0x9cfb59155f2c296a,0xc74456a7f1e3b58b,
//0x3af9aae85797e340,0xfbb32d3dec0ed7d1,
//0xbc92de7f7ebfd6c4,0x38ff17882d7d411c,
//0x1a902d8276041cee,0x4086c1230902346,
//0x2069876a2193ffae,0xffbb412fdc9ef497,
//0x866b749729283584,0xc34c3ab5c17396cd,
//0x49dd31700df81d26,0x6daab92652394278,
//0xefdfc28d0543d70c,0x515dc2bc4fd42022,
//0xd526686552d4344c,0xaaeeef81a3daf7f3,
//0x73249b985a6ffe66,0x9619941bbe3795a9,
//0xf54fef0f7347cbe2,0x5555aeae7f440364,
//0x534d1cf27bfc01c8,0x69a2d53462a9613e,
//0x69b4b61a2c6be288,0x9211f8098ea7b6ef,
//0xcfb645e724d028a2,0xaee68393934ad4b5,
//0x0,0x0,
//0x3b8f902c0a858e4e,0x8b95b6a7427690cb,
//0xd525a8185f8af324,0xf31f1e9daabbff9f,
//0xeeaa3834550f7d6a,0x788aa83ae8cd6f54,
//0x17f87f09bc736f26,0xfafd49e2ee8251e9,
//0x2c77ef25b6f6e168,0x7168ff45acf4c122,
//0xc2ddd711e3f99c02,0x9e2577f4439ae76,
//0xf952473de97c124c,0x8277e1d8064f3ebd,
//0xae5fb3551c95931e,0x1863362e3ae97756,
//0x95d0237916101d50,0x93f68089789fe79d,
//0x7b7a1b4d431f603a,0xeb7c28b3905288c9,
//0x40f58b61499aee74,0x60e99e14d2241802,
//0xb9a7cc5ca0e6fc38,0xe29e7fccd46b26bf,
//0x82285c70aa637276,0x690bc96b961db674,
//0x6c826444ff6c0f1c,0x118161517ed0d920,
//0x570df468f5e98152,0x9a14d7f63ca649eb,
//0x0,0x0,
//0x9b8f8f876479058e,0xcad343e8080cba83,
//0x51bbcc440c472768,0xf2e5a279864a60f5,
//0xca3443c3683e22e6,0x3836e1918e46da76,
//0x6340402c3f7ffebe,0xb70b9103d1cd6617,
//0xf8cfcfab5b06fb30,0x7dd8d2ebd9c1dc94,
//0x32fb8c683338d9d6,0x45ee337a578706e2,
//0xa97403ef5741dc58,0x8f3d70925f8bbc61,
//0xdeb9ef235f15ff90,0xb7959b94e1e22d49,
//0x453660a43b6cfa1e,0x7d46d87ce9ee97ca,
//0x8f0223675352d8f8,0x457039ed67a84dbc,
//0x148dace0372bdd76,0x8fa37a056fa4f73f,
//0xbdf9af0f606a012e,0x9e0a97302f4b5e,
//0x26762088041304a0,0xca4d497f3823f1dd,
//0xec42634b6c2d2646,0xf27ba8eeb6652bab,
//0x77cdeccc085423c8,0x38a8eb06be699128,
//0x0,0x0,
//0x5a9d3675a3531196,0x3524ce9c7f7b56e2,
//0xce10620e568164c2,0x8ef7ee5cecdb882d,
//0x948d547bf5d27554,0xbbd320c093a0decf,
//0x854d0fea22c345b2,0xda3844c594d764bf,
//0xdfd0399f81905424,0xef1c8a59ebac325d,
//0x4b5d6de474422170,0x54cfaa99780cec92,
//0x11c05b91d71130e6,0x61eb64050777ba70,
//0x16c016c2d631ae74,0xf2328df87cdf3e71,
//0x4c5d20b77562bfe2,0xc716436403a46893,
//0xd8d074cc80b0cab6,0x7cc563a49004b65c,
//0x824d42b923e3db20,0x49e1ad38ef7fe0be,
//0x938d1928f4f2ebc6,0x280ac93de8085ace,
//0xc9102f5d57a1fa50,0x1d2e07a197730c2c,
//0x5d9d7b26a2738f04,0xa6fd276104d3d2e3,
//0x7004d5301209e92,0x93d9e9fd7ba88401,
//0x0,0x0,
//0x3a9122c15f3ab78,0x9eb8b35a2448eeff,
//0x4ac1ab2d94aa463e,0x3c449b0a0456c972,
//0x4968b9018159ed46,0xa2fc2850201e278d,
//0x70d846ae38ffb938,0x6cddd4542b3a7254,
//0x737154822d0c1240,0xf265670e0f729cab,
//0x3a19ed83ac55ff06,0x50994f5e2f6cbb26,
//0x39b0ffafb9a6547e,0xce21fc040b2455d9,
//0x3f1ab33bdd022656,0xee26c355dcac88cf,
//0x3cb3a117c8f18d2e,0x709e700ff8e46630,
//0x75db181649a86068,0xd262585fd8fa41bd,
//0x76720a3a5c5bcb10,0x4cdaeb05fcb2af42,
//0x4fc2f595e5fd9f6e,0x82fb1701f796fa9b,
//0x4c6be7b9f00e3416,0x1c43a45bd3de1464,
//0x5035eb87157d950,0xbebf8c0bf3c033e9,
//0x6aa4c9464a47228,0x20073f51d788dd16,
//0x0,0x0,
//0xa2def1742f3b5916,0x55fe928ccc907446,
//0xc0536b0be526eb6,0xce0290a08ea7ed67,
//0xaedbc7c4916937a0,0x9bfc022c42379921,
//0x63118f8310afbd9c,0xf3bfe1a1625671ef,
//0xc1cf7ef73f94e48a,0xa641732daec605a9,
//0x6f14b933aefdd32a,0x3dbd7101ecf19c88,
//0xcdca484781c68a3c,0x6843e38d2061e8ce,
//0x5c5ad70dd7f32ae,0xfbdcaf23d12e7a5d,
//0xa71b5c04f2446bb8,0xae223daf1dbe0e1b,
//0x9c09bc0632d5c18,0x35de3f835f89973a,
//0xab1e6ab44c16050e,0x6020ad0f9319e37c,
//0x66d422f3cdd08f32,0x8634e82b3780bb2,
//0xc40ad387e2ebd624,0x5d9ddc0e7fe87ff4,
//0x6ad114437382e184,0xc661de223ddfe6d5,
//0xc80fe5375cb9b892,0x939f4caef14f9293,
//0x0,0x0,
//0x2cd73c266f68da36,0x9bfcfcadd6ed8b57,
//0x6d8e1fe42b061d44,0x3db9c6976df592a6,
//0x415923c2446ec772,0xa6453a3abb1819f1,
//0x80ca05549a4dc27c,0xc75a42071ff8895d,
//0xac1d3972f525184a,0x5ca6beaac915020a,
//0xed441ab0b14bdf38,0xfae38490720d1bfb,
//0xc1932696de23050e,0x611f783da4e090ac,
//0xd1fbff53b9e5b9a0,0x11f736abdbe2672a,
//0xfd2cc375d68d6396,0x8a0bca060d0fec7d,
//0xbc75e0b792e3a4e4,0x2c4ef03cb617f58c,
//0x90a2dc91fd8b7ed2,0xb7b20c9160fa7edb,
//0x5131fa0723a87bdc,0xd6ad74acc41aee77,
//0x7de6c6214cc0a1ea,0x4d51880112f76520,
//0x3cbfe5e308ae6698,0xeb14b23ba9ef7cd1,
//0x1068d9c567c6bcae,0x70e84e967f02f786,
//0x0,0x0,
//0xc1ca004429d1c70c,0x83670004dbe27f63,
//0x7ade7ba41da719e2,0x75ff5173392ad2ea,
//0xbb147be03476deee,0xf6985177e2c8ad89,
//0x2da0b1432202bae2,0xc33784b9b478b88b,
//0xec6ab1070bd37dee,0x405084bd6f9ac7e8,
//0x577ecae73fa5a300,0xb6c8d5ca8d526a61,
//0x96b4caa31674640c,0x35afd5ce56b01502,
//0x88cc8045cdff4040,0x39324dfdad64aa8e,
//0x49068001e42e874c,0xba554df97686d5ed,
//0xf212fbe1d05859a2,0x4ccd1c8e944e7864,
//0x33d8fba5f9899eae,0xcfaa1c8a4fac0707,
//0xa56c3106effdfaa2,0xfa05c944191c1205,
//0x64a63142c62c3dae,0x7962c940c2fe6d66,
//0xdfb24aa2f25ae340,0x8ffa98372036c0ef,
//0x1e784ae6db8b244c,0xc9d9833fbd4bf8c,
//0x0,0x0,
//0xd1537109b42cc8a0,0x8b6232e621520ca1,
//0xc5585ec70c29b8f0,0x961f8facdb0ea92d,
//0x140b2fceb8057050,0x1d7dbd4afa5ca58c,
//0x641e0bbe37274246,0x38e42a8ae4b60f8e,
//0xb54d7ab7830b8ae6,0xb386186cc5e4032f,
//0xa14655793b0efab6,0xaefba5263fb8a6a3,
//0x701524708f223216,0x259997c01eeaaa02,
//0xb1f69a8517d41456,0xc70e543a5a80f74b,
//0x60a5eb8ca3f8dcf6,0x4c6c66dc7bd2fbea,
//0x74aec4421bfdaca6,0x5111db96818e5e66,
//0xa5fdb54bafd16406,0xda73e970a0dc52c7,
//0xd5e8913b20f35610,0xffea7eb0be36f8c5,
//0x4bbe03294df9eb0,0x74884c569f64f464,
//0x10b0cffc2cdaeee0,0x69f5f11c653851e8,
//0xc1e3bef598f62640,0xe297c3fa446a5d49,
//0x0,0x0,
//0xbccf8ca839bfe3a8,0x38bd7652fbb4463c,
//0xc4fab69066e3433a,0xefa5f7ca9f6294c1,
//0x78353a385f5ca092,0xd718819864d6d2fd,
//0xb54afad4cd1155a8,0x31317c030896c74a,
//0x985767cf4aeb600,0x98c0a51f3228176,
//0x71b04c44abf21692,0xde948bc997f4538b,
//0xcd7fc0ec924df53a,0xe629fd9b6c4015b7,
//0x7d4bba2cbae355d4,0xd5fb04e16da98b6,
//0xc1843684835cb67c,0x35e2c61ced6ede8a,
//0xb9b10cbcdc0016ee,0xe2fa478489b80c77,
//0x57e8014e5bff546,0xda4731d6720c4a4b,
//0xc80140f877f2007c,0x3c6ecc4d1e4c5ffc,
//0x74cecc504e4de3d4,0x4d3ba1fe5f819c0,
//0xcfbf66811114346,0xd3cb3b87812ecb3d,
//0xb0347ac028aea0ee,0xeb764dd57a9a8d01,
//0x0,0x0,
//0xfd2b185552fcca1e,0xaf27a2c3c9af3b15,
//0xa74e3032c1c70940,0xb22c87060644347d,
//0x5a652867933bc35e,0x1d0b25c5cfeb0f68,
//0x96784c18fa9a222c,0x9f1317dd9bd62b2b,
//0x6b53544da866e832,0x3034b51e5279103e,
//0x31367c2a3b5d2b6c,0x2d3f90db9d921f56,
//0xcc1d647f69a1e172,0x82183218543d2443,
//0xa055412a1255732c,0x9675e5102f20a86d,
//0x5d7e597f40a9b932,0x395247d3e68f9378,
//0x71b7118d3927a6c,0x2459621629649c10,
//0xfa30694d816eb072,0x8b7ec0d5e0cba705,
//0x362d0d32e8cf5100,0x966f2cdb4f68346,
//0xcb061567ba339b1e,0xa641500e7d59b853,
//0x91633d0029085840,0xbb4a75cbb2b2b73b,
//0x6c4825557bf4925e,0x146dd7087b1d8c2e,
//0x0,0x0,
//0xbd9e54181b305f0,0x1196f9167176350a,
//0x2de9c7568ec18048,0x4c7d6f6a66426bc8,
//0x263022170f7285b8,0x5deb967c17345ec2,
//0xf69478d0555733be,0x2cf2076679e35cae,
//0xfd4d9d91d4e4364e,0x3d64fe70089569a4,
//0xdb7dbf86db96b3f6,0x608f680c1fa13766,
//0xd0a45ac75a25b606,0x7119911a6ed7026c,
//0xa0dea3eaee857928,0xeff27f24fdcf1cb1,
//0xab0746ab6f367cd8,0xfe6486328cb929bb,
//0x8d3764bc6044f960,0xa38f104e9b8d7779,
//0x86ee81fde1f7fc90,0xb219e958eafb4273,
//0x564adb3abbd24a96,0xc3007842842c401f,
//0x5d933e7b3a614f66,0xd2968154f55a7515,
//0x7ba31c6c3513cade,0x8f7d1728e26e2bd7,
//0x707af92db4a0cf2e,0x9eebee3e93181edd,
//0x0,0x0,
//0x22de535186312472,0xb2c39cca82539e4d,
//0x1c881e66c80d1a94,0x79ffdc889d966bb8,
//0x3e564d374e3c3ee6,0xcb3c40421fc5f5f5,
//0x34209cfccf813712,0xa2dacc7d457cfcd7,
//0x16fecfad49b01360,0x101950b7c72f629a,
//0x28a8829a078c2d86,0xdb2510f5d8ea976f,
//0xa76d1cb81bd09f4,0x69e68c3f5ab90922,
//0xdbfa17232ffaa1aa,0x9d8978748ea31b83,
//0xf9244472a9cb85d8,0x2f4ae4be0cf085ce,
//0xc7720945e7f7bb3e,0xe476a4fc1335703b,
//0xe5ac5a1461c69f4c,0x56b538369166ee76,
//0xefda8bdfe07b96b8,0x3f53b409cbdfe754,
//0xcd04d88e664ab2ca,0x8d9028c3498c7919,
//0xf35295b928768c2c,0x46ac688156498cec,
//0xd18cc6e8ae47a85e,0xf46ff44bd41a12a1,
//};
//
//


alignas(32) const uint64_t gfCantorto2128_8R[2*(8*256)] = {
0x0,0x0,
0x1,0x0,
0x676aac9fa4b20b08,0x295ac0b1f4731af9,
0x676aac9fa4b20b09,0x295ac0b1f4731af9,
0xff1099c31bbe8f22,0xa2134422cd4054c9,
0xff1099c31bbe8f23,0xa2134422cd4054c9,
0x987a355cbf0c842a,0x8b49849339334e30,
0x987a355cbf0c842b,0x8b49849339334e30,
0x53b85b6402b1e848,0x7959d70ce1ee6942,
0x53b85b6402b1e849,0x7959d70ce1ee6942,
0x34d2f7fba603e340,0x500317bd159d73bb,
0x34d2f7fba603e341,0x500317bd159d73bb,
0xaca8c2a7190f676a,0xdb4a932e2cae3d8b,
0xaca8c2a7190f676b,0xdb4a932e2cae3d8b,
0xcbc26e38bdbd6c62,0xf210539fd8dd2772,
0xcbc26e38bdbd6c63,0xf210539fd8dd2772,
0xcabcd8e4694e5644,0x8f6b313e935b8e2,
0xcabcd8e4694e5645,0x8f6b313e935b8e2,
0xadd6747bcdfc5d4c,0x21ac73a21d46a21b,
0xadd6747bcdfc5d4d,0x21ac73a21d46a21b,
0x35ac412772f0d966,0xaae5f7312475ec2b,
0x35ac412772f0d967,0xaae5f7312475ec2b,
0x52c6edb8d642d26e,0x83bf3780d006f6d2,
0x52c6edb8d642d26f,0x83bf3780d006f6d2,
0x990483806bffbe0c,0x71af641f08dbd1a0,
0x990483806bffbe0d,0x71af641f08dbd1a0,
0xfe6e2f1fcf4db504,0x58f5a4aefca8cb59,
0xfe6e2f1fcf4db505,0x58f5a4aefca8cb59,
0x66141a437041312e,0xd3bc203dc59b8569,
0x66141a437041312f,0xd3bc203dc59b8569,
0x17eb6dcd4f33a26,0xfae6e08c31e89f90,
0x17eb6dcd4f33a27,0xfae6e08c31e89f90,
0x4d48b16661e860ec,0x49c9321635282198,
0x4d48b16661e860ed,0x49c9321635282198,
0x2a221df9c55a6be4,0x6093f2a7c15b3b61,
0x2a221df9c55a6be5,0x6093f2a7c15b3b61,
0xb25828a57a56efce,0xebda7634f8687551,
0xb25828a57a56efcf,0xebda7634f8687551,
0xd532843adee4e4c6,0xc280b6850c1b6fa8,
0xd532843adee4e4c7,0xc280b6850c1b6fa8,
0x1ef0ea02635988a4,0x3090e51ad4c648da,
0x1ef0ea02635988a5,0x3090e51ad4c648da,
0x799a469dc7eb83ac,0x19ca25ab20b55223,
0x799a469dc7eb83ad,0x19ca25ab20b55223,
0xe1e073c178e70786,0x9283a13819861c13,
0xe1e073c178e70787,0x9283a13819861c13,
0x868adf5edc550c8e,0xbbd96189edf506ea,
0x868adf5edc550c8f,0xbbd96189edf506ea,
0x87f4698208a636a8,0x413f8105dc1d997a,
0x87f4698208a636a9,0x413f8105dc1d997a,
0xe09ec51dac143da0,0x686541b4286e8383,
0xe09ec51dac143da1,0x686541b4286e8383,
0x78e4f0411318b98a,0xe32cc527115dcdb3,
0x78e4f0411318b98b,0xe32cc527115dcdb3,
0x1f8e5cdeb7aab282,0xca760596e52ed74a,
0x1f8e5cdeb7aab283,0xca760596e52ed74a,
0xd44c32e60a17dee0,0x386656093df3f038,
0xd44c32e60a17dee1,0x386656093df3f038,
0xb3269e79aea5d5e8,0x113c96b8c980eac1,
0xb3269e79aea5d5e9,0x113c96b8c980eac1,
0x2b5cab2511a951c2,0x9a75122bf0b3a4f1,
0x2b5cab2511a951c3,0x9a75122bf0b3a4f1,
0x4c3607bab51b5aca,0xb32fd29a04c0be08,
0x4c3607bab51b5acb,0xb32fd29a04c0be08,
0xa13fe8ac5560ce0c,0x53d8555a9979a1c,
0xa13fe8ac5560ce0d,0x53d8555a9979a1c,
0xc6554433f1d2c504,0x2c6745e45de480e5,
0xc6554433f1d2c505,0x2c6745e45de480e5,
0x5e2f716f4ede412e,0xa72ec17764d7ced5,
0x5e2f716f4ede412f,0xa72ec17764d7ced5,
0x3945ddf0ea6c4a26,0x8e7401c690a4d42c,
0x3945ddf0ea6c4a27,0x8e7401c690a4d42c,
0xf287b3c857d12644,0x7c6452594879f35e,
0xf287b3c857d12645,0x7c6452594879f35e,
0x95ed1f57f3632d4c,0x553e92e8bc0ae9a7,
0x95ed1f57f3632d4d,0x553e92e8bc0ae9a7,
0xd972a0b4c6fa966,0xde77167b8539a797,
0xd972a0b4c6fa967,0xde77167b8539a797,
0x6afd8694e8dda26e,0xf72dd6ca714abd6e,
0x6afd8694e8dda26f,0xf72dd6ca714abd6e,
0x6b8330483c2e9848,0xdcb364640a222fe,
0x6b8330483c2e9849,0xdcb364640a222fe,
0xce99cd7989c9340,0x2491f6f7b4d13807,
0xce99cd7989c9341,0x2491f6f7b4d13807,
0x9493a98b2790176a,0xafd872648de27637,
0x9493a98b2790176b,0xafd872648de27637,
0xf3f9051483221c62,0x8682b2d579916cce,
0xf3f9051483221c63,0x8682b2d579916cce,
0x383b6b2c3e9f7000,0x7492e14aa14c4bbc,
0x383b6b2c3e9f7001,0x7492e14aa14c4bbc,
0x5f51c7b39a2d7b08,0x5dc821fb553f5145,
0x5f51c7b39a2d7b09,0x5dc821fb553f5145,
0xc72bf2ef2521ff22,0xd681a5686c0c1f75,
0xc72bf2ef2521ff23,0xd681a5686c0c1f75,
0xa0415e708193f42a,0xffdb65d9987f058c,
0xa0415e708193f42b,0xffdb65d9987f058c,
0xec7759ca3488aee0,0x4cf4b7439cbfbb84,
0xec7759ca3488aee1,0x4cf4b7439cbfbb84,
0x8b1df555903aa5e8,0x65ae77f268cca17d,
0x8b1df555903aa5e9,0x65ae77f268cca17d,
0x1367c0092f3621c2,0xeee7f36151ffef4d,
0x1367c0092f3621c3,0xeee7f36151ffef4d,
0x740d6c968b842aca,0xc7bd33d0a58cf5b4,
0x740d6c968b842acb,0xc7bd33d0a58cf5b4,
0xbfcf02ae363946a8,0x35ad604f7d51d2c6,
0xbfcf02ae363946a9,0x35ad604f7d51d2c6,
0xd8a5ae31928b4da0,0x1cf7a0fe8922c83f,
0xd8a5ae31928b4da1,0x1cf7a0fe8922c83f,
0x40df9b6d2d87c98a,0x97be246db011860f,
0x40df9b6d2d87c98b,0x97be246db011860f,
0x27b537f28935c282,0xbee4e4dc44629cf6,
0x27b537f28935c283,0xbee4e4dc44629cf6,
0x26cb812e5dc6f8a4,0x44020450758a0366,
0x26cb812e5dc6f8a5,0x44020450758a0366,
0x41a12db1f974f3ac,0x6d58c4e181f9199f,
0x41a12db1f974f3ad,0x6d58c4e181f9199f,
0xd9db18ed46787786,0xe6114072b8ca57af,
0xd9db18ed46787787,0xe6114072b8ca57af,
0xbeb1b472e2ca7c8e,0xcf4b80c34cb94d56,
0xbeb1b472e2ca7c8f,0xcf4b80c34cb94d56,
0x7573da4a5f7710ec,0x3d5bd35c94646a24,
0x7573da4a5f7710ed,0x3d5bd35c94646a24,
0x121976d5fbc51be4,0x140113ed601770dd,
0x121976d5fbc51be5,0x140113ed601770dd,
0x8a63438944c99fce,0x9f48977e59243eed,
0x8a63438944c99fcf,0x9f48977e59243eed,
0xed09ef16e07b94c6,0xb61257cfad572414,
0xed09ef16e07b94c7,0xb61257cfad572414,
0x5cb10fbabcf00118,0x4d52354a3a3d8c86,
0x5cb10fbabcf00119,0x4d52354a3a3d8c86,
0x3bdba32518420a10,0x6408f5fbce4e967f,
0x3bdba32518420a11,0x6408f5fbce4e967f,
0xa3a19679a74e8e3a,0xef417168f77dd84f,
0xa3a19679a74e8e3b,0xef417168f77dd84f,
0xc4cb3ae603fc8532,0xc61bb1d9030ec2b6,
0xc4cb3ae603fc8533,0xc61bb1d9030ec2b6,
0xf0954debe41e950,0x340be246dbd3e5c4,
0xf0954debe41e951,0x340be246dbd3e5c4,
0x6863f8411af3e258,0x1d5122f72fa0ff3d,
0x6863f8411af3e259,0x1d5122f72fa0ff3d,
0xf019cd1da5ff6672,0x9618a6641693b10d,
0xf019cd1da5ff6673,0x9618a6641693b10d,
0x97736182014d6d7a,0xbf4266d5e2e0abf4,
0x97736182014d6d7b,0xbf4266d5e2e0abf4,
0x960dd75ed5be575c,0x45a48659d3083464,
0x960dd75ed5be575d,0x45a48659d3083464,
0xf1677bc1710c5c54,0x6cfe46e8277b2e9d,
0xf1677bc1710c5c55,0x6cfe46e8277b2e9d,
0x691d4e9dce00d87e,0xe7b7c27b1e4860ad,
0x691d4e9dce00d87f,0xe7b7c27b1e4860ad,
0xe77e2026ab2d376,0xceed02caea3b7a54,
0xe77e2026ab2d377,0xceed02caea3b7a54,
0xc5b58c3ad70fbf14,0x3cfd515532e65d26,
0xc5b58c3ad70fbf15,0x3cfd515532e65d26,
0xa2df20a573bdb41c,0x15a791e4c69547df,
0xa2df20a573bdb41d,0x15a791e4c69547df,
0x3aa515f9ccb13036,0x9eee1577ffa609ef,
0x3aa515f9ccb13037,0x9eee1577ffa609ef,
0x5dcfb96668033b3e,0xb7b4d5c60bd51316,
0x5dcfb96668033b3f,0xb7b4d5c60bd51316,
0x11f9bedcdd1861f4,0x49b075c0f15ad1e,
0x11f9bedcdd1861f5,0x49b075c0f15ad1e,
0x7693124379aa6afc,0x2dc1c7edfb66b7e7,
0x7693124379aa6afd,0x2dc1c7edfb66b7e7,
0xeee9271fc6a6eed6,0xa688437ec255f9d7,
0xeee9271fc6a6eed7,0xa688437ec255f9d7,
0x89838b806214e5de,0x8fd283cf3626e32e,
0x89838b806214e5df,0x8fd283cf3626e32e,
0x4241e5b8dfa989bc,0x7dc2d050eefbc45c,
0x4241e5b8dfa989bd,0x7dc2d050eefbc45c,
0x252b49277b1b82b4,0x549810e11a88dea5,
0x252b49277b1b82b5,0x549810e11a88dea5,
0xbd517c7bc417069e,0xdfd1947223bb9095,
0xbd517c7bc417069f,0xdfd1947223bb9095,
0xda3bd0e460a50d96,0xf68b54c3d7c88a6c,
0xda3bd0e460a50d97,0xf68b54c3d7c88a6c,
0xdb456638b45637b0,0xc6db44fe62015fc,
0xdb456638b45637b1,0xc6db44fe62015fc,
0xbc2fcaa710e43cb8,0x253774fe12530f05,
0xbc2fcaa710e43cb9,0x253774fe12530f05,
0x2455fffbafe8b892,0xae7ef06d2b604135,
0x2455fffbafe8b893,0xae7ef06d2b604135,
0x433f53640b5ab39a,0x872430dcdf135bcc,
0x433f53640b5ab39b,0x872430dcdf135bcc,
0x88fd3d5cb6e7dff8,0x7534634307ce7cbe,
0x88fd3d5cb6e7dff9,0x7534634307ce7cbe,
0xef9791c31255d4f0,0x5c6ea3f2f3bd6647,
0xef9791c31255d4f1,0x5c6ea3f2f3bd6647,
0x77eda49fad5950da,0xd7272761ca8e2877,
0x77eda49fad5950db,0xd7272761ca8e2877,
0x1087080009eb5bd2,0xfe7de7d03efd328e,
0x1087080009eb5bd3,0xfe7de7d03efd328e,
0xfd8ee716e990cf14,0x486fb01f93aa169a,
0xfd8ee716e990cf15,0x486fb01f93aa169a,
0x9ae44b894d22c41c,0x613570ae67d90c63,
0x9ae44b894d22c41d,0x613570ae67d90c63,
0x29e7ed5f22e4036,0xea7cf43d5eea4253,
0x29e7ed5f22e4037,0xea7cf43d5eea4253,
0x65f4d24a569c4b3e,0xc326348caa9958aa,
0x65f4d24a569c4b3f,0xc326348caa9958aa,
0xae36bc72eb21275c,0x3136671372447fd8,
0xae36bc72eb21275d,0x3136671372447fd8,
0xc95c10ed4f932c54,0x186ca7a286376521,
0xc95c10ed4f932c55,0x186ca7a286376521,
0x512625b1f09fa87e,0x93252331bf042b11,
0x512625b1f09fa87f,0x93252331bf042b11,
0x364c892e542da376,0xba7fe3804b7731e8,
0x364c892e542da377,0xba7fe3804b7731e8,
0x37323ff280de9950,0x4099030c7a9fae78,
0x37323ff280de9951,0x4099030c7a9fae78,
0x5058936d246c9258,0x69c3c3bd8eecb481,
0x5058936d246c9259,0x69c3c3bd8eecb481,
0xc822a6319b601672,0xe28a472eb7dffab1,
0xc822a6319b601673,0xe28a472eb7dffab1,
0xaf480aae3fd21d7a,0xcbd0879f43ace048,
0xaf480aae3fd21d7b,0xcbd0879f43ace048,
0x648a6496826f7118,0x39c0d4009b71c73a,
0x648a6496826f7119,0x39c0d4009b71c73a,
0x3e0c80926dd7a10,0x109a14b16f02ddc3,
0x3e0c80926dd7a11,0x109a14b16f02ddc3,
0x9b9afd5599d1fe3a,0x9bd39022563193f3,
0x9b9afd5599d1fe3b,0x9bd39022563193f3,
0xfcf051ca3d63f532,0xb2895093a242890a,
0xfcf051ca3d63f533,0xb2895093a242890a,
0xb0c656708878aff8,0x1a68209a6823702,
0xb0c656708878aff9,0x1a68209a6823702,
0xd7acfaef2ccaa4f0,0x28fc42b852f12dfb,
0xd7acfaef2ccaa4f1,0x28fc42b852f12dfb,
0x4fd6cfb393c620da,0xa3b5c62b6bc263cb,
0x4fd6cfb393c620db,0xa3b5c62b6bc263cb,
0x28bc632c37742bd2,0x8aef069a9fb17932,
0x28bc632c37742bd3,0x8aef069a9fb17932,
0xe37e0d148ac947b0,0x78ff5505476c5e40,
0xe37e0d148ac947b1,0x78ff5505476c5e40,
0x8414a18b2e7b4cb8,0x51a595b4b31f44b9,
0x8414a18b2e7b4cb9,0x51a595b4b31f44b9,
0x1c6e94d79177c892,0xdaec11278a2c0a89,
0x1c6e94d79177c893,0xdaec11278a2c0a89,
0x7b04384835c5c39a,0xf3b6d1967e5f1070,
0x7b04384835c5c39b,0xf3b6d1967e5f1070,
0x7a7a8e94e136f9bc,0x950311a4fb78fe0,
0x7a7a8e94e136f9bd,0x950311a4fb78fe0,
0x1d10220b4584f2b4,0x200af1abbbc49519,
0x1d10220b4584f2b5,0x200af1abbbc49519,
0x856a1757fa88769e,0xab43753882f7db29,
0x856a1757fa88769f,0xab43753882f7db29,
0xe200bbc85e3a7d96,0x8219b5897684c1d0,
0xe200bbc85e3a7d97,0x8219b5897684c1d0,
0x29c2d5f0e38711f4,0x7009e616ae59e6a2,
0x29c2d5f0e38711f5,0x7009e616ae59e6a2,
0x4ea8796f47351afc,0x595326a75a2afc5b,
0x4ea8796f47351afd,0x595326a75a2afc5b,
0xd6d24c33f8399ed6,0xd21aa2346319b26b,
0xd6d24c33f8399ed7,0xd21aa2346319b26b,
0xb1b8e0ac5c8b95de,0xfb406285976aa892,
0xb1b8e0ac5c8b95df,0xfb406285976aa892,
0x0,0x0,
0xe18c55b8e07d3612,0x2ccae6ed8d6b4cd0,
0x588b6244c5d74470,0x210d8fbe72672c66,
0xb90737fc25aa7262,0xdc76953ff0c60b6,
0xd047dada84654da4,0xc211182c85e148b3,
0x31cb8f6264187bb6,0xeedbfec1088a0463,
0x88ccb89e41b209d4,0xe31c9792f78664d5,
0x6940ed26a1cf3fc6,0xcfd6717f7aed2805,
0xfed3b473eeb39df8,0x104d101e47f1f112,
0x1f5fe1cb0eceabea,0x3c87f6f3ca9abdc2,
0xa658d6372b64d988,0x31409fa03596dd74,
0x47d4838fcb19ef9a,0x1d8a794db8fd91a4,
0x2e946ea96ad6d05c,0xd25c0832c210b9a1,
0xcf183b118aabe64e,0xfe96eedf4f7bf571,
0x761f0cedaf01942c,0xf351878cb07795c7,
0x979359554f7ca23e,0xdf9b61613d1cd917,
0xbf199eb4f675f2ac,0xce955ea0da2a682b,
0x5e95cb0c1608c4be,0xe25fb84d574124fb,
0xe792fcf033a2b6dc,0xef98d11ea84d444d,
0x61ea948d3df80ce,0xc35237f32526089d,
0x6f5e446e7210bf08,0xc84468c5fcb2098,
0x8ed211d6926d891a,0x204ea061d2a06c48,
0x37d5262ab7c7fb78,0x2d89c9322dac0cfe,
0xd659739257bacd6a,0x1432fdfa0c7402e,
0x41ca2ac718c66f54,0xded84ebe9ddb9939,
0xa0467f7ff8bb5946,0xf212a85310b0d5e9,
0x19414883dd112b24,0xffd5c100efbcb55f,
0xf8cd1d3b3d6c1d36,0xd31f27ed62d7f98f,
0x918df01d9ca322f0,0x1cc95692183ad18a,
0x7001a5a57cde14e2,0x3003b07f95519d5a,
0xc906925959746680,0x3dc4d92c6a5dfdec,
0x288ac7e1b9095092,0x110e3fc1e736b13c,
0x19c55b8d6bef4c98,0xdbacfb2ac336178f,
0xf8490e358b927a8a,0xf7661dc74e5d5b5f,
0x414e39c9ae3808e8,0xfaa17494b1513be9,
0xa0c26c714e453efa,0xd66b92793c3a7739,
0xc9828157ef8a013c,0x19bde30646d75f3c,
0x280ed4ef0ff7372e,0x357705ebcbbc13ec,
0x9109e3132a5d454c,0x38b06cb834b0735a,
0x7085b6abca20735e,0x147a8a55b9db3f8a,
0xe716effe855cd160,0xcbe1eb3484c7e69d,
0x69aba466521e772,0xe72b0dd909acaa4d,
0xbf9d8dba408b9510,0xeaec648af6a0cafb,
0x5e11d802a0f6a302,0xc62682677bcb862b,
0x3751352401399cc4,0x9f0f3180126ae2e,
0xd6dd609ce144aad6,0x253a15f58c4de2fe,
0x6fda5760c4eed8b4,0x28fd7ca673418248,
0x8e5602d82493eea6,0x4379a4bfe2ace98,
0xa6dcc5399d9abe34,0x1539a58a191c7fa4,
0x475090817de78826,0x39f3436794773374,
0xfe57a77d584dfa44,0x34342a346b7b53c2,
0x1fdbf2c5b830cc56,0x18feccd9e6101f12,
0x769b1fe319fff390,0xd728bda69cfd3717,
0x97174a5bf982c582,0xfbe25b4b11967bc7,
0x2e107da7dc28b7e0,0xf6253218ee9a1b71,
0xcf9c281f3c5581f2,0xdaefd4f563f157a1,
0x580f714a732923cc,0x574b5945eed8eb6,
0xb98324f2935415de,0x29be5379d386c266,
0x84130eb6fe67bc,0x24793a2a2c8aa2d0,
0xe10846b6568351ae,0x8b3dcc7a1e1ee00,
0x8848ab90f74c6e68,0xc765adb8db0cc605,
0x69c4fe281731587a,0xebaf4b5556678ad5,
0xd0c3c9d4329b2a18,0xe6682206a96bea63,
0x314f9c6cd2e61c0a,0xcaa2c4eb2400a6b3,
0xf5531b28858156d0,0x58770bc4e101ab94,
0x14df4e9065fc60c2,0x74bded296c6ae744,
0xadd8796c405612a0,0x797a847a936687f2,
0x4c542cd4a02b24b2,0x55b062971e0dcb22,
0x2514c1f201e41b74,0x9a6613e864e0e327,
0xc498944ae1992d66,0xb6acf505e98baff7,
0x7d9fa3b6c4335f04,0xbb6b9c561687cf41,
0x9c13f60e244e6916,0x97a17abb9bec8391,
0xb80af5b6b32cb28,0x483a1bdaa6f05a86,
0xea0cfae38b4ffd3a,0x64f0fd372b9b1656,
0x530bcd1faee58f58,0x69379464d49776e0,
0xb28798a74e98b94a,0x45fd728959fc3a30,
0xdbc77581ef57868c,0x8a2b03f623111235,
0x3a4b20390f2ab09e,0xa6e1e51bae7a5ee5,
0x834c17c52a80c2fc,0xab268c4851763e53,
0x62c0427dcafdf4ee,0x87ec6aa5dc1d7283,
0x4a4a859c73f4a47c,0x96e255643b2bc3bf,
0xabc6d0249389926e,0xba28b389b6408f6f,
0x12c1e7d8b623e00c,0xb7efdada494cefd9,
0xf34db260565ed61e,0x9b253c37c427a309,
0x9a0d5f46f791e9d8,0x54f34d48beca8b0c,
0x7b810afe17ecdfca,0x7839aba533a1c7dc,
0xc2863d023246ada8,0x75fec2f6ccada76a,
0x230a68bad23b9bba,0x5934241b41c6ebba,
0xb49931ef9d473984,0x86af457a7cda32ad,
0x551564577d3a0f96,0xaa65a397f1b17e7d,
0xec1253ab58907df4,0xa7a2cac40ebd1ecb,
0xd9e0613b8ed4be6,0x8b682c2983d6521b,
0x64deeb3519227420,0x44be5d56f93b7a1e,
0x8552be8df95f4232,0x6874bbbb745036ce,
0x3c558971dcf53050,0x65b3d2e88b5c5678,
0xddd9dcc93c880642,0x4979340506371aa8,
0xec9640a5ee6e1a48,0x83dbf0ee2237bc1b,
0xd1a151d0e132c5a,0xaf111603af5cf0cb,
0xb41d22e12bb95e38,0xa2d67f505050907d,
0x55917759cbc4682a,0x8e1c99bddd3bdcad,
0x3cd19a7f6a0b57ec,0x41cae8c2a7d6f4a8,
0xdd5dcfc78a7661fe,0x6d000e2f2abdb878,
0x645af83bafdc139c,0x60c7677cd5b1d8ce,
0x85d6ad834fa1258e,0x4c0d819158da941e,
0x1245f4d600dd87b0,0x9396e0f065c64d09,
0xf3c9a16ee0a0b1a2,0xbf5c061de8ad01d9,
0x4ace9692c50ac3c0,0xb29b6f4e17a1616f,
0xab42c32a2577f5d2,0x9e5189a39aca2dbf,
0xc2022e0c84b8ca14,0x5187f8dce02705ba,
0x238e7bb464c5fc06,0x7d4d1e316d4c496a,
0x9a894c48416f8e64,0x708a7762924029dc,
0x7b0519f0a112b876,0x5c40918f1f2b650c,
0x538fde11181be8e4,0x4d4eae4ef81dd430,
0xb2038ba9f866def6,0x618448a3757698e0,
0xb04bc55ddccac94,0x6c4321f08a7af856,
0xea88e9ed3db19a86,0x4089c71d0711b486,
0x83c804cb9c7ea540,0x8f5fb6627dfc9c83,
0x624451737c039352,0xa395508ff097d053,
0xdb43668f59a9e130,0xae5239dc0f9bb0e5,
0x3acf3337b9d4d722,0x8298df3182f0fc35,
0xad5c6a62f6a8751c,0x5d03be50bfec2522,
0x4cd03fda16d5430e,0x71c958bd328769f2,
0xf5d70826337f316c,0x7c0e31eecd8b0944,
0x145b5d9ed302077e,0x50c4d70340e04594,
0x7d1bb0b872cd38b8,0x9f12a67c3a0d6d91,
0x9c97e50092b00eaa,0xb3d84091b7662141,
0x2590d2fcb71a7cc8,0xbe1f29c2486a41f7,
0xc41c874457674ada,0x92d5cf2fc5010d27,
0x8b97b65b221cc4e4,0x497f8adb47e0ae82,
0x6a1be3e3c261f2f6,0x65b56c36ca8be252,
0xd31cd41fe7cb8094,0x68720565358782e4,
0x329081a707b6b686,0x44b8e388b8ecce34,
0x5bd06c81a6798940,0x8b6e92f7c201e631,
0xba5c39394604bf52,0xa7a4741a4f6aaae1,
0x35b0ec563aecd30,0xaa631d49b066ca57,
0xe2d75b7d83d3fb22,0x86a9fba43d0d8687,
0x75440228ccaf591c,0x59329ac500115f90,
0x94c857902cd26f0e,0x75f87c288d7a1340,
0x2dcf606c09781d6c,0x783f157b727673f6,
0xcc4335d4e9052b7e,0x54f5f396ff1d3f26,
0xa503d8f248ca14b8,0x9b2382e985f01723,
0x448f8d4aa8b722aa,0xb7e96404089b5bf3,
0xfd88bab68d1d50c8,0xba2e0d57f7973b45,
0x1c04ef0e6d6066da,0x96e4ebba7afc7795,
0x348e28efd4693648,0x87ead47b9dcac6a9,
0xd5027d573414005a,0xab20329610a18a79,
0x6c054aab11be7238,0xa6e75bc5efadeacf,
0x8d891f13f1c3442a,0x8a2dbd2862c6a61f,
0xe4c9f235500c7bec,0x45fbcc57182b8e1a,
0x545a78db0714dfe,0x69312aba9540c2ca,
0xbc42907195db3f9c,0x64f643e96a4ca27c,
0x5dcec5c975a6098e,0x483ca504e727eeac,
0xca5d9c9c3adaabb0,0x97a7c465da3b37bb,
0x2bd1c924daa79da2,0xbb6d228857507b6b,
0x92d6fed8ff0defc0,0xb6aa4bdba85c1bdd,
0x735aab601f70d9d2,0x9a60ad362537570d,
0x1a1a4646bebfe614,0x55b6dc495fda7f08,
0xfb9613fe5ec2d006,0x797c3aa4d2b133d8,
0x429124027b68a264,0x74bb53f72dbd536e,
0xa31d71ba9b159476,0x5871b51aa0d61fbe,
0x9252edd649f3887c,0x92d371f184d6b90d,
0x73deb86ea98ebe6e,0xbe19971c09bdf5dd,
0xcad98f928c24cc0c,0xb3defe4ff6b1956b,
0x2b55da2a6c59fa1e,0x9f1418a27bdad9bb,
0x4215370ccd96c5d8,0x50c269dd0137f1be,
0xa39962b42debf3ca,0x7c088f308c5cbd6e,
0x1a9e5548084181a8,0x71cfe6637350ddd8,
0xfb1200f0e83cb7ba,0x5d05008efe3b9108,
0x6c8159a5a7401584,0x829e61efc327481f,
0x8d0d0c1d473d2396,0xae5487024e4c04cf,
0x340a3be1629751f4,0xa393ee51b1406479,
0xd5866e5982ea67e6,0x8f5908bc3c2b28a9,
0xbcc6837f23255820,0x408f79c346c600ac,
0x5d4ad6c7c3586e32,0x6c459f2ecbad4c7c,
0xe44de13be6f21c50,0x6182f67d34a12cca,
0x5c1b483068f2a42,0x4d481090b9ca601a,
0x2d4b7362bf867ad0,0x5c462f515efcd126,
0xccc726da5ffb4cc2,0x708cc9bcd3979df6,
0x75c011267a513ea0,0x7d4ba0ef2c9bfd40,
0x944c449e9a2c08b2,0x51814602a1f0b190,
0xfd0ca9b83be33774,0x9e57377ddb1d9995,
0x1c80fc00db9e0166,0xb29dd1905676d545,
0xa587cbfcfe347304,0xbf5ab8c3a97ab5f3,
0x440b9e441e494516,0x93905e2e2411f923,
0xd398c7115135e728,0x4c0b3f4f190d2034,
0x321492a9b148d13a,0x60c1d9a294666ce4,
0x8b13a55594e2a358,0x6d06b0f16b6a0c52,
0x6a9ff0ed749f954a,0x41cc561ce6014082,
0x3df1dcbd550aa8c,0x8e1a27639cec6887,
0xe2534873352d9c9e,0xa2d0c18e11872457,
0x5b547f8f1087eefc,0xaf17a8ddee8b44e1,
0xbad82a37f0fad8ee,0x83dd4e3063e00831,
0x7ec4ad73a79d9234,0x1108811fa6e10516,
0x9f48f8cb47e0a426,0x3dc267f22b8a49c6,
0x264fcf37624ad644,0x30050ea1d4862970,
0xc7c39a8f8237e056,0x1ccfe84c59ed65a0,
0xae8377a923f8df90,0xd319993323004da5,
0x4f0f2211c385e982,0xffd37fdeae6b0175,
0xf60815ede62f9be0,0xf214168d516761c3,
0x178440550652adf2,0xdedef060dc0c2d13,
0x80171900492e0fcc,0x1459101e110f404,
0x619b4cb8a95339de,0x2d8f77ec6c7bb8d4,
0xd89c7b448cf94bbc,0x20481ebf9377d862,
0x39102efc6c847dae,0xc82f8521e1c94b2,
0x5050c3dacd4b4268,0xc354892d64f1bcb7,
0xb1dc96622d36747a,0xef9e6fc0e99af067,
0x8dba19e089c0618,0xe2590693169690d1,
0xe957f426e8e1300a,0xce93e07e9bfddc01,
0xc1dd33c751e86098,0xdf9ddfbf7ccb6d3d,
0x2051667fb195568a,0xf3573952f1a021ed,
0x99565183943f24e8,0xfe9050010eac415b,
0x78da043b744212fa,0xd25ab6ec83c70d8b,
0x119ae91dd58d2d3c,0x1d8cc793f92a258e,
0xf016bca535f01b2e,0x3146217e7441695e,
0x49118b59105a694c,0x3c81482d8b4d09e8,
0xa89ddee1f0275f5e,0x104baec006264538,
0x3f0e87b4bf5bfd60,0xcfd0cfa13b3a9c2f,
0xde82d20c5f26cb72,0xe31a294cb651d0ff,
0x6785e5f07a8cb910,0xeedd401f495db049,
0x8609b0489af18f02,0xc217a6f2c436fc99,
0xef495d6e3b3eb0c4,0xdc1d78dbedbd49c,
0xec508d6db4386d6,0x210b316033b0984c,
0xb7c23f2afee9f4b4,0x2ccc5833ccbcf8fa,
0x564e6a921e94c2a6,0x6bede41d7b42a,
0x6701f6fecc72deac,0xcaa47a3565d71299,
0x868da3462c0fe8be,0xe66e9cd8e8bc5e49,
0x3f8a94ba09a59adc,0xeba9f58b17b03eff,
0xde06c102e9d8acce,0xc76313669adb722f,
0xb7462c2448179308,0x8b56219e0365a2a,
0x56ca799ca86aa51a,0x247f84f46d5d16fa,
0xefcd4e608dc0d778,0x29b8eda79251764c,
0xe411bd86dbde16a,0x5720b4a1f3a3a9c,
0x99d2428d22c14354,0xdae96a2b2226e38b,
0x785e1735c2bc7546,0xf6238cc6af4daf5b,
0xc15920c9e7160724,0xfbe4e5955041cfed,
0x20d57571076b3136,0xd72e0378dd2a833d,
0x49959857a6a40ef0,0x18f87207a7c7ab38,
0xa819cdef46d938e2,0x343294ea2aace7e8,
0x111efa1363734a80,0x39f5fdb9d5a0875e,
0xf092afab830e7c92,0x153f1b5458cbcb8e,
0xd818684a3a072c00,0x4312495bffd7ab2,
0x39943df2da7a1a12,0x28fbc27832963662,
0x80930a0effd06870,0x253cab2bcd9a56d4,
0x611f5fb61fad5e62,0x9f64dc640f11a04,
0x85fb290be6261a4,0xc6203cb93a1c3201,
0xe9d3e7285e1f57b6,0xeaeada54b7777ed1,
0x50d4d0d47bb525d4,0xe72db307487b1e67,
0xb158856c9bc813c6,0xcbe755eac51052b7,
0x26cbdc39d4b4b1f8,0x147c348bf80c8ba0,
0xc747898134c987ea,0x38b6d2667567c770,
0x7e40be7d1163f588,0x3571bb358a6ba7c6,
0x9fccebc5f11ec39a,0x19bb5dd80700eb16,
0xf68c06e350d1fc5c,0xd66d2ca77dedc313,
0x1700535bb0acca4e,0xfaa7ca4af0868fc3,
0xae0764a79506b82c,0xf760a3190f8aef75,
0x4f8b311f757b8e3e,0xdbaa45f482e1a3a5,
0x0,0x0,
0xa10cfc6a1654c578,0x5aa755df14f64da,
0xbae99a4e3fbe0c54,0x82db354523f40c7b,
0x1be5662429eac92c,0x87714018d2bb68a1,
0x8e808ec2a80c4662,0xba5ba13dbf25ee6b,
0x2f8c72a8be58831a,0xbff1d4604e6a8ab1,
0x3469148c97b24a36,0x388094789cd1e210,
0x9565e8e681e68f4e,0x3d2ae1256d9e86ca,
0x5c2b82c39ef7a93c,0x300b8602354dbc70,
0xfd277ea988a36c44,0x35a1f35fc402d8aa,
0xe6c2188da149a568,0xb2d0b34716b9b00b,
0x47cee4e7b71d6010,0xb77ac61ae7f6d4d1,
0xd2ab0c0136fbef5e,0x8a50273f8a68521b,
0x73a7f06b20af2a26,0x8ffa52627b2736c1,
0x6842964f0945e30a,0x88b127aa99c5e60,
0xc94e6a251f112672,0xd21672758d33aba,
0x882e2943d5ee4534,0xc25f5e75edaa4fa9,
0x2922d529c3ba804c,0xc7f52b281ce52b73,
0x32c7b30dea504960,0x40846b30ce5e43d2,
0x93cb4f67fc048c18,0x452e1e6d3f112708,
0x6aea7817de20356,0x7804ff48528fa1c2,
0xa7a25beb6bb6c62e,0x7dae8a15a3c0c518,
0xbc473dcf425c0f02,0xfadfca0d717badb9,
0x1d4bc1a55408ca7a,0xff75bf508034c963,
0xd405ab804b19ec08,0xf254d877d8e7f3d9,
0x750957ea5d4d2970,0xf7fead2a29a89703,
0x6eec31ce74a7e05c,0x708fed32fb13ffa2,
0xcfe0cda462f32524,0x7525986f0a5c9b78,
0x5a852542e315aa6a,0x480f794a67c21db2,
0xfb89d928f5416f12,0x4da50c17968d7968,
0xe06cbf0cdcaba63e,0xcad44c0f443611c9,
0x41604366caff6346,0xcf7e3952b5797513,
0x95d3204b1d1dd922,0x39092e35de04cc32,
0x34dfdc210b491c5a,0x3ca35b682f4ba8e8,
0x2f3aba0522a3d576,0xbbd21b70fdf0c049,
0x8e36466f34f7100e,0xbe786e2d0cbfa493,
0x1b53ae89b5119f40,0x83528f0861212259,
0xba5f52e3a3455a38,0x86f8fa55906e4683,
0xa1ba34c78aaf9314,0x189ba4d42d52e22,
0xb6c8ad9cfb566c,0x423cf10b39a4af8,
0xc9f8a28883ea701e,0x902a837eb497042,
0x68f45ee295beb566,0xca8dd6a1a061498,
0x731138c6bc547c4a,0x8bd99d72c8bd7c39,
0xd21dc4acaa00b932,0x8e73e82f39f218e3,
0x47782c4a2be6367c,0xb359090a546c9e29,
0xe674d0203db2f304,0xb6f37c57a523faf3,
0xfd91b60414583a28,0x31823c4f77989252,
0x5c9d4a6e020cff50,0x3428491286d7f688,
0x1dfd0908c8f39c16,0xfb56704033ae839b,
0xbcf1f562dea7596e,0xfefc051dc2e1e741,
0xa7149346f74d9042,0x798d4505105a8fe0,
0x6186f2ce119553a,0x7c273058e115eb3a,
0x937d87ca60ffda74,0x410dd17d8c8b6df0,
0x32717ba076ab1f0c,0x44a7a4207dc4092a,
0x29941d845f41d620,0xc3d6e438af7f618b,
0x8898e1ee49151358,0xc67c91655e300551,
0x41d68bcb5604352a,0xcb5df64206e33feb,
0xe0da77a14050f052,0xcef7831ff7ac5b31,
0xfb3f118569ba397e,0x4986c30725173390,
0x5a33edef7feefc06,0x4c2cb65ad458574a,
0xcf560509fe087348,0x7106577fb9c6d180,
0x6e5af963e85cb630,0x74ac22224889b55a,
0x75bf9f47c1b67f1c,0xf3dd623a9a32ddfb,
0xd4b3632dd7e2ba64,0xf67717676b7db921,
0xcb6e1a7035541fd6,0x8ab363f0b1f0f211,
0x6a62e61a2300daae,0x8f1916ad40bf96cb,
0x7187803e0aea1382,0x86856b59204fe6a,
0xd08b7c541cbed6fa,0xdc223e8634b9ab0,
0x45ee94b29d5859b4,0x30e8c2cd0ed51c7a,
0xe4e268d88b0c9ccc,0x3542b790ff9a78a0,
0xff070efca2e655e0,0xb233f7882d211001,
0x5e0bf296b4b29098,0xb79982d5dc6e74db,
0x974598b3aba3b6ea,0xbab8e5f284bd4e61,
0x364964d9bdf77392,0xbf1290af75f22abb,
0x2dac02fd941dbabe,0x3863d0b7a749421a,
0x8ca0fe9782497fc6,0x3dc9a5ea560626c0,
0x19c5167103aff088,0xe344cf3b98a00a,
0xb8c9ea1b15fb35f0,0x5493192cad7c4d0,
0xa32c8c3f3c11fcdc,0x8238718a186cac71,
0x22070552a4539a4,0x879204d7e923c8ab,
0x43403333e0ba5ae2,0x48ec3d855c5abdb8,
0xe24ccf59f6ee9f9a,0x4d4648d8ad15d962,
0xf9a9a97ddf0456b6,0xca3708c07faeb1c3,
0x58a55517c95093ce,0xcf9d7d9d8ee1d519,
0xcdc0bdf148b61c80,0xf2b79cb8e37f53d3,
0x6ccc419b5ee2d9f8,0xf71de9e512303709,
0x772927bf770810d4,0x706ca9fdc08b5fa8,
0xd625dbd5615cd5ac,0x75c6dca031c43b72,
0x1f6bb1f07e4df3de,0x78e7bb87691701c8,
0xbe674d9a681936a6,0x7d4dceda98586512,
0xa5822bbe41f3ff8a,0xfa3c8ec24ae30db3,
0x48ed7d457a73af2,0xff96fb9fbbac6969,
0x91eb3f32d641b5bc,0xc2bc1abad632efa3,
0x30e7c358c01570c4,0xc7166fe7277d8b79,
0x2b02a57ce9ffb9e8,0x40672ffff5c6e3d8,
0x8a0e5916ffab7c90,0x45cd5aa204898702,
0x5ebd3a3b2849c6f4,0xb3ba4dc56ff43e23,
0xffb1c6513e1d038c,0xb61038989ebb5af9,
0xe454a07517f7caa0,0x316178804c003258,
0x45585c1f01a30fd8,0x34cb0dddbd4f5682,
0xd03db4f980458096,0x9e1ecf8d0d1d048,
0x71314893961145ee,0xc4b99a5219eb492,
0x6ad42eb7bffb8cc2,0x8b3ad9bdf325dc33,
0xcbd8d2dda9af49ba,0x8e90ace0026ab8e9,
0x296b8f8b6be6fc8,0x83b1cbc75ab98253,
0xa39a4492a0eaaab0,0x861bbe9aabf6e689,
0xb87f22b68900639c,0x16afe82794d8e28,
0x1973dedc9f54a6e4,0x4c08bdf8802eaf2,
0x8c16363a1eb229aa,0x39ea6afae59c6c38,
0x2d1aca5008e6ecd2,0x3c401fa714d308e2,
0x36ffac74210c25fe,0xbb315fbfc6686043,
0x97f3501e3758e086,0xbe9b2ae237270499,
0xd6931378fda783c0,0x71e513b0825e718a,
0x779fef12ebf346b8,0x744f66ed73111550,
0x6c7a8936c2198f94,0xf33e26f5a1aa7df1,
0xcd76755cd44d4aec,0xf69453a850e5192b,
0x58139dba55abc5a2,0xcbbeb28d3d7b9fe1,
0xf91f61d043ff00da,0xce14c7d0cc34fb3b,
0xe2fa07f46a15c9f6,0x496587c81e8f939a,
0x43f6fb9e7c410c8e,0x4ccff295efc0f740,
0x8ab891bb63502afc,0x41ee95b2b713cdfa,
0x2bb46dd17504ef84,0x4444e0ef465ca920,
0x30510bf55cee26a8,0xc335a0f794e7c181,
0x915df79f4abae3d0,0xc69fd5aa65a8a55b,
0x4381f79cb5c6c9e,0xfbb5348f08362391,
0xa534e313dd08a9e6,0xfe1f41d2f979474b,
0xbed18537f4e260ca,0x796e01ca2bc22fea,
0x1fdd795de2b6a5b2,0x7cc47497da8d4b30,
0xa1318678293664f4,0xbe1eca746232042b,
0x3d7a123f62a18c,0xbbb4bf29937d60f1,
0x1bd81c36168868a0,0x3cc5ff3141c60850,
0xbad4e05c00dcadd8,0x396f8a6cb0896c8a,
0x2fb108ba813a2296,0x4456b49dd17ea40,
0x8ebdf4d0976ee7ee,0x1ef1e142c588e9a,
0x955892f4be842ec2,0x869e5e0cfee3e63b,
0x34546e9ea8d0ebba,0x83342b510fac82e1,
0xfd1a04bbb7c1cdc8,0x8e154c76577fb85b,
0x5c16f8d1a19508b0,0x8bbf392ba630dc81,
0x47f39ef5887fc19c,0xcce7933748bb420,
0xe6ff629f9e2b04e4,0x9640c6e85c4d0fa,
0x739a8a791fcd8baa,0x344eed4be85a5630,
0xd296761309994ed2,0x31e49816191532ea,
0xc9731037207387fe,0xb695d80ecbae5a4b,
0x687fec5d36274286,0xb33fad533ae13e91,
0x291faf3bfcd821c0,0x7c4194018f984b82,
0x88135351ea8ce4b8,0x79ebe15c7ed72f58,
0x93f63575c3662d94,0xfe9aa144ac6c47f9,
0x32fac91fd532e8ec,0xfb30d4195d232323,
0xa79f21f954d467a2,0xc61a353c30bda5e9,
0x693dd934280a2da,0xc3b04061c1f2c133,
0x1d76bbb76b6a6bf6,0x44c100791349a992,
0xbc7a47dd7d3eae8e,0x416b7524e206cd48,
0x75342df8622f88fc,0x4c4a1203bad5f7f2,
0xd438d192747b4d84,0x49e0675e4b9a9328,
0xcfddb7b65d9184a8,0xce9127469921fb89,
0x6ed14bdc4bc541d0,0xcb3b521b686e9f53,
0xfbb4a33aca23ce9e,0xf611b33e05f01999,
0x5ab85f50dc770be6,0xf3bbc663f4bf7d43,
0x415d3974f59dc2ca,0x74ca867b260415e2,
0xe051c51ee3c907b2,0x7160f326d74b7138,
0x34e2a633342bbdd6,0x8717e441bc36c819,
0x95ee5a59227f78ae,0x82bd911c4d79acc3,
0x8e0b3c7d0b95b182,0x5ccd1049fc2c462,
0x2f07c0171dc174fa,0x66a4596e8da0b8,
0xba6228f19c27fbb4,0x3d4c457c03132672,
0x1b6ed49b8a733ecc,0x38e63021f25c42a8,
0x8bb2bfa399f7e0,0xbf97703920e72a09,
0xa1874ed5b5cd3298,0xba3d0564d1a84ed3,
0x68c924f0aadc14ea,0xb71c6243897b7469,
0xc9c5d89abc88d192,0xb2b6171e783410b3,
0xd220bebe956218be,0x35c75706aa8f7812,
0x732c42d48336ddc6,0x306d225b5bc01cc8,
0xe649aa3202d05288,0xd47c37e365e9a02,
0x47455658148497f0,0x8edb623c711fed8,
0x5ca0307c3d6e5edc,0x8f9cf63b15aa9679,
0xfdaccc162b3a9ba4,0x8a368366e4e5f2a3,
0xbccc8f70e1c5f8e2,0x4548ba34519c87b0,
0x1dc0731af7913d9a,0x40e2cf69a0d3e36a,
0x625153ede7bf4b6,0xc7938f7172688bcb,
0xa729e954c82f31ce,0xc239fa2c8327ef11,
0x324c01b249c9be80,0xff131b09eeb969db,
0x9340fdd85f9d7bf8,0xfab96e541ff60d01,
0x88a59bfc7677b2d4,0x7dc82e4ccd4d65a0,
0x29a96796602377ac,0x78625b113c02017a,
0xe0e70db37f3251de,0x75433c3664d13bc0,
0x41ebf1d9696694a6,0x70e9496b959e5f1a,
0x5a0e97fd408c5d8a,0xf7980973472537bb,
0xfb026b9756d898f2,0xf2327c2eb66a5361,
0x6e678371d73e17bc,0xcf189d0bdbf4d5ab,
0xcf6b7f1bc16ad2c4,0xcab2e8562abbb171,
0xd48e193fe8801be8,0x4dc3a84ef800d9d0,
0x7582e555fed4de90,0x4869dd13094fbd0a,
0x6a5f9c081c627b22,0x34ada984d3c2f63a,
0xcb5360620a36be5a,0x3107dcd9228d92e0,
0xd0b6064623dc7776,0xb6769cc1f036fa41,
0x71bafa2c3588b20e,0xb3dce99c01799e9b,
0xe4df12cab46e3d40,0x8ef608b96ce71851,
0x45d3eea0a23af838,0x8b5c7de49da87c8b,
0x5e3688848bd03114,0xc2d3dfc4f13142a,
0xff3a74ee9d84f46c,0x98748a1be5c70f0,
0x36741ecb8295d21e,0x4a62f86e68f4a4a,
0x9778e2a194c11766,0x10c5adb17c02e90,
0x8c9d8485bd2bde4a,0x867d1ac3c57b4631,
0x2d9178efab7f1b32,0x83d76f9e343422eb,
0xb8f490092a99947c,0xbefd8ebb59aaa421,
0x19f86c633ccd5104,0xbb57fbe6a8e5c0fb,
0x21d0a4715279828,0x3c26bbfe7a5ea85a,
0xa311f62d03735d50,0x398ccea38b11cc80,
0xe271b54bc98c3e16,0xf6f2f7f13e68b993,
0x437d4921dfd8fb6e,0xf35882accf27dd49,
0x58982f05f6323242,0x7429c2b41d9cb5e8,
0xf994d36fe066f73a,0x7183b7e9ecd3d132,
0x6cf13b8961807874,0x4ca956cc814d57f8,
0xcdfdc7e377d4bd0c,0x4903239170023322,
0xd618a1c75e3e7420,0xce726389a2b95b83,
0x77145dad486ab158,0xcbd816d453f63f59,
0xbe5a3788577b972a,0xc6f971f30b2505e3,
0x1f56cbe2412f5252,0xc35304aefa6a6139,
0x4b3adc668c59b7e,0x442244b628d10998,
0xa5bf51ac7e915e06,0x418831ebd99e6d42,
0x30dab94aff77d148,0x7ca2d0ceb400eb88,
0x91d64520e9231430,0x7908a593454f8f52,
0x8a332304c0c9dd1c,0xfe79e58b97f4e7f3,
0x2b3fdf6ed69d1864,0xfbd390d666bb8329,
0xff8cbc43017fa200,0xda487b10dc63a08,
0x5e804029172b6778,0x80ef2ecfc895ed2,
0x4565260d3ec1ae54,0x8f7fb2f42e323673,
0xe469da6728956b2c,0x8ad5c7a9df7d52a9,
0x710c3281a973e462,0xb7ff268cb2e3d463,
0xd000ceebbf27211a,0xb25553d143acb0b9,
0xcbe5a8cf96cde836,0x352413c99117d818,
0x6ae954a580992d4e,0x308e66946058bcc2,
0xa3a73e809f880b3c,0x3daf01b3388b8678,
0x2abc2ea89dcce44,0x380574eec9c4e2a2,
0x194ea4cea0360768,0xbf7434f61b7f8a03,
0xb84258a4b662c210,0xbade41abea30eed9,
0x2d27b04237844d5e,0x87f4a08e87ae6813,
0x8c2b4c2821d08826,0x825ed5d376e10cc9,
0x97ce2a0c083a410a,0x52f95cba45a6468,
0x36c2d6661e6e8472,0x85e096551500b2,
0x77a29500d491e734,0xcffbd9c4e06c75a1,
0xd6ae696ac2c5224c,0xca51ac991123117b,
0xcd4b0f4eeb2feb60,0x4d20ec81c39879da,
0x6c47f324fd7b2e18,0x488a99dc32d71d00,
0xf9221bc27c9da156,0x75a078f95f499bca,
0x582ee7a86ac9642e,0x700a0da4ae06ff10,
0x43cb818c4323ad02,0xf77b4dbc7cbd97b1,
0xe2c77de65577687a,0xf2d138e18df2f36b,
0x2b8917c34a664e08,0xfff05fc6d521c9d1,
0x8a85eba95c328b70,0xfa5a2a9b246ead0b,
0x91608d8d75d8425c,0x7d2b6a83f6d5c5aa,
0x306c71e7638c8724,0x78811fde079aa170,
0xa5099901e26a086a,0x45abfefb6a0427ba,
0x405656bf43ecd12,0x40018ba69b4b4360,
0x1fe0034fddd4043e,0xc770cbbe49f02bc1,
0xbeecff25cb80c146,0xc2dabee3b8bf4f1b,
0x0,0x0,
0xe684ecc9b397a5fe,0xb3b2d35103f1a3ed,
0x6da6f30e41a8edf0,0x34b0cc6ccf4ee620,
0x8b221fc7f23f480e,0x87021f3dccbf45cd,
0xacd605531d728f16,0xa6af6a59808b2143,
0x4a52e99aaee52ae8,0x151db908837a82ae,
0xc170f65d5cda62e6,0x921fa6354fc5c763,
0x27f41a94ef4dc718,0x21ad75644c34648e,
0x36771e3ca90ca14,0x3555819a552c1192,
0xe5e39d2a79076fea,0x86e752cb56ddb27f,
0x6ec182ed8b3827e4,0x1e54df69a62f7b2,
0x88456e2438af821a,0xb2579ea79993545f,
0xafb174b0d7e24502,0x93faebc3d5a730d1,
0x493598796475e0fc,0x20483892d656933c,
0xc21787be964aa8f2,0xa74a27af1ae9d6f1,
0x24936b7725dd0d0c,0x14f8f4fe1918751c,
0xc6c1932eeb78b72a,0xeabea114c8ae9a9f,
0x20457fe758ef12d4,0x590c7245cb5f3972,
0xab676020aad05ada,0xde0e6d7807e07cbf,
0x4de38ce91947ff24,0x6dbcbe290411df52,
0x6a17967df60a383c,0x4c11cb4d4825bbdc,
0x8c937ab4459d9dc2,0xffa3181c4bd41831,
0x7b16573b7a2d5cc,0x78a10721876b5dfc,
0xe13589ba04357032,0xcb13d470849afe11,
0xc5a6e2cd21e87d3e,0xdfeb208e9d828b0d,
0x23220e04927fd8c0,0x6c59f3df9e7328e0,
0xa80011c3604090ce,0xeb5bece252cc6d2d,
0x4e84fd0ad3d73530,0x58e93fb3513dcec0,
0x6970e79e3c9af228,0x79444ad71d09aa4e,
0x8ff40b578f0d57d6,0xcaf699861ef809a3,
0x4d614907d321fd8,0x4df486bbd2474c6e,
0xe252f859cea5ba26,0xfe4655ead1b6ef83,
0xfc5874dd3b9425ce,0x1988519c2a18a57c,
0x1adc981488038030,0xaa3a82cd29e90691,
0x91fe87d37a3cc83e,0x2d389df0e556435c,
0x777a6b1ac9ab6dc0,0x9e8a4ea1e6a7e0b1,
0x508e718e26e6aad8,0xbf273bc5aa93843f,
0xb60a9d4795710f26,0xc95e894a96227d2,
0x3d288280674e4728,0x8b97f7a965dd621f,
0xdbac6e49d4d9e2d6,0x382524f8662cc1f2,
0xff3f053ef104efda,0x2cddd0067f34b4ee,
0x19bbe9f742934a24,0x9f6f03577cc51703,
0x9299f630b0ac022a,0x186d1c6ab07a52ce,
0x741d1af9033ba7d4,0xabdfcf3bb38bf123,
0x53e9006dec7660cc,0x8a72ba5fffbf95ad,
0xb56deca45fe1c532,0x39c0690efc4e3640,
0x3e4ff363adde8d3c,0xbec2763330f1738d,
0xd8cb1faa1e4928c2,0xd70a5623300d060,
0x3a99e7f3d0ec92e4,0xf336f088e2b63fe3,
0xdc1d0b3a637b371a,0x408423d9e1479c0e,
0x573f14fd91447f14,0xc7863ce42df8d9c3,
0xb1bbf83422d3daea,0x7434efb52e097a2e,
0x964fe2a0cd9e1df2,0x55999ad1623d1ea0,
0x70cb0e697e09b80c,0xe62b498061ccbd4d,
0xfbe911ae8c36f002,0x612956bdad73f880,
0x1d6dfd673fa155fc,0xd29b85ecae825b6d,
0x39fe96101a7c58f0,0xc6637112b79a2e71,
0xdf7a7ad9a9ebfd0e,0x75d1a243b46b8d9c,
0x5458651e5bd4b500,0xf2d3bd7e78d4c851,
0xb2dc89d7e84310fe,0x41616e2f7b256bbc,
0x95289343070ed7e6,0x60cc1b4b37110f32,
0x73ac7f8ab4997218,0xd37ec81a34e0acdf,
0xf88e604d46a63a16,0x547cd727f85fe912,
0x1e0a8c84f5319fe8,0xe7ce0476fbae4aff,
0x70ec558472062c44,0x60abfabc33f697de,
0x9668b94dc19189ba,0xd31929ed30073433,
0x1d4aa68a33aec1b4,0x541b36d0fcb871fe,
0xfbce4a438039644a,0xe7a9e581ff49d213,
0xdc3a50d76f74a352,0xc60490e5b37db69d,
0x3abebc1edce306ac,0x75b643b4b08c1570,
0xb19ca3d92edc4ea2,0xf2b45c897c3350bd,
0x57184f109d4beb5c,0x41068fd87fc2f350,
0x738b2467b896e650,0x55fe7b2666da864c,
0x950fc8ae0b0143ae,0xe64ca877652b25a1,
0x1e2dd769f93e0ba0,0x614eb74aa994606c,
0xf8a93ba04aa9ae5e,0xd2fc641baa65c381,
0xdf5d2134a5e46946,0xf351117fe651a70f,
0x39d9cdfd1673ccb8,0x40e3c22ee5a004e2,
0xb2fbd23ae44c84b6,0xc7e1dd13291f412f,
0x547f3ef357db2148,0x74530e422aeee2c2,
0xb62dc6aa997e9b6e,0x8a155ba8fb580d41,
0x50a92a632ae93e90,0x39a788f9f8a9aeac,
0xdb8b35a4d8d6769e,0xbea597c43416eb61,
0x3d0fd96d6b41d360,0xd17449537e7488c,
0x1afbc3f9840c1478,0x2cba31f17bd32c02,
0xfc7f2f30379bb186,0x9f08e2a078228fef,
0x775d30f7c5a4f988,0x180afd9db49dca22,
0x91d9dc3e76335c76,0xabb82eccb76c69cf,
0xb54ab74953ee517a,0xbf40da32ae741cd3,
0x53ce5b80e079f484,0xcf20963ad85bf3e,
0xd8ec44471246bc8a,0x8bf0165e613afaf3,
0x3e68a88ea1d11974,0x3842c50f62cb591e,
0x199cb21a4e9cde6c,0x19efb06b2eff3d90,
0xff185ed3fd0b7b92,0xaa5d633a2d0e9e7d,
0x743a41140f34339c,0x2d5f7c07e1b1dbb0,
0x92beadddbca39662,0x9eedaf56e240785d,
0x8cb421594992098a,0x7923ab2019ee32a2,
0x6a30cd90fa05ac74,0xca9178711a1f914f,
0xe112d257083ae47a,0x4d93674cd6a0d482,
0x7963e9ebbad4184,0xfe21b41dd551776f,
0x2062240a54e0869c,0xdf8cc179996513e1,
0xc6e6c8c3e7772362,0x6c3e12289a94b00c,
0x4dc4d70415486b6c,0xeb3c0d15562bf5c1,
0xab403bcda6dfce92,0x588ede4455da562c,
0x8fd350ba8302c39e,0x4c762aba4cc22330,
0x6957bc7330956660,0xffc4f9eb4f3380dd,
0xe275a3b4c2aa2e6e,0x78c6e6d6838cc510,
0x4f14f7d713d8b90,0xcb743587807d66fd,
0x230555e99e704c88,0xead940e3cc490273,
0xc581b9202de7e976,0x596b93b2cfb8a19e,
0x4ea3a6e7dfd8a178,0xde698c8f0307e453,
0xa8274a2e6c4f0486,0x6ddb5fde00f647be,
0x4a75b277a2eabea0,0x939d0a34d140a83d,
0xacf15ebe117d1b5e,0x202fd965d2b10bd0,
0x27d34179e3425350,0xa72dc6581e0e4e1d,
0xc157adb050d5f6ae,0x149f15091dffedf0,
0xe6a3b724bf9831b6,0x3532606d51cb897e,
0x275bed0c0f9448,0x8680b33c523a2a93,
0x8b05442afe30dc46,0x182ac019e856f5e,
0x6d81a8e34da779b8,0xb2307f509d74ccb3,
0x4912c394687a74b4,0xa6c88bae846cb9af,
0xaf962f5ddbedd14a,0x157a58ff879d1a42,
0x24b4309a29d29944,0x927847c24b225f8f,
0xc230dc539a453cba,0x21ca949348d3fc62,
0xe5c4c6c77508fba2,0x67e1f704e798ec,
0x3402a0ec69f5e5c,0xb3d532a607163b01,
0x886235c934a01652,0x34d72d9bcba97ecc,
0x6ee6d9008737b3ac,0x8765fecac858dd21,
0xa9e47128863ba654,0xdf68fe1cdf73f30,
0x4f609de135ac03aa,0xbe445cb0ce069cdd,
0xc4428226c7934ba4,0x3946438d02b9d910,
0x22c66eef7404ee5a,0x8af490dc01487afd,
0x532747b9b492942,0xab59e5b84d7c1e73,
0xe3b698b228de8cbc,0x18eb36e94e8dbd9e,
0x68948775dae1c4b2,0x9fe929d48232f853,
0x8e106bbc6976614c,0x2c5bfa8581c35bbe,
0xaa8300cb4cab6c40,0x38a30e7b98db2ea2,
0x4c07ec02ff3cc9be,0x8b11dd2a9b2a8d4f,
0xc725f3c50d0381b0,0xc13c2175795c882,
0x21a11f0cbe94244e,0xbfa1114654646b6f,
0x655059851d9e356,0x9e0c642218500fe1,
0xe0d1e951e24e46a8,0x2dbeb7731ba1ac0c,
0x6bf3f69610710ea6,0xaabca84ed71ee9c1,
0x8d771a5fa3e6ab58,0x190e7b1fd4ef4a2c,
0x6f25e2066d43117e,0xe7482ef50559a5af,
0x89a10ecfded4b480,0x54fafda406a80642,
0x28311082cebfc8e,0xd3f8e299ca17438f,
0xe407fdc19f7c5970,0x604a31c8c9e6e062,
0xc3f3e75570319e68,0x41e744ac85d284ec,
0x25770b9cc3a63b96,0xf25597fd86232701,
0xae55145b31997398,0x755788c04a9c62cc,
0x48d1f892820ed666,0xc6e55b91496dc121,
0x6c4293e5a7d3db6a,0xd21daf6f5075b43d,
0x8ac67f2c14447e94,0x61af7c3e538417d0,
0x1e460ebe67b369a,0xe6ad63039f3b521d,
0xe7608c2255ec9364,0x551fb0529ccaf1f0,
0xc09496b6baa1547c,0x74b2c536d0fe957e,
0x26107a7f0936f182,0xc7001667d30f3693,
0xad3265b8fb09b98c,0x4002095a1fb0735e,
0x4bb68971489e1c72,0xf3b0da0b1c41d0b3,
0x55bc05f5bdaf839a,0x147ede7de7ef9a4c,
0xb338e93c0e382664,0xa7cc0d2ce41e39a1,
0x381af6fbfc076e6a,0x20ce121128a17c6c,
0xde9e1a324f90cb94,0x937cc1402b50df81,
0xf96a00a6a0dd0c8c,0xb2d1b4246764bb0f,
0x1feeec6f134aa972,0x1636775649518e2,
0x94ccf3a8e175e17c,0x86617848a82a5d2f,
0x72481f6152e24482,0x35d3ab19abdbfec2,
0x56db7416773f498e,0x212b5fe7b2c38bde,
0xb05f98dfc4a8ec70,0x92998cb6b1322833,
0x3b7d87183697a47e,0x159b938b7d8d6dfe,
0xddf96bd185000180,0xa62940da7e7cce13,
0xfa0d71456a4dc698,0x878435be3248aa9d,
0x1c899d8cd9da6366,0x3436e6ef31b90970,
0x97ab824b2be52b68,0xb334f9d2fd064cbd,
0x712f6e8298728e96,0x862a83fef7ef50,
0x937d96db56d734b0,0xfec07f692f4100d3,
0x75f97a12e540914e,0x4d72ac382cb0a33e,
0xfedb65d5177fd940,0xca70b305e00fe6f3,
0x185f891ca4e87cbe,0x79c26054e3fe451e,
0x3fab93884ba5bba6,0x586f1530afca2190,
0xd92f7f41f8321e58,0xebddc661ac3b827d,
0x520d60860a0d5656,0x6cdfd95c6084c7b0,
0xb4898c4fb99af3a8,0xdf6d0a0d6375645d,
0x901ae7389c47fea4,0xcb95fef37a6d1141,
0x769e0bf12fd05b5a,0x78272da2799cb2ac,
0xfdbc1436ddef1354,0xff25329fb523f761,
0x1b38f8ff6e78b6aa,0x4c97e1ceb6d2548c,
0x3ccce26b813571b2,0x6d3a94aafae63002,
0xda480ea232a2d44c,0xde8847fbf91793ef,
0x516a1165c09d9c42,0x598a58c635a8d622,
0xb7eefdac730a39bc,0xea388b97365975cf,
0xd90824acf43d8a10,0x6d5d755dfe01a8ee,
0x3f8cc86547aa2fee,0xdeefa60cfdf00b03,
0xb4aed7a2b59567e0,0x59edb931314f4ece,
0x522a3b6b0602c21e,0xea5f6a6032beed23,
0x75de21ffe94f0506,0xcbf21f047e8a89ad,
0x935acd365ad8a0f8,0x7840cc557d7b2a40,
0x1878d2f1a8e7e8f6,0xff42d368b1c46f8d,
0xfefc3e381b704d08,0x4cf00039b235cc60,
0xda6f554f3ead4004,0x5808f4c7ab2db97c,
0x3cebb9868d3ae5fa,0xebba2796a8dc1a91,
0xb7c9a6417f05adf4,0x6cb838ab64635f5c,
0x514d4a88cc92080a,0xdf0aebfa6792fcb1,
0x76b9501c23dfcf12,0xfea79e9e2ba6983f,
0x903dbcd590486aec,0x4d154dcf28573bd2,
0x1b1fa312627722e2,0xca1752f2e4e87e1f,
0xfd9b4fdbd1e0871c,0x79a581a3e719ddf2,
0x1fc9b7821f453d3a,0x87e3d44936af3271,
0xf94d5b4bacd298c4,0x34510718355e919c,
0x726f448c5eedd0ca,0xb3531825f9e1d451,
0x94eba845ed7a7534,0xe1cb74fa1077bc,
0xb31fb2d10237b22c,0x214cbe10b6241332,
0x559b5e18b1a017d2,0x92fe6d41b5d5b0df,
0xdeb941df439f5fdc,0x15fc727c796af512,
0x383dad16f008fa22,0xa64ea12d7a9b56ff,
0x1caec661d5d5f72e,0xb2b655d3638323e3,
0xfa2a2aa8664252d0,0x10486826072800e,
0x7108356f947d1ade,0x860699bfaccdc5c3,
0x978cd9a627eabf20,0x35b44aeeaf3c662e,
0xb078c332c8a77838,0x14193f8ae30802a0,
0x56fc2ffb7b30ddc6,0xa7abecdbe0f9a14d,
0xddde303c890f95c8,0x20a9f3e62c46e480,
0x3b5adcf53a983036,0x931b20b72fb7476d,
0x25505071cfa9afde,0x74d524c1d4190d92,
0xc3d4bcb87c3e0a20,0xc767f790d7e8ae7f,
0x48f6a37f8e01422e,0x4065e8ad1b57ebb2,
0xae724fb63d96e7d0,0xf3d73bfc18a6485f,
0x89865522d2db20c8,0xd27a4e9854922cd1,
0x6f02b9eb614c8536,0x61c89dc957638f3c,
0xe420a62c9373cd38,0xe6ca82f49bdccaf1,
0x2a44ae520e468c6,0x557851a5982d691c,
0x26372192053965ca,0x4180a55b81351c00,
0xc0b3cd5bb6aec034,0xf232760a82c4bfed,
0x4b91d29c4491883a,0x753069374e7bfa20,
0xad153e55f7062dc4,0xc682ba664d8a59cd,
0x8ae124c1184beadc,0xe72fcf0201be3d43,
0x6c65c808abdc4f22,0x549d1c53024f9eae,
0xe747d7cf59e3072c,0xd39f036ecef0db63,
0x1c33b06ea74a2d2,0x602dd03fcd01788e,
0xe391c35f24d118f4,0x9e6b85d51cb7970d,
0x5152f969746bd0a,0x2dd956841f4634e0,
0x8e3730516579f504,0xaadb49b9d3f9712d,
0x68b3dc98d6ee50fa,0x19699ae8d008d2c0,
0x4f47c60c39a397e2,0x38c4ef8c9c3cb64e,
0xa9c32ac58a34321c,0x8b763cdd9fcd15a3,
0x22e13502780b7a12,0xc7423e05372506e,
0xc465d9cbcb9cdfec,0xbfc6f0b15083f383,
0xe0f6b2bcee41d2e0,0xab3e044f499b869f,
0x6725e755dd6771e,0x188cd71e4a6a2572,
0x8d5041b2afe93f10,0x9f8ec82386d560bf,
0x6bd4ad7b1c7e9aee,0x2c3c1b728524c352,
0x4c20b7eff3335df6,0xd916e16c910a7dc,
0xaaa45b2640a4f808,0xbe23bd47cae10431,
0x218644e1b29bb006,0x3921a27a065e41fc,
0xc702a828010c15f8,0x8a93712b05afe211,
};
}
#endif