# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/multiloss.ipynb (unless otherwise specified).

__all__ = ['MultiLoss', 'MultiLossCallback']

# Cell
import types

from fastai.callback.core import Callback
from fastai.learner import Recorder

from .basics import is_listish
from .metrics import AvgLossX, AvgSmoothLossX
from .imports import *

# Internal Cell
def init_loss(l, **kwargs):
    "Initiatize loss class or partial loss function"
    return partialler(l, reduction='none') if isinstance(l, types.FunctionType) else l(reduction='none', **kwargs)

# Cell
class MultiLoss(Module):
    "Combine multiple `loss_funcs` via `reduction`, with optional weighting. Log loss_funcs to metrics via MultiLossCallback, optionally using `loss_names`."
    def __init__(self, loss_funcs=[], weights=[], loss_kwargs=[], loss_names=[], reduction='mean'):
        store_attr(but='loss_funcs,weights,loss_kwargs,loss_names')
        if len(weights)==0: self.weights = [1]*len(loss_funcs)
        else: self.weights = weights
        if len(loss_kwargs)==0: loss_kwargs = [{}]*len(loss_funcs)
        self.loss_funcs = [init_loss(l, **k) for l, k in zip(loss_funcs, loss_kwargs)]
        if len(loss_names)==0: loss_names = [l.__name__ for l in loss_funcs]
        self.loss_names = L(loss_names)
        self._reduction,self._loss = reduction,{}

    def forward(self, pred, targ):
        for i, loss_func in enumerate(self.loss_funcs):
            l = TensorBase(self.weights[i]*loss_func(pred, targ))
            if i == 0: loss = TensorBase(torch.zeros_like(targ)).float()
            loss += l
            self._loss[i] = l

        return loss.mean() if self._reduction=='mean' else loss.sum() if self._reduction=='sum' else loss

    @property
    def losses(self): return self._loss

    @property
    def reduction(self): return self._reduction

    @reduction.setter
    def reduction(self, r): self._reduction = r

    @delegates(Module.to)
    def to(self, *args, **kwargs):
        device, dtype, non_blocking, convert_to_format = torch._C._nn._parse_to(*args, **kwargs)
        if is_listish(self.weights) or not isinstance(self.weights, torch.Tensor): self.weights = torch.Tensor(self.weights)
        if self.weights.device != device: self.weights = self.weights.to(device=device)
        super().to(*args, **kwargs)

    def activation(self, pred):
        return getattr(self.loss_funcs[0], 'activation', noop)(pred)

    def decodes(self, pred):
        return getattr(self.loss_funcs[0], 'decodes', noop)(pred)

# Internal Cell
class MultiAvgLoss(AvgLossX):
    "Average the MultiLoss losses taking into account potential different batch sizes"
    def __init__(self, i, name, reduction='mean'):
        store_attr(but='name')
        self._name = name

    def accumulate(self, learn):
        bs = find_bs(learn.yb)
        loss = learn.loss_func.losses[self.i]
        loss = loss.mean() if self.reduction=='mean' else loss.sum() if self.reduction=='sum' else loss
        self.total += learn.to_detach(loss.mean())*bs
        self.count += bs

# Internal Cell
class MultiAvgSmoothLoss(AvgSmoothLossX):
    "Smooth average of the MultiLoss losses (exponentially weighted with `beta`)"
    def __init__(self, i, name, beta=0.98, reduction='mean'):
        super().__init__()
        store_attr(but='name')
        self._name = name

    def accumulate(self, learn):
        self.count += 1
        loss = learn.loss_func.losses[self.i]
        loss = loss.mean() if self.reduction=='mean' else loss.sum() if self.reduction=='sum' else loss
        self.val = torch.lerp(to_detach(loss.mean(), gather=False), self.val, self.beta)

# Cell
class MultiLossCallback(Callback):
    "Callback to automatically add and name `MultiLoss` losses as fastxtend metrics"
    run_valid,order = False,Recorder.order-1

    def __init__(self, beta=0.98, reduction=None):
        store_attr()

    def before_fit(self):
        if not isinstance(self.loss_func, MultiLoss):
            raise ValueError("`MultiLossCallback` requires loss to be `MultiLoss` class")

        mets= L()
        reduction = self.loss_func.reduction if self.reduction is None else self.reduction
        for i in range(len(self.loss_func.loss_funcs)):
            mets += MultiAvgSmoothLoss(i, self.loss_func.loss_names[i], self.beta, reduction)
            mets += MultiAvgLoss(i, self.loss_func.loss_names[i], reduction)

        self.learn.metrics = mets + self.learn.metrics