"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnKeyPair = exports.toJson_TagsAllDefinition = exports.toJson_TagsDefinition = exports.toJson_CfnKeyPairProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnKeyPairProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnKeyPairProps(obj) {
    var _b, _c;
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'KeyName': obj.keyName,
        'KeyNamePrefix': obj.keyNamePrefix,
        'PublicKey': obj.publicKey,
        'Tags': (_b = obj.tags) === null || _b === void 0 ? void 0 : _b.map(y => toJson_TagsDefinition(y)),
        'TagsAll': (_c = obj.tagsAll) === null || _c === void 0 ? void 0 : _c.map(y => toJson_TagsAllDefinition(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnKeyPairProps = toJson_CfnKeyPairProps;
/**
 * Converts an object of type 'TagsDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_TagsDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'MapKey': obj.mapKey,
        'MapValue': obj.mapValue,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_TagsDefinition = toJson_TagsDefinition;
/**
 * Converts an object of type 'TagsAllDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_TagsAllDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'MapKey': obj.mapKey,
        'MapValue': obj.mapValue,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_TagsAllDefinition = toJson_TagsAllDefinition;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `TF::AWS::KeyPair`
 *
 * @cloudformationResource TF::AWS::KeyPair
 * @stability external
 * @link https://github.com/iann0036/cfn-tf-custom-types.git
 */
class CfnKeyPair extends cdk.CfnResource {
    /**
     * Create a new `TF::AWS::KeyPair`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnKeyPair.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnKeyPairProps(props) });
        this.props = props;
        this.attrTfcfnid = cdk.Token.asString(this.getAtt('tfcfnid'));
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrFingerprint = cdk.Token.asString(this.getAtt('Fingerprint'));
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.attrKeyPairId = cdk.Token.asString(this.getAtt('KeyPairId'));
    }
}
exports.CfnKeyPair = CfnKeyPair;
_a = JSII_RTTI_SYMBOL_1;
CfnKeyPair[_a] = { fqn: "@cdk-cloudformation/tf-aws-keypair.CfnKeyPair", version: "1.0.0-alpha.5" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnKeyPair.CFN_RESOURCE_TYPE_NAME = "TF::AWS::KeyPair";
//# sourceMappingURL=data:application/json;base64,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