# AUTOGENERATED! DO NOT EDIT! File to edit: ../../../nbs/13_l2r.data.info_gain.ipynb.

# %% auto 0
__all__ = ['BatchLbsChunkify', 'MutualInfoGain']

# %% ../../../nbs/13_l2r.data.info_gain.ipynb 2
from fastcore.basics import *
from fastai.torch_core import *
from fastai.data.core import *
from fastai.data.transforms import *
from fastai.text.core import *
from fastai.text.data import *
from ...imports import *
from ...torch_imports import *

# %% ../../../nbs/13_l2r.data.info_gain.ipynb 6
class BatchLbsChunkify(ItemTransform):
    order = 100
    def __init__(self, chnk_st, chnk_end): store_attr('chnk_st,chnk_end')
    def encodes(self, x): 
        return (x[0], x[1][:, self.chnk_st:self.chnk_end])

# %% ../../../nbs/13_l2r.data.info_gain.ipynb 7
class MutualInfoGain:
    def __init__(self, df, bs=8, chnk_sz=200, device=None, lbs_desc=None): 
        store_attr(but='lbs_desc')
        if lbs_desc is not None:
            try:
                with open(lbs_desc, 'rb') as f: self.lbs_desc = pickle.load(f)
            except FileNotFoundError as e: print(e)
    
    def onehotify(self):
        x_tfms = [Tokenizer.from_df('text', n_workers=num_cpus()), attrgetter("text"), Numericalize(), OneHotEncode()]
        y_tfms = [ColReader('labels', label_delim=';'), MultiCategorize(), OneHotEncode()]
        tfms = [x_tfms, y_tfms]
        self.dsets = Datasets(self.df, tfms=[x_tfms, y_tfms], )
        self.toksize, self.lblsize = self.dsets.vocab.map(len)
        return self.dsets
        
    def lbs_chunked(self):
        lbs = self.dsets.vocab[1]
        self.dls = []
        for chnk_st in range(0, len(lbs), self.chnk_sz):
            self.dls.append(TfmdDL(self.dsets, bs=self.bs, 
                              after_batch=[BatchLbsChunkify(chnk_st, min(chnk_st+self.chnk_sz, len(lbs)))], 
                              device=default_device() if self.device is None else self.device))
        return self.dls
    
    def _mutual_info_gain(self, dl):
        """
        Computes [mutual information gain](https://en.wikipedia.org/wiki/Mutual_information) for each token label pair
        `dl` is (bag-of-words text, one-hot encoded targets)
        """
        xb, yb = dl.one_batch() 
        toksize, lblsize = xb.size(1), yb.size(1)
        p_TL = torch.zeros(toksize, lblsize, 4, dtype=torch.float, device=default_device())
        eps = p_TL.new_empty(1).fill_(1e-8)
        for x,y in dl:
            test_eq(x.shape, (dl.bs, toksize)); test_eq(y.shape, (dl.bs, lblsize))
            t = x.unsqueeze(-1).expand(-1, -1, lblsize) ; test_eq(t.shape, (dl.bs, toksize, lblsize))
            l = y.unsqueeze(1).expand(-1, toksize, -1) ; test_eq(l.shape, (dl.bs, toksize, lblsize))
            tl = torch.stack((t,l), dim=-1) ; test_eq(tl.shape, (dl.bs, toksize, lblsize, 2)) 
            p_TL_tt = tl[...,0].logical_and(tl[...,1]) ; test_eq(p_TL_tt.shape, (dl.bs, toksize, lblsize)) 
            p_TL_tf = tl[...,0].logical_and(tl[...,1].logical_not()) ; test_eq(p_TL_tf.shape, (dl.bs, toksize, lblsize)) 
            p_TL_ft = tl[...,0].logical_not().logical_and(tl[...,1]) ; test_eq(p_TL_ft.shape, (dl.bs, toksize, lblsize))
            p_TL_ff = tl[...,0].logical_not().logical_and(tl[...,1].logical_not()) ; test_eq(p_TL_ff.shape, (dl.bs, toksize, lblsize)) 
            p_TL = p_TL + torch.stack((p_TL_tt, p_TL_tf, p_TL_ft, p_TL_ff), dim=-1).float().sum(dim=0)
        p_TL = p_TL / tensor(len(self.dsets)).float()
        p_TL = p_TL.view(toksize, lblsize, 2, 2) ; test_eq(p_TL.shape, (toksize, lblsize, 2, 2))# last axis: lbl axis, 2nd last axis: token axis
        return p_TL
    
    def joint_pmf(self):
        self.p_TL_full = [] 
        for dl in progress_bar(self.dls):
            p_TL = self._mutual_info_gain(dl)
            self.p_TL_full.append(p_TL)
            del p_TL; #del p_T; del p_L; del p_TxL; del I_TL; torch.cuda.empty_cache()
        self.p_TL_full = torch.cat(self.p_TL_full, dim=1); test_eq(self.p_TL_full.shape, (self.toksize, self.lblsize, 2, 2))
        return self.p_TL_full
    
    def compute(self):
        eps = self.p_TL_full.new_empty(1).fill_(1e-15)
        toksize, lblsize = self.p_TL_full.size(0), self.p_TL_full.size(1)
        p_T = self.p_TL_full[:,0].sum(-1, keepdim=True); test_eq(p_T.shape, (toksize, 2, 1))# 0 because we can pick any label and apply total prob law
        p_L = self.p_TL_full[0,:].sum(-2, keepdim=True); test_eq(p_L.shape, (lblsize, 1, 2)) # 0 becuase we can pick any token and apply total prob law
        p_TxL = self.p_TL_full.sum(-1, keepdim=True) @ self.p_TL_full.sum(-2, keepdim=True); test_eq(p_TxL.shape, (toksize, lblsize, 2, 2))
        H_T = -(p_T * torch.log(p_T+eps)).sum(-2).squeeze(); test_eq(H_T.shape, [toksize])
        H_L = -(p_L * torch.log(p_L+eps)).sum(-1).squeeze(); test_eq(H_L.shape, [lblsize])
        I_TL = (self.p_TL_full * torch.log((self.p_TL_full + eps)/(p_TxL + eps))).flatten(start_dim=-2).sum(-1); test_eq(I_TL.shape, (toksize, lblsize))
        return p_T, p_L, p_TxL, H_T, H_L, I_TL
    
    @property
    def lbs_frqs(self):
        f = ColReader('labels', label_delim=';')
        self._frqs = Counter()
        for o in self.df.itertuples(): self._frqs.update(f(o))
        return self._frqs

# %% ../../../nbs/13_l2r.data.info_gain.ipynb 9
@patch
def _gen(self:MutualInfoGain, p_TL, p_T, p_L, info, H_T, H_L, k=5):
    toks, lbs = array(self.dsets.vocab[0]), self.dsets.vocab[1]
    sorted_by_tok, tok_idxs = torch.sort(info, dim=0, descending=True) 
    for i,o in enumerate(lbs):
        topk_tok_idxs = tok_idxs[:k, i].cpu()
        topk_toks = toks[topk_tok_idxs]
        topk_toks_probs = p_T.squeeze()[:,0][topk_tok_idxs].cpu().numpy()
        topk_info_gains = sorted_by_tok[:k, i].cpu().numpy()
        topk_jnt_probs = p_TL[topk_tok_idxs, [i]][:,0,0].cpu().numpy()
        lbl_entropy = H_L[i].cpu().numpy()
        topk_tok_entrops = H_T[topk_tok_idxs].cpu().numpy()
        yield (o, self.lbs_frqs[o], p_L[i][0,0].cpu().numpy(), lbl_entropy, self.lbs_desc.get(o, 'Not Found'), 
               array(list(zip(topk_toks, topk_toks_probs, topk_tok_entrops, topk_jnt_probs, topk_info_gains))))

# %% ../../../nbs/13_l2r.data.info_gain.ipynb 10
@patch
def show(self:MutualInfoGain, *args, save_as=None, **kwargs):
    _data = self._gen(*args, **kwargs)
    df = pd.DataFrame(_data, columns=['label', 'freq', 'prob', 'entropy', 'description', 'top-k (token, prob, entropy, joint, info)'],)
    df[['prob', 'entropy',]] = df[['prob', 'entropy']].astype(np.float)
    df[['top-k (token, prob, entropy, joint, info)']] = df[['top-k (token, prob, entropy, joint, info)']].astype(np.str_) 
    if save_as is not None: df.to_feather(save_as)
    return df
