import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNomadDatacentersConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/d/datacenters#id DataNomadDatacenters#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * If enabled, this flag will ignore nodes that are down when listing datacenters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/d/datacenters#ignore_down_nodes DataNomadDatacenters#ignore_down_nodes}
    */
    readonly ignoreDownNodes?: boolean | cdktf.IResolvable;
    /**
    * Prefix value used for filtering results.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/d/datacenters#prefix DataNomadDatacenters#prefix}
    */
    readonly prefix?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/nomad/d/datacenters nomad_datacenters}
*/
export declare class DataNomadDatacenters extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "nomad_datacenters";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/nomad/d/datacenters nomad_datacenters} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNomadDatacentersConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataNomadDatacentersConfig);
    get datacenters(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ignoreDownNodes?;
    get ignoreDownNodes(): boolean | cdktf.IResolvable;
    set ignoreDownNodes(value: boolean | cdktf.IResolvable);
    resetIgnoreDownNodes(): void;
    get ignoreDownNodesInput(): boolean | cdktf.IResolvable | undefined;
    private _prefix?;
    get prefix(): string;
    set prefix(value: string);
    resetPrefix(): void;
    get prefixInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
