import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNomadAclTokenConfig extends cdktf.TerraformMetaArguments {
    /**
    * Non-sensitive identifier for this token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/d/acl_token#accessor_id DataNomadAclToken#accessor_id}
    */
    readonly accessorId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/d/acl_token#id DataNomadAclToken#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/nomad/d/acl_token nomad_acl_token}
*/
export declare class DataNomadAclToken extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "nomad_acl_token";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/nomad/d/acl_token nomad_acl_token} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNomadAclTokenConfig
    */
    constructor(scope: Construct, id: string, config: DataNomadAclTokenConfig);
    private _accessorId?;
    get accessorId(): string;
    set accessorId(value: string);
    get accessorIdInput(): string | undefined;
    get createTime(): string;
    get global(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    get policies(): string[];
    get secretId(): string;
    get type(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
