# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class SmartAccountAddress(BaseModel):
    """
    Smart account owner address
    """ # noqa: E501
    address_type: Optional[StrictStr] = Field(default=None, description="Owner address type", alias="addressType")
    postal_code: Optional[StrictStr] = Field(default=None, description="Owner address postal code", alias="postalCode")
    street_name: Optional[StrictStr] = Field(default=None, description="Owner address street name", alias="streetName")
    street_number: Optional[StrictStr] = Field(default=None, description="Owner address street number", alias="streetNumber")
    city: StrictStr = Field(description="Owner address city")
    state: Optional[StrictStr] = Field(default=None, description="Owner address state")
    is_primary_address: Optional[StrictBool] = Field(default=None, description="Indicates if the owner address is the primary one", alias="isPrimaryAddress")
    is_mailing_address: Optional[StrictBool] = Field(default=None, description="Indicates if the owner address is the mailing one", alias="isMailingAddress")
    __properties: ClassVar[List[str]] = ["addressType", "postalCode", "streetName", "streetNumber", "city", "state", "isPrimaryAddress", "isMailingAddress"]

    @field_validator('address_type')
    def address_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['residential', 'commercial']):
            raise ValueError("must be one of enum values ('residential', 'commercial')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SmartAccountAddress from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SmartAccountAddress from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "addressType": obj.get("addressType"),
            "postalCode": obj.get("postalCode"),
            "streetName": obj.get("streetName"),
            "streetNumber": obj.get("streetNumber"),
            "city": obj.get("city"),
            "state": obj.get("state"),
            "isPrimaryAddress": obj.get("isPrimaryAddress"),
            "isMailingAddress": obj.get("isMailingAddress")
        })
        return _obj


