# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from pluggy_sdk.models.document import Document
from typing import Optional, Set
from typing_extensions import Self

class PaymentDataParticipant(BaseModel):
    """
    Participant of the payment data
    """ # noqa: E501
    document_number: Optional[Document] = Field(default=None, alias="documentNumber")
    name: Optional[StrictStr] = Field(default=None, description="Fullname of the participant")
    account_number: Optional[StrictStr] = Field(default=None, description="Account number on the branch", alias="accountNumber")
    branch_number: Optional[StrictStr] = Field(default=None, description="Agency number", alias="branchNumber")
    routing_number: Optional[StrictStr] = Field(default=None, description="COMPE Bank number", alias="routingNumber")
    routing_number_ispb: Optional[StrictStr] = Field(default=None, description="ISPB Bank number", alias="routingNumberISPB")
    __properties: ClassVar[List[str]] = ["documentNumber", "name", "accountNumber", "branchNumber", "routingNumber", "routingNumberISPB"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PaymentDataParticipant from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of document_number
        if self.document_number:
            _dict['documentNumber'] = self.document_number.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PaymentDataParticipant from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "documentNumber": Document.from_dict(obj["documentNumber"]) if obj.get("documentNumber") is not None else None,
            "name": obj.get("name"),
            "accountNumber": obj.get("accountNumber"),
            "branchNumber": obj.get("branchNumber"),
            "routingNumber": obj.get("routingNumber"),
            "routingNumberISPB": obj.get("routingNumberISPB")
        })
        return _obj


