# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class LoanContractedFee(BaseModel):
    """
    LoanContractedFee
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Agreed rate denomination")
    code: Optional[StrictStr] = Field(default=None, description="Acronym identifying the agreed rate")
    charge_type: Optional[StrictStr] = Field(default=None, description="Charge type for the rate agreed in the contract", alias="chargeType")
    charge: Optional[StrictStr] = Field(default=None, description="Billing method related to the tariff agreed in the contract")
    amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Monetary value of the tariff agreed in the contract")
    rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Rate value in percentage agreed in the contract")
    __properties: ClassVar[List[str]] = ["name", "code", "chargeType", "charge", "amount", "rate"]

    @field_validator('charge_type')
    def charge_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['UNIQUE', 'BY_INSTALLMENT']):
            raise ValueError("must be one of enum values ('UNIQUE', 'BY_INSTALLMENT')")
        return value

    @field_validator('charge')
    def charge_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['MINIMUM', 'MAXIMUM', 'FIXED', 'PERCENTAGE']):
            raise ValueError("must be one of enum values ('MINIMUM', 'MAXIMUM', 'FIXED', 'PERCENTAGE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LoanContractedFee from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LoanContractedFee from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "code": obj.get("code"),
            "chargeType": obj.get("chargeType"),
            "charge": obj.get("charge"),
            "amount": obj.get("amount"),
            "rate": obj.get("rate")
        })
        return _obj


