# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date, datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from pluggy_sdk.models.loan_contracted_fee import LoanContractedFee
from pluggy_sdk.models.loan_contracted_finance_charge import LoanContractedFinanceCharge
from pluggy_sdk.models.loan_installments import LoanInstallments
from pluggy_sdk.models.loan_interest_rate import LoanInterestRate
from pluggy_sdk.models.loan_payments import LoanPayments
from pluggy_sdk.models.loan_warranty import LoanWarranty
from typing import Optional, Set
from typing_extensions import Self

class Loan(BaseModel):
    """
    Response with information related to a loan
    """ # noqa: E501
    id: StrictStr = Field(description="Primary identifier")
    item_id: StrictStr = Field(description="Identifier of the item linked to the loan", alias="itemId")
    contract_number: Optional[StrictStr] = Field(default=None, description="Contract number given by the contracting institution", alias="contractNumber")
    ipoc_code: Optional[StrictStr] = Field(default=None, description="Standard contract number - IPOC (Identificação Padronizada da Operação de Crédito)", alias="ipocCode")
    product_name: StrictStr = Field(description="Denomination/Identification of the name of the credit operation disclosed to the customer", alias="productName")
    type: Optional[StrictStr] = Field(default=None, description="Loan type (https://openbanking-brasil.github.io/openapi/swagger-apis/loans/?urls.primaryName=2.0.1#model-EnumContractProductSubTypeLoans)")
    var_date: datetime = Field(description="Date when the loan data was collected", alias="date")
    contract_date: Optional[datetime] = Field(default=None, description="Date when the loan was contracted", alias="contractDate")
    disbursement_dates: Optional[List[date]] = Field(default=None, description="Disbursement date of the contracted amount", alias="disbursementDates")
    settlement_date: Optional[datetime] = Field(default=None, description="Loan settlement date", alias="settlementDate")
    contract_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Loan contracted value", alias="contractAmount")
    currency_code: StrictStr = Field(description="Code referencing the currency of the loan", alias="currencyCode")
    due_date: Optional[datetime] = Field(default=None, description="Loan due date", alias="dueDate")
    installment_periodicity: Optional[StrictStr] = Field(default=None, description="Installments regular frequency", alias="installmentPeriodicity")
    installment_periodicity_additional_info: Optional[StrictStr] = Field(default=None, description="Mandatory field to complement the information regarding the regular payment frequency when installmentPeriodicity has value 'OTHERS'", alias="installmentPeriodicityAdditionalInfo")
    first_installment_due_date: Optional[datetime] = Field(default=None, description="First installment due date", alias="firstInstallmentDueDate")
    cet: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="CET - Custo Efetivo Total must be expressed as an annual percentage rate and incorporates all charges and expenses incurred in credit operations (interest rate, but also tariffs, taxes, insurance and other expenses charged)", alias="CET")
    amortization_scheduled: Optional[StrictStr] = Field(default=None, description="Amortization system (https://openbanking-brasil.github.io/openapi/swagger-apis/loans/?urls.primaryName=2.0.1#model-EnumContractAmortizationScheduled)", alias="amortizationScheduled")
    amortization_scheduled_additional_info: Optional[StrictStr] = Field(default=None, description="Mandatory field to complement the information regarding the scheduled amortization when it has value 'OTHERS'", alias="amortizationScheduledAdditionalInfo")
    cnpj_consignee: Optional[StrictStr] = Field(default=None, description="Consignor CNPJ", alias="cnpjConsignee")
    interest_rates: Optional[List[LoanInterestRate]] = Field(default=None, alias="interestRates")
    contracted_fees: Optional[List[LoanContractedFee]] = Field(default=None, description="List that brings the information of the tariffs agreed in the contract.", alias="contractedFees")
    contracted_finance_charges: Optional[List[LoanContractedFinanceCharge]] = Field(default=None, description="List that brings the charges agreed in the contract", alias="contractedFinanceCharges")
    warranties: Optional[List[LoanWarranty]] = None
    installments: Optional[LoanInstallments] = None
    payments: Optional[LoanPayments] = Field(default=None, description="Loan contract payment data")
    __properties: ClassVar[List[str]] = ["id", "itemId", "contractNumber", "ipocCode", "productName", "type", "date", "contractDate", "disbursementDates", "settlementDate", "contractAmount", "currencyCode", "dueDate", "installmentPeriodicity", "installmentPeriodicityAdditionalInfo", "firstInstallmentDueDate", "CET", "amortizationScheduled", "amortizationScheduledAdditionalInfo", "cnpjConsignee", "interestRates", "contractedFees", "contractedFinanceCharges", "warranties", "installments", "payments"]

    @field_validator('installment_periodicity')
    def installment_periodicity_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['WITHOUT_REGULAR_PERIODICITY', 'WEEKLY', 'FORTNIGHTLY', 'MONTHLY', 'BIMONTHLY', 'QUARTERLY', 'SEMESTERLY', 'YEARLY', 'OTHERS']):
            raise ValueError("must be one of enum values ('WITHOUT_REGULAR_PERIODICITY', 'WEEKLY', 'FORTNIGHTLY', 'MONTHLY', 'BIMONTHLY', 'QUARTERLY', 'SEMESTERLY', 'YEARLY', 'OTHERS')")
        return value

    @field_validator('amortization_scheduled')
    def amortization_scheduled_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['SAC', 'PRICE', 'SAM', 'WITHOUT_AMORTIZATION_SYSTEM', 'OTHERS']):
            raise ValueError("must be one of enum values ('SAC', 'PRICE', 'SAM', 'WITHOUT_AMORTIZATION_SYSTEM', 'OTHERS')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Loan from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in interest_rates (list)
        _items = []
        if self.interest_rates:
            for _item in self.interest_rates:
                if _item:
                    _items.append(_item.to_dict())
            _dict['interestRates'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in contracted_fees (list)
        _items = []
        if self.contracted_fees:
            for _item in self.contracted_fees:
                if _item:
                    _items.append(_item.to_dict())
            _dict['contractedFees'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in contracted_finance_charges (list)
        _items = []
        if self.contracted_finance_charges:
            for _item in self.contracted_finance_charges:
                if _item:
                    _items.append(_item.to_dict())
            _dict['contractedFinanceCharges'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in warranties (list)
        _items = []
        if self.warranties:
            for _item in self.warranties:
                if _item:
                    _items.append(_item.to_dict())
            _dict['warranties'] = _items
        # override the default output from pydantic by calling `to_dict()` of installments
        if self.installments:
            _dict['installments'] = self.installments.to_dict()
        # override the default output from pydantic by calling `to_dict()` of payments
        if self.payments:
            _dict['payments'] = self.payments.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Loan from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "itemId": obj.get("itemId"),
            "contractNumber": obj.get("contractNumber"),
            "ipocCode": obj.get("ipocCode"),
            "productName": obj.get("productName"),
            "type": obj.get("type"),
            "date": obj.get("date"),
            "contractDate": obj.get("contractDate"),
            "disbursementDates": obj.get("disbursementDates"),
            "settlementDate": obj.get("settlementDate"),
            "contractAmount": obj.get("contractAmount"),
            "currencyCode": obj.get("currencyCode"),
            "dueDate": obj.get("dueDate"),
            "installmentPeriodicity": obj.get("installmentPeriodicity"),
            "installmentPeriodicityAdditionalInfo": obj.get("installmentPeriodicityAdditionalInfo"),
            "firstInstallmentDueDate": obj.get("firstInstallmentDueDate"),
            "CET": obj.get("CET"),
            "amortizationScheduled": obj.get("amortizationScheduled"),
            "amortizationScheduledAdditionalInfo": obj.get("amortizationScheduledAdditionalInfo"),
            "cnpjConsignee": obj.get("cnpjConsignee"),
            "interestRates": [LoanInterestRate.from_dict(_item) for _item in obj["interestRates"]] if obj.get("interestRates") is not None else None,
            "contractedFees": [LoanContractedFee.from_dict(_item) for _item in obj["contractedFees"]] if obj.get("contractedFees") is not None else None,
            "contractedFinanceCharges": [LoanContractedFinanceCharge.from_dict(_item) for _item in obj["contractedFinanceCharges"]] if obj.get("contractedFinanceCharges") is not None else None,
            "warranties": [LoanWarranty.from_dict(_item) for _item in obj["warranties"]] if obj.get("warranties") is not None else None,
            "installments": LoanInstallments.from_dict(obj["installments"]) if obj.get("installments") is not None else None,
            "payments": LoanPayments.from_dict(obj["payments"]) if obj.get("payments") is not None else None
        })
        return _obj


