# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class InvestmentExpenses(BaseModel):
    """
    Taxes and fees that applied to the transaction
    """ # noqa: E501
    service_tax: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="(ISS) Service tax that varies according to state", alias="serviceTax")
    brokerage_fee: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Commission charged by the brokerage for carrying out transactions on the stock market", alias="brokerageFee")
    income_tax: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="(IRRF) Income Tax Withholding, amount paid to the Internal Revenue Service", alias="incomeTax")
    trading_assets_notice_fee: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="(ANA) Fee of Notice of Trading in Assets", alias="tradingAssetsNoticeFee")
    maintenance_fee: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="(termo/opções) Fees charged by BM&F Bovespa in negotiations", alias="maintenanceFee")
    settlement_fee: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Liquidation fee for the settlement of a position on the expiration date or the financial settlement of physical delivery", alias="settlementFee")
    clearing_fee: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Registration fee", alias="clearingFee")
    stock_exchange_fee: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="(Emolumentos) Fees charged by BM&F Bovespa as a source of operating income", alias="stockExchangeFee")
    custody_fee: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Fee by brokers to keep recordsin their home broker systems or on the trading desk", alias="custodyFee")
    operating_fee: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Amount paid to the Operator for the intermediation service", alias="operatingFee")
    other: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Sum of other not defined expenses")
    __properties: ClassVar[List[str]] = ["serviceTax", "brokerageFee", "incomeTax", "tradingAssetsNoticeFee", "maintenanceFee", "settlementFee", "clearingFee", "stockExchangeFee", "custodyFee", "operatingFee", "other"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InvestmentExpenses from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InvestmentExpenses from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "serviceTax": obj.get("serviceTax"),
            "brokerageFee": obj.get("brokerageFee"),
            "incomeTax": obj.get("incomeTax"),
            "tradingAssetsNoticeFee": obj.get("tradingAssetsNoticeFee"),
            "maintenanceFee": obj.get("maintenanceFee"),
            "settlementFee": obj.get("settlementFee"),
            "clearingFee": obj.get("clearingFee"),
            "stockExchangeFee": obj.get("stockExchangeFee"),
            "custodyFee": obj.get("custodyFee"),
            "operatingFee": obj.get("operatingFee"),
            "other": obj.get("other")
        })
        return _obj


