# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from pluggy_sdk.models.address import Address
from pluggy_sdk.models.email import Email
from pluggy_sdk.models.identity_relation import IdentityRelation
from pluggy_sdk.models.phone_number import PhoneNumber
from typing import Optional, Set
from typing_extensions import Self

class IdentityResponse(BaseModel):
    """
    Response with details personal information related to the owner of the connection's account
    """ # noqa: E501
    id: StrictStr = Field(description="The ID of the identity to retrieve")
    item_id: StrictStr = Field(description="Identifier of the item linked to the identity", alias="itemId")
    birth_date: Optional[datetime] = Field(default=None, description="Date of birth", alias="birthDate")
    tax_number: Optional[StrictStr] = Field(default=None, description="The tax ID (CNPJ) associated with the business account", alias="taxNumber")
    document: Optional[StrictStr] = Field(default=None, description="Primary document that identifies the owner")
    document_type: Optional[StrictStr] = Field(default=None, description="Type of document collected", alias="documentType")
    job_title: Optional[StrictStr] = Field(default=None, description="Profession or Job information", alias="jobTitle")
    full_name: Optional[StrictStr] = Field(default=None, description="Name of the owner of the account", alias="fullName")
    establishment_code: Optional[StrictStr] = Field(default=None, description="Establishment code (only for PAYMENT_ACCOUNT connectors)", alias="establishmentCode")
    establishment_name: Optional[StrictStr] = Field(default=None, description="Name of the establishment (only for PAYMENT_ACCOUNT connectors)", alias="establishmentName")
    company_name: Optional[StrictStr] = Field(default=None, description="For business connector, the name of the business", alias="companyName")
    phone_numbers: Optional[List[PhoneNumber]] = Field(default=None, description="List of phone numbers related to the account", alias="phoneNumbers")
    emails: Optional[List[Email]] = Field(default=None, description="List of email addresses related to the account")
    addresses: Optional[List[Address]] = Field(default=None, description="List of addresses related to the account")
    relations: Optional[List[IdentityRelation]] = Field(default=None, description="List of names related to the account")
    __properties: ClassVar[List[str]] = ["id", "itemId", "birthDate", "taxNumber", "document", "documentType", "jobTitle", "fullName", "establishmentCode", "establishmentName", "companyName", "phoneNumbers", "emails", "addresses", "relations"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IdentityResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in phone_numbers (list)
        _items = []
        if self.phone_numbers:
            for _item in self.phone_numbers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['phoneNumbers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in emails (list)
        _items = []
        if self.emails:
            for _item in self.emails:
                if _item:
                    _items.append(_item.to_dict())
            _dict['emails'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in addresses (list)
        _items = []
        if self.addresses:
            for _item in self.addresses:
                if _item:
                    _items.append(_item.to_dict())
            _dict['addresses'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in relations (list)
        _items = []
        if self.relations:
            for _item in self.relations:
                if _item:
                    _items.append(_item.to_dict())
            _dict['relations'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IdentityResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "itemId": obj.get("itemId"),
            "birthDate": obj.get("birthDate"),
            "taxNumber": obj.get("taxNumber"),
            "document": obj.get("document"),
            "documentType": obj.get("documentType"),
            "jobTitle": obj.get("jobTitle"),
            "fullName": obj.get("fullName"),
            "establishmentCode": obj.get("establishmentCode"),
            "establishmentName": obj.get("establishmentName"),
            "companyName": obj.get("companyName"),
            "phoneNumbers": [PhoneNumber.from_dict(_item) for _item in obj["phoneNumbers"]] if obj.get("phoneNumbers") is not None else None,
            "emails": [Email.from_dict(_item) for _item in obj["emails"]] if obj.get("emails") is not None else None,
            "addresses": [Address.from_dict(_item) for _item in obj["addresses"]] if obj.get("addresses") is not None else None,
            "relations": [IdentityRelation.from_dict(_item) for _item in obj["relations"]] if obj.get("relations") is not None else None
        })
        return _obj


