# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class CreditCardMetadata(BaseModel):
    """
    Data of a transaction specific to credit card transactions
    """ # noqa: E501
    installment_number: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Number of the current installment of the purchase", alias="installmentNumber")
    total_installments: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Total number of installments of the purchase", alias="totalInstallments")
    total_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Total amount of the purchase", alias="totalAmount")
    purchase_date: Optional[datetime] = Field(default=None, description="Original Date of the purchase", alias="purchaseDate")
    payee_mcc: Optional[StrictStr] = Field(default=None, description="Merchant Category Code of the merchant", alias="payeeMCC")
    card_number: Optional[StrictStr] = Field(default=None, description="Credit Card Number associated with transaction, can be different from the account if its done by an additional or virtual card.", alias="cardNumber")
    bill_id: Optional[StrictStr] = Field(default=None, description="Id of the bill associated to this transaction", alias="billId")
    __properties: ClassVar[List[str]] = ["installmentNumber", "totalInstallments", "totalAmount", "purchaseDate", "payeeMCC", "cardNumber", "billId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreditCardMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreditCardMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "installmentNumber": obj.get("installmentNumber"),
            "totalInstallments": obj.get("totalInstallments"),
            "totalAmount": obj.get("totalAmount"),
            "purchaseDate": obj.get("purchaseDate"),
            "payeeMCC": obj.get("payeeMCC"),
            "cardNumber": obj.get("cardNumber"),
            "billId": obj.get("billId")
        })
        return _obj


