# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from pluggy_sdk.models.credential_select_option import CredentialSelectOption
from typing import Optional, Set
from typing_extensions import Self

class ConnectorCredential(BaseModel):
    """
    Credential details for a connector
    """ # noqa: E501
    name: StrictStr = Field(description="Name of the key")
    label: StrictStr = Field(description="Label for input")
    type: StrictStr = Field(description="Type of credential required")
    assistive_text: Optional[StrictStr] = Field(default=None, description="Text to help the user when completing the input", alias="assistiveText")
    data: Optional[StrictStr] = Field(default=None, description="Used to return base64 images")
    placeholder: Optional[StrictStr] = Field(default=None, description="Placeholder text for the input")
    validation: Optional[StrictStr] = Field(default=None, description="Regex validation for the user's input")
    validation_message: Optional[StrictStr] = Field(default=None, description="Validation message when input doesn't match the regex", alias="validationMessage")
    mfa: Optional[StrictBool] = Field(default=None, description="Credential is an MFA parameter and must be refreshed on each execution")
    options: Optional[List[CredentialSelectOption]] = Field(default=None, description="List of possible values for the input")
    __properties: ClassVar[List[str]] = ["name", "label", "type", "assistiveText", "data", "placeholder", "validation", "validationMessage", "mfa", "options"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['text', 'password', 'number', 'image', 'select']):
            raise ValueError("must be one of enum values ('text', 'password', 'number', 'image', 'select')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ConnectorCredential from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in options (list)
        _items = []
        if self.options:
            for _item in self.options:
                if _item:
                    _items.append(_item.to_dict())
            _dict['options'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ConnectorCredential from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "label": obj.get("label"),
            "type": obj.get("type"),
            "assistiveText": obj.get("assistiveText"),
            "data": obj.get("data"),
            "placeholder": obj.get("placeholder"),
            "validation": obj.get("validation"),
            "validationMessage": obj.get("validationMessage"),
            "mfa": obj.get("mfa"),
            "options": [CredentialSelectOption.from_dict(_item) for _item in obj["options"]] if obj.get("options") is not None else None
        })
        return _obj


