# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from pluggy_sdk.models.acquirer_sale_installment import AcquirerSaleInstallment
from typing import Optional, Set
from typing_extensions import Self

class AcquirerSaleData(BaseModel):
    """
    AcquirerSaleData
    """ # noqa: E501
    nsu: StrictStr = Field(description="Tax id of the transaction")
    authorization_code: Optional[StrictStr] = Field(default=None, description="Code generated by the card issuer to authorize the sale", alias="authorizationCode")
    payment_method: Optional[StrictStr] = Field(default=None, alias="paymentMethod")
    net_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The total net amount of the sale", alias="netAmount")
    mdr_fee: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Merchant discount rate percentage", alias="mdrFee")
    mdr_fee_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Merchant discount rate ampount", alias="mdrFeeAmount")
    status: Optional[StrictStr] = None
    installment_count: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Number of installments of the sale", alias="installmentCount")
    installments: Optional[List[AcquirerSaleInstallment]] = None
    card_flag: Optional[StrictStr] = Field(default=None, description="Flag of the card used", alias="cardFlag")
    card_number: Optional[StrictStr] = Field(default=None, description="Masked number of the card used", alias="cardNumber")
    card_funding_source: Optional[StrictStr] = Field(default=None, alias="cardFundingSource")
    terminal_id: Optional[StrictStr] = Field(default=None, description="Id of the terminal (posnet) used for the sale", alias="terminalId")
    __properties: ClassVar[List[str]] = ["nsu", "authorizationCode", "paymentMethod", "netAmount", "mdrFee", "mdrFeeAmount", "status", "installmentCount", "installments", "cardFlag", "cardNumber", "cardFundingSource", "terminalId"]

    @field_validator('payment_method')
    def payment_method_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['CARD', 'PIX']):
            raise ValueError("must be one of enum values ('CARD', 'PIX')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['APPROVED', 'CANCELLED']):
            raise ValueError("must be one of enum values ('APPROVED', 'CANCELLED')")
        return value

    @field_validator('card_funding_source')
    def card_funding_source_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['CREDIT', 'DEBIT']):
            raise ValueError("must be one of enum values ('CREDIT', 'DEBIT')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AcquirerSaleData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in installments (list)
        _items = []
        if self.installments:
            for _item in self.installments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['installments'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AcquirerSaleData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "nsu": obj.get("nsu"),
            "authorizationCode": obj.get("authorizationCode"),
            "paymentMethod": obj.get("paymentMethod"),
            "netAmount": obj.get("netAmount"),
            "mdrFee": obj.get("mdrFee"),
            "mdrFeeAmount": obj.get("mdrFeeAmount"),
            "status": obj.get("status"),
            "installmentCount": obj.get("installmentCount"),
            "installments": [AcquirerSaleInstallment.from_dict(_item) for _item in obj["installments"]] if obj.get("installments") is not None else None,
            "cardFlag": obj.get("cardFlag"),
            "cardNumber": obj.get("cardNumber"),
            "cardFundingSource": obj.get("cardFundingSource"),
            "terminalId": obj.get("terminalId")
        })
        return _obj


