# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from pluggy_sdk.models.acquirer_sale_installment_data import AcquirerSaleInstallmentData
from typing import Optional, Set
from typing_extensions import Self

class AcquirerSale(BaseModel):
    """
    Acquirer Sale product
    """ # noqa: E501
    id: StrictStr = Field(description="Primary identifier of the acquirer sale")
    item_id: StrictStr = Field(description="Primary identifier of the item associated to the acquirer sale", alias="itemId")
    description: StrictStr = Field(description="Clean description of the acquirer sale")
    currency_code: StrictStr = Field(description="Currency ISO code", alias="currencyCode")
    var_date: datetime = Field(description="Date when the acquirer sale was made", alias="date")
    gross_amount: Union[StrictFloat, StrictInt] = Field(description="Acquirer sale gross amount", alias="grossAmount")
    payment_method: Optional[StrictStr] = Field(default=None, description="Acquirer sale payment method", alias="paymentMethod")
    authorization_code: Optional[StrictStr] = Field(default=None, description="Code generated by the card issuer to authorize the sale", alias="authorizationCode")
    card_flag: Optional[StrictStr] = Field(default=None, description="Flag of the card used", alias="cardFlag")
    card_number: Optional[StrictStr] = Field(default=None, description="Masked card number of the card used", alias="cardNumber")
    card_funding_source: Optional[StrictStr] = Field(default=None, description="CREDIT or DEBIT", alias="cardFundingSource")
    nsu: Optional[StrictStr] = Field(default=None, description="Tax id of the transaction")
    status: Optional[StrictStr] = Field(default=None, description="Acquirer sale status")
    net_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Acquirer sale net amount", alias="netAmount")
    mdr_fee: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Percentage of the merchant discount rate", alias="mdrFee")
    mdr_fee_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Total amount of the merchant discount rate", alias="mdrFeeAmount")
    installments: Optional[List[AcquirerSaleInstallmentData]] = None
    terminal_id: Optional[StrictStr] = Field(default=None, description="Id of the terminal (maquininha) used for the sale", alias="terminalId")
    __properties: ClassVar[List[str]] = ["id", "itemId", "description", "currencyCode", "date", "grossAmount", "paymentMethod", "authorizationCode", "cardFlag", "cardNumber", "cardFundingSource", "nsu", "status", "netAmount", "mdrFee", "mdrFeeAmount", "installments", "terminalId"]

    @field_validator('payment_method')
    def payment_method_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['CARD', 'PIX']):
            raise ValueError("must be one of enum values ('CARD', 'PIX')")
        return value

    @field_validator('card_flag')
    def card_flag_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['VISA', 'MASTERCARD', 'AMEX', 'ELO', 'CABAL', 'OTHER']):
            raise ValueError("must be one of enum values ('VISA', 'MASTERCARD', 'AMEX', 'ELO', 'CABAL', 'OTHER')")
        return value

    @field_validator('card_funding_source')
    def card_funding_source_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['CREDIT', 'DEBIT']):
            raise ValueError("must be one of enum values ('CREDIT', 'DEBIT')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['APPROVED', 'CANCELLED']):
            raise ValueError("must be one of enum values ('APPROVED', 'CANCELLED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AcquirerSale from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in installments (list)
        _items = []
        if self.installments:
            for _item in self.installments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['installments'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AcquirerSale from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "itemId": obj.get("itemId"),
            "description": obj.get("description"),
            "currencyCode": obj.get("currencyCode"),
            "date": obj.get("date"),
            "grossAmount": obj.get("grossAmount"),
            "paymentMethod": obj.get("paymentMethod"),
            "authorizationCode": obj.get("authorizationCode"),
            "cardFlag": obj.get("cardFlag"),
            "cardNumber": obj.get("cardNumber"),
            "cardFundingSource": obj.get("cardFundingSource"),
            "nsu": obj.get("nsu"),
            "status": obj.get("status"),
            "netAmount": obj.get("netAmount"),
            "mdrFee": obj.get("mdrFee"),
            "mdrFeeAmount": obj.get("mdrFeeAmount"),
            "installments": [AcquirerSaleInstallmentData.from_dict(_item) for _item in obj["installments"]] if obj.get("installments") is not None else None,
            "terminalId": obj.get("terminalId")
        })
        return _obj


