# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class AcquirerAnticipation(BaseModel):
    """
    Acquirer Anticipation product
    """ # noqa: E501
    id: StrictStr = Field(description="Primary identifier of the acquirer anticipation")
    item_id: StrictStr = Field(description="Primary identifier of the item associated to the acquirer anticipation", alias="itemId")
    description: StrictStr = Field(description="Clean description of the acquirer anticipation")
    currency_code: StrictStr = Field(description="Currency ISO code", alias="currencyCode")
    var_date: datetime = Field(description="Date when the acquirer anticipation was requested", alias="date")
    gross_amount: Union[StrictFloat, StrictInt] = Field(description="Acquirer anticipation gross amount", alias="grossAmount")
    status: Optional[StrictStr] = Field(default=None, description="Status of the payment anticipation")
    net_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Acquirer anticipation net amount", alias="netAmount")
    fee: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Percentage of monthly fee (e.g 1.5 = 1.5%)")
    fee_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Fee amount", alias="feeAmount")
    __properties: ClassVar[List[str]] = ["id", "itemId", "description", "currencyCode", "date", "grossAmount", "status", "netAmount", "fee", "feeAmount"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['SIMULATED', 'REQUESTED', 'CANCELLED', 'IN_ANALYSIS', 'APPROVED']):
            raise ValueError("must be one of enum values ('SIMULATED', 'REQUESTED', 'CANCELLED', 'IN_ANALYSIS', 'APPROVED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AcquirerAnticipation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AcquirerAnticipation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "itemId": obj.get("itemId"),
            "description": obj.get("description"),
            "currencyCode": obj.get("currencyCode"),
            "date": obj.get("date"),
            "grossAmount": obj.get("grossAmount"),
            "status": obj.get("status"),
            "netAmount": obj.get("netAmount"),
            "fee": obj.get("fee"),
            "feeAmount": obj.get("feeAmount")
        })
        return _obj


