# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Dict, List, Optional, Union
from typing_extensions import Annotated
from pluggy_sdk.models.connector import Connector
from pluggy_sdk.models.connector_list_response import ConnectorListResponse
from pluggy_sdk.models.parameter_validation_response import ParameterValidationResponse

from pluggy_sdk.api_client import ApiClient, RequestSerialized
from pluggy_sdk.api_response import ApiResponse
from pluggy_sdk.rest import RESTResponseType


class ConnectorApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def connector_retrieve(
        self,
        id: Annotated[Union[StrictFloat, StrictInt], Field(description="Connector primary identifier")],
        health_details: Annotated[Optional[StrictBool], Field(description="Include health details about latest connections and percentage of errors (connection rate)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Connector:
        """Retrieve

        This endpoint retrieves a specific connector.

        :param id: Connector primary identifier (required)
        :type id: float
        :param health_details: Include health details about latest connections and percentage of errors (connection rate)
        :type health_details: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._connector_retrieve_serialize(
            id=id,
            health_details=health_details,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Connector",
            '404': "GlobalErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def connector_retrieve_with_http_info(
        self,
        id: Annotated[Union[StrictFloat, StrictInt], Field(description="Connector primary identifier")],
        health_details: Annotated[Optional[StrictBool], Field(description="Include health details about latest connections and percentage of errors (connection rate)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Connector]:
        """Retrieve

        This endpoint retrieves a specific connector.

        :param id: Connector primary identifier (required)
        :type id: float
        :param health_details: Include health details about latest connections and percentage of errors (connection rate)
        :type health_details: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._connector_retrieve_serialize(
            id=id,
            health_details=health_details,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Connector",
            '404': "GlobalErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def connector_retrieve_without_preload_content(
        self,
        id: Annotated[Union[StrictFloat, StrictInt], Field(description="Connector primary identifier")],
        health_details: Annotated[Optional[StrictBool], Field(description="Include health details about latest connections and percentage of errors (connection rate)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve

        This endpoint retrieves a specific connector.

        :param id: Connector primary identifier (required)
        :type id: float
        :param health_details: Include health details about latest connections and percentage of errors (connection rate)
        :type health_details: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._connector_retrieve_serialize(
            id=id,
            health_details=health_details,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Connector",
            '404': "GlobalErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _connector_retrieve_serialize(
        self,
        id,
        health_details,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if health_details is not None:
            
            _query_params.append(('healthDetails', health_details))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'default'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/connectors/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def connectors_list(
        self,
        countries: Annotated[Optional[List[StrictStr]], Field(description="A list of countries of connectors to filter.")] = None,
        types: Annotated[Optional[List[StrictStr]], Field(description="A list of types of connectors to filter.")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Name alike look up of the connector")] = None,
        sandbox: Annotated[Optional[StrictBool], Field(description="Include sandbox connectors if set to true (default: false).")] = None,
        health_details: Annotated[Optional[StrictBool], Field(description="Include health details about latest connections and percentage of errors (connection rate)")] = None,
        is_open_finance: Annotated[Optional[StrictBool], Field(description="Filter connectors by the `isOpenFinance` attribute. If not sent, it won't filter.")] = None,
        supports_payment_initiation: Annotated[Optional[StrictBool], Field(description="Filter connectors by the `supportsPaymentInitiation` attribute. If not sent, it won't filter.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ConnectorListResponse:
        """List

        This endpoint retrieves all available connectors.

        :param countries: A list of countries of connectors to filter.
        :type countries: List[str]
        :param types: A list of types of connectors to filter.
        :type types: List[str]
        :param name: Name alike look up of the connector
        :type name: str
        :param sandbox: Include sandbox connectors if set to true (default: false).
        :type sandbox: bool
        :param health_details: Include health details about latest connections and percentage of errors (connection rate)
        :type health_details: bool
        :param is_open_finance: Filter connectors by the `isOpenFinance` attribute. If not sent, it won't filter.
        :type is_open_finance: bool
        :param supports_payment_initiation: Filter connectors by the `supportsPaymentInitiation` attribute. If not sent, it won't filter.
        :type supports_payment_initiation: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._connectors_list_serialize(
            countries=countries,
            types=types,
            name=name,
            sandbox=sandbox,
            health_details=health_details,
            is_open_finance=is_open_finance,
            supports_payment_initiation=supports_payment_initiation,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ConnectorListResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def connectors_list_with_http_info(
        self,
        countries: Annotated[Optional[List[StrictStr]], Field(description="A list of countries of connectors to filter.")] = None,
        types: Annotated[Optional[List[StrictStr]], Field(description="A list of types of connectors to filter.")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Name alike look up of the connector")] = None,
        sandbox: Annotated[Optional[StrictBool], Field(description="Include sandbox connectors if set to true (default: false).")] = None,
        health_details: Annotated[Optional[StrictBool], Field(description="Include health details about latest connections and percentage of errors (connection rate)")] = None,
        is_open_finance: Annotated[Optional[StrictBool], Field(description="Filter connectors by the `isOpenFinance` attribute. If not sent, it won't filter.")] = None,
        supports_payment_initiation: Annotated[Optional[StrictBool], Field(description="Filter connectors by the `supportsPaymentInitiation` attribute. If not sent, it won't filter.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ConnectorListResponse]:
        """List

        This endpoint retrieves all available connectors.

        :param countries: A list of countries of connectors to filter.
        :type countries: List[str]
        :param types: A list of types of connectors to filter.
        :type types: List[str]
        :param name: Name alike look up of the connector
        :type name: str
        :param sandbox: Include sandbox connectors if set to true (default: false).
        :type sandbox: bool
        :param health_details: Include health details about latest connections and percentage of errors (connection rate)
        :type health_details: bool
        :param is_open_finance: Filter connectors by the `isOpenFinance` attribute. If not sent, it won't filter.
        :type is_open_finance: bool
        :param supports_payment_initiation: Filter connectors by the `supportsPaymentInitiation` attribute. If not sent, it won't filter.
        :type supports_payment_initiation: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._connectors_list_serialize(
            countries=countries,
            types=types,
            name=name,
            sandbox=sandbox,
            health_details=health_details,
            is_open_finance=is_open_finance,
            supports_payment_initiation=supports_payment_initiation,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ConnectorListResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def connectors_list_without_preload_content(
        self,
        countries: Annotated[Optional[List[StrictStr]], Field(description="A list of countries of connectors to filter.")] = None,
        types: Annotated[Optional[List[StrictStr]], Field(description="A list of types of connectors to filter.")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Name alike look up of the connector")] = None,
        sandbox: Annotated[Optional[StrictBool], Field(description="Include sandbox connectors if set to true (default: false).")] = None,
        health_details: Annotated[Optional[StrictBool], Field(description="Include health details about latest connections and percentage of errors (connection rate)")] = None,
        is_open_finance: Annotated[Optional[StrictBool], Field(description="Filter connectors by the `isOpenFinance` attribute. If not sent, it won't filter.")] = None,
        supports_payment_initiation: Annotated[Optional[StrictBool], Field(description="Filter connectors by the `supportsPaymentInitiation` attribute. If not sent, it won't filter.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List

        This endpoint retrieves all available connectors.

        :param countries: A list of countries of connectors to filter.
        :type countries: List[str]
        :param types: A list of types of connectors to filter.
        :type types: List[str]
        :param name: Name alike look up of the connector
        :type name: str
        :param sandbox: Include sandbox connectors if set to true (default: false).
        :type sandbox: bool
        :param health_details: Include health details about latest connections and percentage of errors (connection rate)
        :type health_details: bool
        :param is_open_finance: Filter connectors by the `isOpenFinance` attribute. If not sent, it won't filter.
        :type is_open_finance: bool
        :param supports_payment_initiation: Filter connectors by the `supportsPaymentInitiation` attribute. If not sent, it won't filter.
        :type supports_payment_initiation: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._connectors_list_serialize(
            countries=countries,
            types=types,
            name=name,
            sandbox=sandbox,
            health_details=health_details,
            is_open_finance=is_open_finance,
            supports_payment_initiation=supports_payment_initiation,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ConnectorListResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _connectors_list_serialize(
        self,
        countries,
        types,
        name,
        sandbox,
        health_details,
        is_open_finance,
        supports_payment_initiation,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'countries': 'csv',
            'types': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if countries is not None:
            
            _query_params.append(('countries', countries))
            
        if types is not None:
            
            _query_params.append(('types', types))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if sandbox is not None:
            
            _query_params.append(('sandbox', sandbox))
            
        if health_details is not None:
            
            _query_params.append(('healthDetails', health_details))
            
        if is_open_finance is not None:
            
            _query_params.append(('isOpenFinance', is_open_finance))
            
        if supports_payment_initiation is not None:
            
            _query_params.append(('supportsPaymentInitiation', supports_payment_initiation))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'default'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/connectors',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def connectors_validate(
        self,
        id: Annotated[Union[StrictFloat, StrictInt], Field(description="Connector's primary identifier")],
        request_body: Annotated[Dict[str, StrictStr], Field(description="Connector's input credentials in a key-value object.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ParameterValidationResponse:
        """Validate

        Validates a connector parameters usign the connector validation

        :param id: Connector's primary identifier (required)
        :type id: float
        :param request_body: Connector's input credentials in a key-value object. (required)
        :type request_body: Dict[str, str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._connectors_validate_serialize(
            id=id,
            request_body=request_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ParameterValidationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def connectors_validate_with_http_info(
        self,
        id: Annotated[Union[StrictFloat, StrictInt], Field(description="Connector's primary identifier")],
        request_body: Annotated[Dict[str, StrictStr], Field(description="Connector's input credentials in a key-value object.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ParameterValidationResponse]:
        """Validate

        Validates a connector parameters usign the connector validation

        :param id: Connector's primary identifier (required)
        :type id: float
        :param request_body: Connector's input credentials in a key-value object. (required)
        :type request_body: Dict[str, str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._connectors_validate_serialize(
            id=id,
            request_body=request_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ParameterValidationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def connectors_validate_without_preload_content(
        self,
        id: Annotated[Union[StrictFloat, StrictInt], Field(description="Connector's primary identifier")],
        request_body: Annotated[Dict[str, StrictStr], Field(description="Connector's input credentials in a key-value object.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Validate

        Validates a connector parameters usign the connector validation

        :param id: Connector's primary identifier (required)
        :type id: float
        :param request_body: Connector's input credentials in a key-value object. (required)
        :type request_body: Dict[str, str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._connectors_validate_serialize(
            id=id,
            request_body=request_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ParameterValidationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _connectors_validate_serialize(
        self,
        id,
        request_body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if request_body is not None:
            _body_params = request_body


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'default'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/connectors/{id}/validate',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


