# Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
# with the License. A copy of the License is located at http://aws.amazon.com/apache2.0/
# or in the "LICENSE.txt" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES
# OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions and
# limitations under the License.

# pylint: disable=R0801


from pcluster.api import util
from pcluster.api.models.base_model_ import Model


class ConflictExceptionResponseContent(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, message=None):
        """ConflictExceptionResponseContent - a model defined in OpenAPI

        :param message: The message of this ConflictExceptionResponseContent.
        :type message: str
        """
        self.openapi_types = {"message": str}

        self.attribute_map = {"message": "message"}

        self._message = message

    @classmethod
    def from_dict(cls, dikt) -> "ConflictExceptionResponseContent":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ConflictExceptionResponseContent of this ConflictExceptionResponseContent.
        :rtype: ConflictExceptionResponseContent
        """
        return util.deserialize_model(dikt, cls)

    @property
    def message(self):
        """Gets the message of this ConflictExceptionResponseContent.


        :return: The message of this ConflictExceptionResponseContent.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this ConflictExceptionResponseContent.


        :param message: The message of this ConflictExceptionResponseContent.
        :type message: str
        """

        self._message = message
