#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['apidaora',
 'apidaora.asgi',
 'apidaora.controllers',
 'apidaora.core',
 'apidaora.route']

package_data = \
{'': ['*']}

install_requires = \
['jsondaora', 'dictdaora']

extras_require = \
{'doc': ['mkdocs', 'mkdocs-material', 'markdown-include'],
 'redis': ['aioredis'],
 'test': ['asgi-testclient',
          'bumpversion',
          'black',
          'flake8',
          'isort',
          'ipython',
          'mypy',
          'pytest-asyncio',
          'pytest-cov',
          'pytest-mock',
          'pytest>=5.1.1',
          'uvicorn',
          'aioredis']}

setup(name='apidaora',
      version='0.14.2',
      description='ASGI App using dataclasses module for request/response objects',
      author='Diogo Dutra',
      author_email='diogodutradamata@gmail.com',
      url='https://github.com/dutradda/apidaora',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.8',
     )
