# coding: utf-8

"""
    convertapi

    Convert API lets you effortlessly convert file formats and types.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cloudmersive_convert_api_client.models.docx_table_row import DocxTableRow  # noqa: F401,E501


class UpdateDocxTableRowRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'input_file_bytes': 'str',
        'input_file_url': 'str',
        'row_to_update': 'DocxTableRow',
        'table_row_index': 'int',
        'existing_table_path': 'str'
    }

    attribute_map = {
        'input_file_bytes': 'InputFileBytes',
        'input_file_url': 'InputFileUrl',
        'row_to_update': 'RowToUpdate',
        'table_row_index': 'TableRowIndex',
        'existing_table_path': 'ExistingTablePath'
    }

    def __init__(self, input_file_bytes=None, input_file_url=None, row_to_update=None, table_row_index=None, existing_table_path=None):  # noqa: E501
        """UpdateDocxTableRowRequest - a model defined in Swagger"""  # noqa: E501

        self._input_file_bytes = None
        self._input_file_url = None
        self._row_to_update = None
        self._table_row_index = None
        self._existing_table_path = None
        self.discriminator = None

        if input_file_bytes is not None:
            self.input_file_bytes = input_file_bytes
        if input_file_url is not None:
            self.input_file_url = input_file_url
        if row_to_update is not None:
            self.row_to_update = row_to_update
        if table_row_index is not None:
            self.table_row_index = table_row_index
        if existing_table_path is not None:
            self.existing_table_path = existing_table_path

    @property
    def input_file_bytes(self):
        """Gets the input_file_bytes of this UpdateDocxTableRowRequest.  # noqa: E501

        Optional: Bytes of the input file to operate on  # noqa: E501

        :return: The input_file_bytes of this UpdateDocxTableRowRequest.  # noqa: E501
        :rtype: str
        """
        return self._input_file_bytes

    @input_file_bytes.setter
    def input_file_bytes(self, input_file_bytes):
        """Sets the input_file_bytes of this UpdateDocxTableRowRequest.

        Optional: Bytes of the input file to operate on  # noqa: E501

        :param input_file_bytes: The input_file_bytes of this UpdateDocxTableRowRequest.  # noqa: E501
        :type: str
        """
        if input_file_bytes is not None and not re.search(r'^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$', input_file_bytes):  # noqa: E501
            raise ValueError(r"Invalid value for `input_file_bytes`, must be a follow pattern or equal to `/^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$/`")  # noqa: E501

        self._input_file_bytes = input_file_bytes

    @property
    def input_file_url(self):
        """Gets the input_file_url of this UpdateDocxTableRowRequest.  # noqa: E501

        Optional: URL of a file to operate on as input.  This can be a public URL, or you can also use the begin-editing API to upload a document and pass in the secure URL result from that operation as the URL here (this URL is not public).  # noqa: E501

        :return: The input_file_url of this UpdateDocxTableRowRequest.  # noqa: E501
        :rtype: str
        """
        return self._input_file_url

    @input_file_url.setter
    def input_file_url(self, input_file_url):
        """Sets the input_file_url of this UpdateDocxTableRowRequest.

        Optional: URL of a file to operate on as input.  This can be a public URL, or you can also use the begin-editing API to upload a document and pass in the secure URL result from that operation as the URL here (this URL is not public).  # noqa: E501

        :param input_file_url: The input_file_url of this UpdateDocxTableRowRequest.  # noqa: E501
        :type: str
        """

        self._input_file_url = input_file_url

    @property
    def row_to_update(self):
        """Gets the row_to_update of this UpdateDocxTableRowRequest.  # noqa: E501

        Table row contents you would like to update the row with  # noqa: E501

        :return: The row_to_update of this UpdateDocxTableRowRequest.  # noqa: E501
        :rtype: DocxTableRow
        """
        return self._row_to_update

    @row_to_update.setter
    def row_to_update(self, row_to_update):
        """Sets the row_to_update of this UpdateDocxTableRowRequest.

        Table row contents you would like to update the row with  # noqa: E501

        :param row_to_update: The row_to_update of this UpdateDocxTableRowRequest.  # noqa: E501
        :type: DocxTableRow
        """

        self._row_to_update = row_to_update

    @property
    def table_row_index(self):
        """Gets the table_row_index of this UpdateDocxTableRowRequest.  # noqa: E501

        0-based index of the Table Row to update  # noqa: E501

        :return: The table_row_index of this UpdateDocxTableRowRequest.  # noqa: E501
        :rtype: int
        """
        return self._table_row_index

    @table_row_index.setter
    def table_row_index(self, table_row_index):
        """Sets the table_row_index of this UpdateDocxTableRowRequest.

        0-based index of the Table Row to update  # noqa: E501

        :param table_row_index: The table_row_index of this UpdateDocxTableRowRequest.  # noqa: E501
        :type: int
        """

        self._table_row_index = table_row_index

    @property
    def existing_table_path(self):
        """Gets the existing_table_path of this UpdateDocxTableRowRequest.  # noqa: E501

        Required; the path to the existing table to modify  # noqa: E501

        :return: The existing_table_path of this UpdateDocxTableRowRequest.  # noqa: E501
        :rtype: str
        """
        return self._existing_table_path

    @existing_table_path.setter
    def existing_table_path(self, existing_table_path):
        """Sets the existing_table_path of this UpdateDocxTableRowRequest.

        Required; the path to the existing table to modify  # noqa: E501

        :param existing_table_path: The existing_table_path of this UpdateDocxTableRowRequest.  # noqa: E501
        :type: str
        """

        self._existing_table_path = existing_table_path

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(UpdateDocxTableRowRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UpdateDocxTableRowRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
