# coding: utf-8

"""
    convertapi

    Convert API lets you effortlessly convert file formats and types.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cloudmersive_convert_api_client.models.docx_comment import DocxComment  # noqa: F401,E501


class DocxInsertCommentOnParagraphRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'input_file_bytes': 'str',
        'input_file_url': 'str',
        'paragraph_path': 'str',
        'comment_to_insert': 'DocxComment'
    }

    attribute_map = {
        'input_file_bytes': 'InputFileBytes',
        'input_file_url': 'InputFileUrl',
        'paragraph_path': 'ParagraphPath',
        'comment_to_insert': 'CommentToInsert'
    }

    def __init__(self, input_file_bytes=None, input_file_url=None, paragraph_path=None, comment_to_insert=None):  # noqa: E501
        """DocxInsertCommentOnParagraphRequest - a model defined in Swagger"""  # noqa: E501

        self._input_file_bytes = None
        self._input_file_url = None
        self._paragraph_path = None
        self._comment_to_insert = None
        self.discriminator = None

        if input_file_bytes is not None:
            self.input_file_bytes = input_file_bytes
        if input_file_url is not None:
            self.input_file_url = input_file_url
        if paragraph_path is not None:
            self.paragraph_path = paragraph_path
        if comment_to_insert is not None:
            self.comment_to_insert = comment_to_insert

    @property
    def input_file_bytes(self):
        """Gets the input_file_bytes of this DocxInsertCommentOnParagraphRequest.  # noqa: E501

        Optional: Bytes of the input file to operate on  # noqa: E501

        :return: The input_file_bytes of this DocxInsertCommentOnParagraphRequest.  # noqa: E501
        :rtype: str
        """
        return self._input_file_bytes

    @input_file_bytes.setter
    def input_file_bytes(self, input_file_bytes):
        """Sets the input_file_bytes of this DocxInsertCommentOnParagraphRequest.

        Optional: Bytes of the input file to operate on  # noqa: E501

        :param input_file_bytes: The input_file_bytes of this DocxInsertCommentOnParagraphRequest.  # noqa: E501
        :type: str
        """
        if input_file_bytes is not None and not re.search(r'^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$', input_file_bytes):  # noqa: E501
            raise ValueError(r"Invalid value for `input_file_bytes`, must be a follow pattern or equal to `/^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$/`")  # noqa: E501

        self._input_file_bytes = input_file_bytes

    @property
    def input_file_url(self):
        """Gets the input_file_url of this DocxInsertCommentOnParagraphRequest.  # noqa: E501

        Optional: URL of a file to operate on as input.  This can be a public URL, or you can also use the begin-editing API to upload a document and pass in the secure URL result from that operation as the URL here (this URL is not public).  # noqa: E501

        :return: The input_file_url of this DocxInsertCommentOnParagraphRequest.  # noqa: E501
        :rtype: str
        """
        return self._input_file_url

    @input_file_url.setter
    def input_file_url(self, input_file_url):
        """Sets the input_file_url of this DocxInsertCommentOnParagraphRequest.

        Optional: URL of a file to operate on as input.  This can be a public URL, or you can also use the begin-editing API to upload a document and pass in the secure URL result from that operation as the URL here (this URL is not public).  # noqa: E501

        :param input_file_url: The input_file_url of this DocxInsertCommentOnParagraphRequest.  # noqa: E501
        :type: str
        """

        self._input_file_url = input_file_url

    @property
    def paragraph_path(self):
        """Gets the paragraph_path of this DocxInsertCommentOnParagraphRequest.  # noqa: E501

        Path to the paragraph to attach the comment to.  You can get the Path by retrieving all of the Paragraphs in document by calling Get Body and taking the Path property of the desired paragraph to add the comment to.  # noqa: E501

        :return: The paragraph_path of this DocxInsertCommentOnParagraphRequest.  # noqa: E501
        :rtype: str
        """
        return self._paragraph_path

    @paragraph_path.setter
    def paragraph_path(self, paragraph_path):
        """Sets the paragraph_path of this DocxInsertCommentOnParagraphRequest.

        Path to the paragraph to attach the comment to.  You can get the Path by retrieving all of the Paragraphs in document by calling Get Body and taking the Path property of the desired paragraph to add the comment to.  # noqa: E501

        :param paragraph_path: The paragraph_path of this DocxInsertCommentOnParagraphRequest.  # noqa: E501
        :type: str
        """

        self._paragraph_path = paragraph_path

    @property
    def comment_to_insert(self):
        """Gets the comment_to_insert of this DocxInsertCommentOnParagraphRequest.  # noqa: E501

        Comment to insert  # noqa: E501

        :return: The comment_to_insert of this DocxInsertCommentOnParagraphRequest.  # noqa: E501
        :rtype: DocxComment
        """
        return self._comment_to_insert

    @comment_to_insert.setter
    def comment_to_insert(self, comment_to_insert):
        """Sets the comment_to_insert of this DocxInsertCommentOnParagraphRequest.

        Comment to insert  # noqa: E501

        :param comment_to_insert: The comment_to_insert of this DocxInsertCommentOnParagraphRequest.  # noqa: E501
        :type: DocxComment
        """

        self._comment_to_insert = comment_to_insert

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DocxInsertCommentOnParagraphRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DocxInsertCommentOnParagraphRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
