# coding: utf-8

"""
    convertapi

    Convert API lets you effortlessly convert file formats and types.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from cloudmersive_convert_api_client.api_client import ApiClient


class ZipArchiveApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def zip_archive_zip_create(self, input_file1, **kwargs):  # noqa: E501
        """Compress files to create a new zip archive  # noqa: E501

        Create a new zip archive by compressing input files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.zip_archive_zip_create(input_file1, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file1: First input file to perform the operation on. (required)
        :param file input_file2: Second input file to perform the operation on.
        :param file input_file3: Third input file to perform the operation on.
        :param file input_file4: Fourth input file to perform the operation on.
        :param file input_file5: Fifth input file to perform the operation on.
        :param file input_file6: Sixth input file to perform the operation on.
        :param file input_file7: Seventh input file to perform the operation on.
        :param file input_file8: Eighth input file to perform the operation on.
        :param file input_file9: Ninth input file to perform the operation on.
        :param file input_file10: Tenth input file to perform the operation on.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.zip_archive_zip_create_with_http_info(input_file1, **kwargs)  # noqa: E501
        else:
            (data) = self.zip_archive_zip_create_with_http_info(input_file1, **kwargs)  # noqa: E501
            return data

    def zip_archive_zip_create_with_http_info(self, input_file1, **kwargs):  # noqa: E501
        """Compress files to create a new zip archive  # noqa: E501

        Create a new zip archive by compressing input files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.zip_archive_zip_create_with_http_info(input_file1, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file1: First input file to perform the operation on. (required)
        :param file input_file2: Second input file to perform the operation on.
        :param file input_file3: Third input file to perform the operation on.
        :param file input_file4: Fourth input file to perform the operation on.
        :param file input_file5: Fifth input file to perform the operation on.
        :param file input_file6: Sixth input file to perform the operation on.
        :param file input_file7: Seventh input file to perform the operation on.
        :param file input_file8: Eighth input file to perform the operation on.
        :param file input_file9: Ninth input file to perform the operation on.
        :param file input_file10: Tenth input file to perform the operation on.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file1', 'input_file2', 'input_file3', 'input_file4', 'input_file5', 'input_file6', 'input_file7', 'input_file8', 'input_file9', 'input_file10']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method zip_archive_zip_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file1' is set
        if ('input_file1' not in params or
                params['input_file1'] is None):
            raise ValueError("Missing the required parameter `input_file1` when calling `zip_archive_zip_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'input_file1' in params:
            local_var_files['inputFile1'] = params['input_file1']  # noqa: E501
        if 'input_file2' in params:
            local_var_files['inputFile2'] = params['input_file2']  # noqa: E501
        if 'input_file3' in params:
            local_var_files['inputFile3'] = params['input_file3']  # noqa: E501
        if 'input_file4' in params:
            local_var_files['inputFile4'] = params['input_file4']  # noqa: E501
        if 'input_file5' in params:
            local_var_files['inputFile5'] = params['input_file5']  # noqa: E501
        if 'input_file6' in params:
            local_var_files['inputFile6'] = params['input_file6']  # noqa: E501
        if 'input_file7' in params:
            local_var_files['inputFile7'] = params['input_file7']  # noqa: E501
        if 'input_file8' in params:
            local_var_files['inputFile8'] = params['input_file8']  # noqa: E501
        if 'input_file9' in params:
            local_var_files['inputFile9'] = params['input_file9']  # noqa: E501
        if 'input_file10' in params:
            local_var_files['inputFile10'] = params['input_file10']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/archive/zip/create', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def zip_archive_zip_create_advanced(self, request, **kwargs):  # noqa: E501
        """Compress files and folders to create a new zip archive with advanced options  # noqa: E501

        Create a new zip archive by compressing input files, folders and leverage advanced options to control the structure of the resulting zip archive.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.zip_archive_zip_create_advanced(request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateZipArchiveRequest request: Input request (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.zip_archive_zip_create_advanced_with_http_info(request, **kwargs)  # noqa: E501
        else:
            (data) = self.zip_archive_zip_create_advanced_with_http_info(request, **kwargs)  # noqa: E501
            return data

    def zip_archive_zip_create_advanced_with_http_info(self, request, **kwargs):  # noqa: E501
        """Compress files and folders to create a new zip archive with advanced options  # noqa: E501

        Create a new zip archive by compressing input files, folders and leverage advanced options to control the structure of the resulting zip archive.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.zip_archive_zip_create_advanced_with_http_info(request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateZipArchiveRequest request: Input request (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method zip_archive_zip_create_advanced" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `zip_archive_zip_create_advanced`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/archive/zip/create/advanced', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def zip_archive_zip_decrypt(self, input_file, zip_password, **kwargs):  # noqa: E501
        """Decrypt and remove password protection on a zip file  # noqa: E501

        Decrypts and removes password protection from an encrypted zip file with the specified password  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.zip_archive_zip_decrypt(input_file, zip_password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :param str zip_password: Required; Password for the input archive (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.zip_archive_zip_decrypt_with_http_info(input_file, zip_password, **kwargs)  # noqa: E501
        else:
            (data) = self.zip_archive_zip_decrypt_with_http_info(input_file, zip_password, **kwargs)  # noqa: E501
            return data

    def zip_archive_zip_decrypt_with_http_info(self, input_file, zip_password, **kwargs):  # noqa: E501
        """Decrypt and remove password protection on a zip file  # noqa: E501

        Decrypts and removes password protection from an encrypted zip file with the specified password  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.zip_archive_zip_decrypt_with_http_info(input_file, zip_password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :param str zip_password: Required; Password for the input archive (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file', 'zip_password']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method zip_archive_zip_decrypt" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `zip_archive_zip_decrypt`")  # noqa: E501
        # verify the required parameter 'zip_password' is set
        if ('zip_password' not in params or
                params['zip_password'] is None):
            raise ValueError("Missing the required parameter `zip_password` when calling `zip_archive_zip_decrypt`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'zip_password' in params:
            header_params['zipPassword'] = params['zip_password']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/archive/zip/decrypt', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def zip_archive_zip_encrypt_advanced(self, encryption_request, **kwargs):  # noqa: E501
        """Encrypt and password protect a zip file  # noqa: E501

        Encrypts and password protects an existing zip file with the specified password and encryption algorithm  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.zip_archive_zip_encrypt_advanced(encryption_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ZipEncryptionAdvancedRequest encryption_request: Encryption request (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.zip_archive_zip_encrypt_advanced_with_http_info(encryption_request, **kwargs)  # noqa: E501
        else:
            (data) = self.zip_archive_zip_encrypt_advanced_with_http_info(encryption_request, **kwargs)  # noqa: E501
            return data

    def zip_archive_zip_encrypt_advanced_with_http_info(self, encryption_request, **kwargs):  # noqa: E501
        """Encrypt and password protect a zip file  # noqa: E501

        Encrypts and password protects an existing zip file with the specified password and encryption algorithm  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.zip_archive_zip_encrypt_advanced_with_http_info(encryption_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ZipEncryptionAdvancedRequest encryption_request: Encryption request (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['encryption_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method zip_archive_zip_encrypt_advanced" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'encryption_request' is set
        if ('encryption_request' not in params or
                params['encryption_request'] is None):
            raise ValueError("Missing the required parameter `encryption_request` when calling `zip_archive_zip_encrypt_advanced`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'encryption_request' in params:
            body_params = params['encryption_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/archive/zip/encrypt/advanced', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def zip_archive_zip_extract(self, input_file, **kwargs):  # noqa: E501
        """Extract, decompress files and folders from a zip archive  # noqa: E501

        Extracts a zip archive by decompressing files, and folders.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.zip_archive_zip_extract(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: ZipExtractResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.zip_archive_zip_extract_with_http_info(input_file, **kwargs)  # noqa: E501
        else:
            (data) = self.zip_archive_zip_extract_with_http_info(input_file, **kwargs)  # noqa: E501
            return data

    def zip_archive_zip_extract_with_http_info(self, input_file, **kwargs):  # noqa: E501
        """Extract, decompress files and folders from a zip archive  # noqa: E501

        Extracts a zip archive by decompressing files, and folders.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.zip_archive_zip_extract_with_http_info(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: ZipExtractResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method zip_archive_zip_extract" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `zip_archive_zip_extract`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/archive/zip/extract', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ZipExtractResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
