# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['lirc', 'lirc.connection', 'tests']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'lirc',
    'version': '2.0.1',
    'description': 'Interact with the daemon in the Linux Infrared Remote Control package',
    'long_description': 'LIRC Python Package\n===================\n\n.. image:: https://img.shields.io/pypi/pyversions/lirc\n   :target: https://www.python.org/downloads/\n   :alt: Python Version\n.. image:: https://img.shields.io/pypi/v/lirc\n   :target: https://pypi.org/project/lirc/\n   :alt: Project Version\n.. image:: https://readthedocs.org/projects/lirc/badge/?version=latest\n  :target: https://lirc.readthedocs.io/en/latest/?badge=latest\n  :alt: Documentation Status\n.. image:: https://github.com/eugenetriguba/lirc/workflows/python%20package%20ci/badge.svg?branch=master\n  :target: https://github.com/eugenetriguba/lirc/actions/\n  :alt: Build Status\n.. image:: https://codecov.io/gh/eugenetriguba/lirc/graph/badge.svg\n  :target: https://codecov.io/gh/eugenetriguba/lirc\n  :alt: Code Coverage\n.. image:: https://api.codeclimate.com/v1/badges/62b96571ae84f2895531/maintainability\n   :target: https://codeclimate.com/github/eugenetriguba/lirc/maintainability\n   :alt: Maintainability\n.. image:: https://img.shields.io/badge/code%20style-black-000000.svg\n    :target: https://github.com/psf/black\n    :alt: Code Formatter\n.. image:: https://img.shields.io/badge/contributions-welcome-brightgreen.svg\n    :target: https://github.com/eugenetriguba/lirc/issues\n    :alt: Contributing\n.. image:: https://img.shields.io/pypi/l/lirc\n   :target: https://pypi.python.org/pypi/lirc/\n   :alt: License\n.. image:: https://img.shields.io/badge/platform-linux%20%7C%20macos%20%7C%20windows-%23F9F9F9\n   :target: https://lirc.readthedocs.io/en/latest/installation.html\n   :alt: Platform Support\n\nThis is a python package that allows you to interact with the daemon in the\n`Linux Infrared Remote Control <https://lirc.org>`_ package. By interacting\nwith this daemon, it allows you to programmatically send IR signals from a\ncomputer.\n\nThis package is for emitting IR signals, but it does not support listening to\nIR codes. If you\'d like to monitor the IR signals you recieve on\nLinux, which has built-in support in the kernel for recieving IR signals, you\ncan try using `python-evdev <https://python-evdev.readthedocs.io/en/latest/>`_.\nThey have a `tutorial on reading the events <https://python-evdev.readthedocs.io/en/latest/tutorial.html#reading-events>`_.\n\nMore information on the lircd daemon, socket interface,\nreply packet format, etc. can be found at https://www.lirc.org/html/lircd.html\n\nMaintainance Status\n-------------------\n\nThis project is maintained, but it is not actively developed.\nIt is feature complete for my purposes.\n\nInstallation\n------------\n\nThis package is hosted on PyPI and can be installed\nthrough pip.\n\n.. code-block:: bash\n\n  $ pip install lirc\n\nHowever since this is a wrapper around the LIRC daemon, it\nis expected that LIRC is installed and setup on the given\nsystem as well.\n\nMore information on that can be found in the `installation <https://lirc.readthedocs.io/en/latest/installation.html>`_\nportion of the full documentation.\n\nQuick Start\n-----------\n\nUsing the Client\n^^^^^^^^^^^^^^^^\n\n.. code-block:: python\n\n  import lirc\n\n  client = lirc.Client()\n\n  print(client.version())\n  >>> \'0.10.1\'\n\nTo use this package, we instantiate a ``Client``. By initializing it\nwith no arguments, the ``Client`` will attempt to connect to the lirc\ndaemon with the default connection parameters for your operating system.\n\nThese defaults depend on your operating system and can be looked up in the\nfull documentation if you need different parameters.\n\nHowever, if you\'ve instantiated the ``Client`` without any arguments,\nyou don\'t get any errors, and you recieve a response from the ``version()``\ncommand, you are connected to the daemon. Most people should not need to\nchange the default parameters.\n\nCustomizing the Client\n^^^^^^^^^^^^^^^^^^^^^^\n\nAs previously stated, we can customize these defaults if needed.\n\n.. code-block:: python\n\n  import socket\n  import lirc\n\n  client = lirc.Client(\n    connection=lirc.LircdConnection(\n      address="/var/run/lirc/lircd",\n      socket=socket.socket(socket.AF_UNIX, socket.SOCK_STREAM),\n      timeout = 5.0\n    )\n  )\n\nFor the client in the example above, we set it up using the defaults for a Linux machine.\nWhile this example illustrates what is customizable, it is not a practical example since\nyou could call ``Client()`` with no arguments if you\'re on Linux and achieve the same outcome.\n\nSee `Overriding LIRC Defaults on Initialization <https://lirc.readthedocs.io/en/stable/usage.html#overriding-lirc-defaults-on-initialization>`_\nfor more information.\n\nSending IR\n^^^^^^^^^^\n\n.. code-block:: python\n\n  import lirc\n\n  client = lirc.Client()\n  client.send_once("my-remote-name", "KEY_POWER")\n\n  # Go to channel "33"\n  client.send_once("my-remote-name", "KEY_3", repeat_count=1)\n\n\nWith sending IR, we can use the `send_once` method and optionally,\nsend multiple by using the `repeat_count` keyword argument.\n\nHandling Errors\n^^^^^^^^^^^^^^^\n\n.. code-block:: python\n\n  import lirc\n\n  client = lirc.Client()\n\n  try:\n      client.send_once(\'some-remote\', \'key_power\')\n  except lirc.exceptions.LircdCommandFailureError as error:\n      print(\'Unable to send the power key!\')\n      print(error)  # Error has more info on what lircd sent back.\n\nIf the command was not successful, a ``LircdCommandFailureError``\nexception will be thrown.\n\nFurther Documentation\n---------------------\n\nMore information on how to setup the system installed LIRC, how to use\nthis python library, and a full API specification can be found at\nhttps://lirc.readthedocs.io/\n',
    'author': 'Eugene Triguba',
    'author_email': 'eugenetriguba@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/eugenetriguba/lirc',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
